/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.expr.ModifyStatement;
import org.drools.mvel.parser.ast.expr.WithStatement;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.MvelCompilerException;

public class PreprocessPhase {
    private final boolean failOnEmptyRootScope;

    public PreprocessPhase() {
        this(false);
    }

    public PreprocessPhase(boolean failOnEmptyRootScope) {
        this.failOnEmptyRootScope = failOnEmptyRootScope;
    }

    public PreprocessPhaseResult invoke(Statement statement) {
        if (statement instanceof ModifyStatement) {
            return this.modifyPreprocessor((ModifyStatement)statement);
        }
        if (statement instanceof WithStatement) {
            return this.withPreprocessor((WithStatement)statement);
        }
        return new StatementResult().addOtherStatements(Collections.singletonList(statement));
    }

    private PreprocessPhaseResult modifyPreprocessor(ModifyStatement modifyStatement) {
        PreprocessedResult result = new PreprocessedResult();
        Expression scope = modifyStatement.getModifyObject();
        modifyStatement.findAll(AssignExpr.class).replaceAll(assignExpr -> this.assignToFieldAccess(result, scope, (AssignExpr)assignExpr));
        modifyStatement.getExpressions().replaceAll(e -> this.addScopeToMethodCallExpr(result, scope, (Statement)e));
        List<Statement> statements = this.wrapToExpressionStmt((NodeList<Statement>)modifyStatement.getExpressions());
        return result.addOtherStatements(statements);
    }

    private PreprocessPhaseResult withPreprocessor(WithStatement withStatement) {
        StatementResult result = new StatementResult();
        Optional<Expression> initScope = this.addTypeToInitialization(withStatement, result);
        Expression scope = initScope.orElse(withStatement.getWithObject());
        withStatement.findAll(AssignExpr.class).replaceAll(assignExpr -> this.assignToFieldAccess(result, scope, (AssignExpr)assignExpr));
        withStatement.getExpressions().replaceAll(e -> this.addScopeToMethodCallExpr(result, scope, (Statement)e));
        List<Statement> statements = this.wrapToExpressionStmt((NodeList<Statement>)withStatement.getExpressions());
        return result.addOtherStatements(statements);
    }

    private Optional<Expression> addTypeToInitialization(WithStatement withStatement, PreprocessPhaseResult result) {
        if (withStatement.getWithObject().isAssignExpr()) {
            AssignExpr assignExpr = withStatement.getWithObject().asAssignExpr();
            Expression assignExprValue = assignExpr.getValue();
            Expression assignExprTarget = assignExpr.getTarget();
            if (assignExprValue.isObjectCreationExpr() && assignExprTarget instanceof DrlNameExpr) {
                ObjectCreationExpr constructor = assignExprValue.asObjectCreationExpr();
                ClassOrInterfaceType ctorType = constructor.getType();
                String targetVariableName = ((DrlNameExpr)assignExprTarget).getNameAsString();
                VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr((Type)ctorType, targetVariableName);
                AssignExpr withTypeAssignmentExpr = new AssignExpr((Expression)variableDeclarationExpr, assignExprValue, assignExpr.getOperator());
                ExpressionStmt expressionStmt = new ExpressionStmt((Expression)withTypeAssignmentExpr);
                result.addNewObjectStatements(expressionStmt);
                return Optional.of(new DrlNameExpr(targetVariableName));
            }
        }
        return Optional.empty();
    }

    private List<Statement> wrapToExpressionStmt(NodeList<Statement> expressions) {
        return expressions.stream().filter(Objects::nonNull).filter(Statement::isExpressionStmt).map(s -> s.asExpressionStmt().getExpression()).map(ExpressionStmt::new).collect(Collectors.toList());
    }

    private Statement addScopeToMethodCallExpr(PreprocessPhaseResult result, Expression scope, Statement e) {
        Expression expression;
        if (e != null && e.isExpressionStmt() && (expression = e.asExpressionStmt().getExpression()).isMethodCallExpr()) {
            MethodCallExpr mcExpr = expression.asMethodCallExpr();
            MethodCallExpr rootMcExpr = this.findRootScope(mcExpr);
            if (rootMcExpr == null) {
                return e;
            }
            EnclosedExpr enclosed = new EnclosedExpr(scope);
            rootMcExpr.setScope((Expression)enclosed);
            if (scope.isNameExpr() || scope instanceof DrlNameExpr) {
                result.addUsedBinding(PrintUtil.printConstraint((Node)scope));
            }
            return new ExpressionStmt((Expression)mcExpr);
        }
        return e;
    }

    private MethodCallExpr findRootScope(MethodCallExpr mcExpr) {
        Optional opt = mcExpr.getScope();
        if (!opt.isPresent()) {
            return mcExpr;
        }
        Expression scope = (Expression)opt.get();
        if (scope.isMethodCallExpr()) {
            return this.findRootScope(scope.asMethodCallExpr());
        }
        if (this.failOnEmptyRootScope) {
            throw new MvelCompilerException("Invalid modify statement: " + mcExpr);
        }
        return null;
    }

    private AssignExpr assignToFieldAccess(PreprocessPhaseResult result, Expression scope, AssignExpr assignExpr) {
        DrlNameExpr originalFieldAccess = (DrlNameExpr)assignExpr.getTarget();
        String propertyName = originalFieldAccess.getName().asString();
        result.addUsedBinding(PrintUtil.printConstraint((Node)scope));
        FieldAccessExpr fieldAccessWithScope = new FieldAccessExpr(scope, propertyName);
        assignExpr.setTarget((Expression)fieldAccessWithScope);
        return assignExpr;
    }

    public void removeEmptyStmt(BlockStmt blockStmt) {
        blockStmt.findAll(EmptyStmt.class).forEach(Node::remove);
    }

    static class StatementResult
    implements PreprocessPhaseResult {
        final List<Statement> newObjectStatements = new ArrayList<Statement>();
        final List<Statement> otherStatements = new ArrayList<Statement>();

        StatementResult() {
        }

        @Override
        public Set<String> getUsedBindings() {
            return new HashSet<String>();
        }

        @Override
        public PreprocessPhaseResult addUsedBinding(String bindingName) {
            return this;
        }

        @Override
        public List<Statement> getNewObjectStatements() {
            return this.newObjectStatements;
        }

        @Override
        public List<Statement> getOtherStatements() {
            return this.otherStatements;
        }

        @Override
        public PreprocessPhaseResult addOtherStatements(List<Statement> statements) {
            this.otherStatements.addAll(statements);
            return this;
        }

        @Override
        public PreprocessPhaseResult addNewObjectStatements(ExpressionStmt expressionStmt) {
            this.newObjectStatements.add((Statement)expressionStmt);
            return this;
        }
    }

    static class PreprocessedResult
    implements PreprocessPhaseResult {
        final List<Statement> newObjectStatements = new ArrayList<Statement>();
        final List<Statement> otherStatements = new ArrayList<Statement>();
        final Set<String> usedBindings = new HashSet<String>();

        PreprocessedResult() {
        }

        @Override
        public PreprocessPhaseResult addUsedBinding(String bindingName) {
            this.usedBindings.add(bindingName);
            return this;
        }

        @Override
        public Set<String> getUsedBindings() {
            return this.usedBindings;
        }

        @Override
        public List<Statement> getNewObjectStatements() {
            return this.newObjectStatements;
        }

        @Override
        public List<Statement> getOtherStatements() {
            return this.otherStatements;
        }

        @Override
        public PreprocessPhaseResult addOtherStatements(List<Statement> statements) {
            this.otherStatements.addAll(statements);
            return this;
        }

        @Override
        public PreprocessPhaseResult addNewObjectStatements(ExpressionStmt expressionStmt) {
            this.newObjectStatements.add((Statement)expressionStmt);
            return this;
        }
    }

    static interface PreprocessPhaseResult {
        public Set<String> getUsedBindings();

        public PreprocessPhaseResult addUsedBinding(String var1);

        public List<Statement> getNewObjectStatements();

        public List<Statement> getOtherStatements();

        public PreprocessPhaseResult addOtherStatements(List<Statement> var1);

        public PreprocessPhaseResult addNewObjectStatements(ExpressionStmt var1);
    }
}

