/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.whitelist;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListFilter;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListLoader;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListSaver;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;

@Service
@ApplicationScoped
public class PackageNameWhiteListServiceImpl
implements PackageNameWhiteListService {
    private IOService ioService;
    private KieModuleService moduleService;
    private PackageNameWhiteListLoader loader;
    private PackageNameWhiteListSaver saver;

    public PackageNameWhiteListServiceImpl() {
    }

    @Inject
    public PackageNameWhiteListServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, PackageNameWhiteListLoader loader, PackageNameWhiteListSaver saver) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.loader = loader;
        this.saver = saver;
    }

    public void createModuleWhiteList(Path packageNamesWhiteListPath, String initialContent) {
        if (this.ioService.exists(Paths.convert((Path)packageNamesWhiteListPath))) {
            throw new FileAlreadyExistsException(packageNamesWhiteListPath.toString());
        }
        this.ioService.write(Paths.convert((Path)packageNamesWhiteListPath), initialContent, new OpenOption[0]);
    }

    public WhiteList filterPackageNames(Module module, Collection<String> packageNames) {
        if (packageNames == null) {
            return new WhiteList();
        }
        if (module instanceof KieModule) {
            WhiteList whiteList = this.load(((KieModule)module).getPackageNamesWhiteListPath());
            if (whiteList.isEmpty()) {
                return new WhiteList(packageNames);
            }
            for (Package aPackage : this.moduleService.resolvePackages(module)) {
                whiteList.add(aPackage.getPackageName());
            }
            return new PackageNameWhiteListFilter(packageNames, whiteList).getFilteredPackageNames();
        }
        return new WhiteList(packageNames);
    }

    public WhiteList load(Path packageNamesWhiteListPath) {
        return this.loader.load(packageNamesWhiteListPath);
    }

    public Path save(Path path, WhiteList content, Metadata metadata, String comment) {
        return this.saver.save(path, content, metadata, comment);
    }
}

