/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm.services;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.command.Command;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionalCommandService
extends TransactionalCommandService {
    private AbstractPlatformTransactionManager transactionManager;
    private EntityManager sharedEntityManager;
    private DefaultTransactionDefinition defTransDefinition = new DefaultTransactionDefinition();

    public SpringTransactionalCommandService(EntityManagerFactory emf, TransactionManager txm, AbstractPlatformTransactionManager transactionManager) {
        super(emf, txm);
        this.transactionManager = transactionManager;
    }

    public SpringTransactionalCommandService(EntityManagerFactory emf, TransactionManager txm, AbstractPlatformTransactionManager transactionManager, EntityManager sharedEntityManager) {
        super(emf, txm);
        this.transactionManager = transactionManager;
        this.sharedEntityManager = sharedEntityManager;
    }

    public SpringTransactionalCommandService(EntityManagerFactory emf, TransactionManager txm) {
        super(emf, txm);
    }

    public SpringTransactionalCommandService(EntityManagerFactory emf, AbstractPlatformTransactionManager transactionManager) {
        super(emf);
        this.transactionManager = transactionManager;
    }

    public SpringTransactionalCommandService(EntityManagerFactory emf, AbstractPlatformTransactionManager transactionManager, EntityManager sharedEntityManager) {
        super(emf);
        this.transactionManager = transactionManager;
        this.sharedEntityManager = sharedEntityManager;
    }

    public <T> T execute(Command<T> command) {
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)this.defTransDefinition);
        try {
            Object result = super.execute(command);
            this.transactionManager.commit(status);
            return (T)result;
        }
        catch (Throwable e) {
            this.transactionManager.rollback(status);
            throw new RuntimeException(e);
        }
    }

    public AbstractPlatformTransactionManager getPlatformTransactionManager() {
        return this.transactionManager;
    }

    public void setPlatformTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected EntityManager getEntityManager(Command<?> command) {
        if (this.sharedEntityManager != null) {
            return this.sharedEntityManager;
        }
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)"cmdEM");
        if (emHolder != null) {
            EntityManager em = emHolder.getEntityManager();
            EntityManagerFactory nativeEmf = ((EntityManagerFactoryInfo)this.emf).getNativeEntityManagerFactory();
            if (em != null && em.isOpen() && em.getEntityManagerFactory().equals(nativeEmf)) {
                return em;
            }
        }
        return super.getEntityManager(command);
    }
}

