/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class BoundaryEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = -4958054074031174180L;

    @Override
    public void signalEvent(String type, Object event) {
        BoundaryEventNode boundaryNode = (BoundaryEventNode)this.getEventNode();
        String attachedTo = boundaryNode.getAttachedToNodeId();
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        if (type != null && type.startsWith("Compensation")) {
            if (!this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event) && this.isAttachedToNodeCompleted(attachedTo)) {
                super.signalEvent(type, event);
            } else {
                this.cancel();
            }
        } else if (this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event)) {
            super.signalEvent(type, event);
        } else {
            this.cancel();
        }
    }

    private boolean isAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                boolean hasActive;
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                boolean isActivating = ((WorkflowProcessInstanceImpl)nInstance.getProcessInstance()).getActivatingNodeIds().contains(nodeUniqueId);
                if (attachedTo.equals(nodeUniqueId) && !isActivating) {
                    if (type.startsWith("Timer-")) {
                        if (Long.valueOf(nInstance.getId()).equals(event)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                if (!(nInstance instanceof CompositeNodeInstance) || !(hasActive = this.isAttachedToNodeActive(((CompositeNodeInstance)nInstance).getNodeInstances(), attachedTo, type, event))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAttachedToNodeCompleted(String attachedTo) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        return processInstance.getCompletedNodeIds().contains(attachedTo);
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
    }
}

