/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.index;

import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.engine.index.DataSetStaticIndex;
import org.dashbuilder.dataset.engine.index.spi.DataSetIndexRegistry;
import org.dashbuilder.dataset.uuid.UUIDGenerator;

public class TransientDataSetIndexRegistry
implements DataSetIndexRegistry {
    protected UUIDGenerator uuidGenerator;
    protected Map<String, DataSetIndex> indexMap = new HashMap<String, DataSetIndex>();

    public TransientDataSetIndexRegistry(UUIDGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    @Override
    public DataSetIndex put(DataSet dataSet) {
        if (dataSet == null) {
            return null;
        }
        String uuid = dataSet.getUUID();
        if (uuid == null || uuid.length() == 0) {
            uuid = this.uuidGenerator.newUuidBase64();
            dataSet.setUUID(uuid);
        }
        DataSetStaticIndex dsIndex = new DataSetStaticIndex(dataSet);
        this.indexMap.put(uuid, dsIndex);
        return dsIndex;
    }

    @Override
    public DataSetIndex get(String uuid) {
        DataSetIndex index = this.indexMap.get(uuid);
        if (index != null) {
            index.reuseHit();
        }
        return index;
    }

    @Override
    public DataSetIndex remove(String uuid) {
        return this.indexMap.remove(uuid);
    }
}

