/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import java.util.ArrayList;
import org.kie.server.services.taskassigning.core.TaskAssigningRuntimeException;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.kie.server.services.taskassigning.core.model.User;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class AssignTaskProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private Task task;
    private User user;
    private boolean addIfNotExists = false;

    public AssignTaskProblemFactChange(Task task, User user) {
        this.task = task;
        this.user = user;
    }

    public AssignTaskProblemFactChange(Task task, User user, boolean addIfNotExists) {
        this.task = task;
        this.user = user;
        this.addIfNotExists = addIfNotExists;
    }

    public Task getTask() {
        return this.task;
    }

    public User getUser() {
        return this.user;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        TaskAssigningSolution solution = (TaskAssigningSolution)scoreDirector.getWorkingSolution();
        User workingUser = (User)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.user);
        if (workingUser == null) {
            if (!this.addIfNotExists) {
                throw new TaskAssigningRuntimeException(String.format("Expected user: %s was not found in current working solution", this.user));
            }
            solution.setUserList(new ArrayList<User>(solution.getUserList()));
            scoreDirector.beforeProblemFactAdded((Object)this.user);
            solution.getUserList().add(this.user);
            scoreDirector.afterProblemFactAdded((Object)this.user);
            workingUser = this.user;
        }
        Task workingTask = (Task)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.task);
        TaskOrUser insertPosition = this.findInsertPosition(workingUser);
        Task insertPositionNextTask = insertPosition.getNextTask();
        boolean isNew = false;
        if (workingTask == null) {
            this.task.setPreviousTaskOrUser(null);
            this.task.setUser(null);
            this.task.setPinned(false);
            this.task.setNextTask(null);
            this.task.setStartTimeInMinutes(null);
            this.task.setEndTime(null);
            workingTask = this.task;
            isNew = true;
        }
        if (insertPosition != workingTask) {
            if (insertPosition.getNextTask() == workingTask) {
                scoreDirector.beforeProblemPropertyChanged((Object)workingTask);
                workingTask.setPinned(true);
                scoreDirector.afterProblemPropertyChanged((Object)workingTask);
                scoreDirector.triggerVariableListeners();
            } else {
                if (workingTask.getPreviousTaskOrUser() != null) {
                    TaskOrUser previousTaskOrUser = workingTask.getPreviousTaskOrUser();
                    Task nextTask = workingTask.getNextTask();
                    if (nextTask != null) {
                        scoreDirector.beforeVariableChanged((Object)nextTask, "previousTaskOrUser");
                        nextTask.setPreviousTaskOrUser(previousTaskOrUser);
                        scoreDirector.afterVariableChanged((Object)nextTask, "previousTaskOrUser");
                    }
                }
                if (isNew) {
                    workingTask.setPreviousTaskOrUser(insertPosition);
                    scoreDirector.beforeEntityAdded((Object)workingTask);
                    solution.getTaskList().add(workingTask);
                    scoreDirector.afterEntityAdded((Object)workingTask);
                } else {
                    scoreDirector.beforeVariableChanged((Object)workingTask, "previousTaskOrUser");
                    workingTask.setPreviousTaskOrUser(insertPosition);
                    scoreDirector.afterVariableChanged((Object)workingTask, "previousTaskOrUser");
                }
                if (insertPositionNextTask != null) {
                    scoreDirector.beforeVariableChanged((Object)insertPositionNextTask, "previousTaskOrUser");
                    insertPositionNextTask.setPreviousTaskOrUser(workingTask);
                    scoreDirector.afterVariableChanged((Object)insertPositionNextTask, "previousTaskOrUser");
                }
                scoreDirector.beforeProblemPropertyChanged((Object)workingTask);
                workingTask.setPinned(true);
                scoreDirector.afterProblemPropertyChanged((Object)workingTask);
                scoreDirector.triggerVariableListeners();
            }
        }
    }

    private TaskOrUser findInsertPosition(User user) {
        TaskOrUser result = user;
        for (Task nextTask = user.getNextTask(); nextTask != null && nextTask.isPinned(); nextTask = nextTask.getNextTask()) {
            result = nextTask;
        }
        return result;
    }
}

