/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import org.kie.server.services.taskassigning.core.TaskAssigningRuntimeException;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class TaskPropertyChangeProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private Task task;
    private String status;
    private Integer priority;

    public TaskPropertyChangeProblemFactChange(Task task) {
        this.task = task;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Task getTask() {
        return this.task;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        Task workingTask = (Task)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.task);
        if (workingTask == null) {
            throw new TaskAssigningRuntimeException(String.format("Expected task: %s was not found in current working solution", this.task));
        }
        if (this.priority != null) {
            scoreDirector.beforeProblemPropertyChanged((Object)workingTask);
            workingTask.setPriority(this.priority);
            scoreDirector.afterProblemPropertyChanged((Object)workingTask);
        }
        if (this.status != null) {
            scoreDirector.beforeProblemPropertyChanged((Object)workingTask);
            workingTask.setStatus(this.status);
            scoreDirector.afterProblemPropertyChanged((Object)workingTask);
        }
        scoreDirector.triggerVariableListeners();
    }
}

