/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerContainerDeployment {
    private static final Logger LOG = LoggerFactory.getLogger(KieServerContainerDeployment.class);
    private final String containerId;
    private final String containerAlias;
    private final ReleaseId releaseId;

    public KieServerContainerDeployment(String containerId, ReleaseId releaseId) {
        this(containerId, null, releaseId);
    }

    public KieServerContainerDeployment(String containerId, String containerAlias, ReleaseId releaseId) {
        if (containerId == null || containerId.trim().isEmpty()) {
            throw new IllegalArgumentException("illegal containerId: " + containerId);
        }
        if (releaseId == null) {
            throw new IllegalArgumentException("null releaseId");
        }
        this.containerId = containerId;
        if (containerAlias != null && (containerAlias = containerAlias.trim()).length() == 0) {
            containerAlias = null;
        }
        this.containerAlias = containerAlias;
        this.releaseId = releaseId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerAlias() {
        return this.containerAlias;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KieServerContainerDeployment)) {
            return false;
        }
        KieServerContainerDeployment other = (KieServerContainerDeployment)obj;
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals(other.containerId)) {
            return false;
        }
        if (this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias)) {
            return false;
        }
        return !(this.releaseId == null ? other.releaseId != null : !this.releaseId.equals(other.releaseId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
        result = 31 * result + (this.releaseId == null ? 0 : this.releaseId.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.containerId);
        if (this.containerAlias != null) {
            sb.append('(');
            sb.append(this.containerAlias);
            sb.append(')');
        }
        return sb.append('=').append(this.releaseId.getGroupId()).append(':').append(this.releaseId.getArtifactId()).append(':').append(this.releaseId.getVersion()).toString();
    }

    public static String toString(Collection<KieServerContainerDeployment> deployments) {
        StringBuilder sb = new StringBuilder();
        if (deployments != null) {
            Iterator<KieServerContainerDeployment> iter = deployments.iterator();
            while (iter.hasNext()) {
                KieServerContainerDeployment deployment = iter.next();
                sb.append(deployment.toString());
                if (!iter.hasNext()) continue;
                sb.append('|');
            }
        }
        return sb.toString();
    }

    public static Set<KieServerContainerDeployment> fromString(String str) {
        return KieServerContainerDeployment.fromString(str, true);
    }

    public static Set<KieServerContainerDeployment> fromString(String str, boolean onlyLatest) {
        LinkedHashSet<KieServerContainerDeployment> deployments = new LinkedHashSet<KieServerContainerDeployment>();
        if (str != null && !str.isEmpty()) {
            TreeMap<String, String> containerIds_containerAliases = new TreeMap<String, String>();
            TreeMap<String, TreeSet<ReleaseId>> containerIds_releaseIds = new TreeMap<String, TreeSet<ReleaseId>>();
            for (String unit : str.split("\\|")) {
                boolean recognized = false;
                String[] split = unit.split("=");
                if (split.length == 2) {
                    String containerId = null;
                    String containerAlias = null;
                    String identification = split[0].trim();
                    int left_paren_pos = identification.indexOf("(");
                    if (left_paren_pos > 0 && identification.endsWith(")")) {
                        containerId = identification.substring(0, left_paren_pos);
                        containerAlias = identification.substring(left_paren_pos + 1, identification.length() - 1);
                    } else {
                        containerId = identification;
                    }
                    String[] gav = split[1].trim().split(":");
                    if (!containerId.isEmpty() && gav.length == 3) {
                        recognized = true;
                        containerIds_containerAliases.put(containerId, containerAlias);
                        TreeSet<ReleaseId> releaseIds = (TreeSet<ReleaseId>)containerIds_releaseIds.get(containerId);
                        if (releaseIds == null) {
                            releaseIds = new TreeSet<ReleaseId>((Comparator<ReleaseId>)new ReleaseIdComparator(ReleaseIdComparator.SortDirection.DESCENDING));
                            containerIds_releaseIds.put(containerId, releaseIds);
                        }
                        releaseIds.add(KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]));
                    }
                }
                if (recognized || !LOG.isWarnEnabled()) continue;
                LOG.warn(String.format("skipping unrecognized deployment: %s", unit));
            }
            block1: for (Map.Entry entry : containerIds_releaseIds.entrySet()) {
                String containerId = (String)entry.getKey();
                String containerAlias = (String)containerIds_containerAliases.get(containerId);
                Set releaseIds = (Set)entry.getValue();
                for (ReleaseId releaseId : releaseIds) {
                    KieServerContainerDeployment deployment = new KieServerContainerDeployment(containerId, containerAlias, releaseId);
                    deployments.add(deployment);
                    if (!onlyLatest) continue;
                    continue block1;
                }
            }
        }
        return deployments;
    }
}

