/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class ErrorPopup {
    private final View view;

    @Inject
    public ErrorPopup(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void showError(String message) {
        this.showError(message, DisplayMode.PATTERN_FLY);
    }

    public void showError(String message, DisplayMode displayMode) {
        this.setMessage(message, displayMode);
        this.view.setDetailValue("");
        this.showDetailPanel(false);
        this.view.show();
    }

    public void showError(String message, String detail) {
        this.showError(message, detail, DisplayMode.PATTERN_FLY);
    }

    public void showError(String message, String detail, DisplayMode displayMode) {
        this.setMessage(message, displayMode);
        this.view.setDetailValue(detail);
        this.showDetailPanel(true);
        this.view.show();
    }

    private void setMessage(String message, DisplayMode displayMode) {
        if (displayMode == DisplayMode.STANDARD) {
            this.view.setNotification(this.view.getStandardNotification());
            this.view.setStandardNotificationValue(message);
        } else {
            this.view.setNotification(this.view.getInlineNotification());
            this.view.setInlineNotificationValue(message);
        }
    }

    private void showDetailPanel(boolean show) {
        this.view.setCollapseDetailIcon(true);
        this.view.setCollapseDetailPanel(true);
        this.view.setDetailLabel(this.view.getShowDetailLabel());
        this.view.showDetailPanel(show);
    }

    protected void onOk() {
        this.view.hide();
    }

    protected void onClose() {
        this.view.hide();
    }

    protected void onDetail() {
        boolean detailCollapsed = this.view.isDetailCollapsed();
        this.view.setCollapseDetailIcon(!detailCollapsed);
        if (detailCollapsed) {
            this.view.setDetailLabel(this.view.getCloseDetailLabel());
        } else {
            this.view.setDetailLabel(this.view.getShowDetailLabel());
        }
    }

    public static enum DisplayMode {
        STANDARD,
        PATTERN_FLY;

    }

    public static interface View
    extends UberElement<ErrorPopup> {
        public HTMLElement getInlineNotification();

        public HTMLElement getStandardNotification();

        public void setInlineNotificationValue(String var1);

        public void setStandardNotificationValue(String var1);

        public void setNotification(HTMLElement var1);

        public void showDetailPanel(boolean var1);

        public void setDetailValue(String var1);

        public boolean isDetailCollapsed();

        public void setCollapseDetailIcon(boolean var1);

        public void setCollapseDetailPanel(boolean var1);

        public void setDetailLabel(String var1);

        public String getShowDetailLabel();

        public String getCloseDetailLabel();

        public void show();

        public void hide();
    }
}

