/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;

@ApplicationScoped
public class ActivityBeansInfo {
    private static Comparator<String> ALPHABETICAL_ORDER = (str1, str2) -> {
        int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
        return res == 0 ? str1.compareTo((String)str2) : res;
    };
    private SyncBeanManager beanManager;
    private ActivityBeansCache activityBeansCache;

    @Inject
    public ActivityBeansInfo(SyncBeanManager beanManager, ActivityBeansCache activityBeansCache) {
        this.beanManager = beanManager;
        this.activityBeansCache = activityBeansCache;
    }

    public List<String> getAvailableWorkbenchScreensIds() {
        return this.lookupBeansId(WorkbenchScreenActivity.class);
    }

    public List<String> getAvailablePerspectivesIds() {
        return this.activityBeansCache.getPerspectiveActivities().stream().map(this::getId).sorted(ALPHABETICAL_ORDER).collect(Collectors.toList());
    }

    public List<String> getAvailableSplashScreensIds() {
        return this.lookupBeansId(SplashScreenActivity.class);
    }

    public List<String> getAvailableWorkbenchEditorsIds() {
        return this.lookupBeansId(WorkbenchEditorActivity.class);
    }

    public void addActivityBean(List<String> activityBeans, String newBean) {
        activityBeans.add(newBean);
        Collections.sort(activityBeans, ALPHABETICAL_ORDER);
    }

    private List<String> lookupBeansId(Class<?> activityClass) {
        return this.lookupBeans(activityClass).stream().map(this::getId).sorted(ALPHABETICAL_ORDER).collect(Collectors.toList());
    }

    public Collection<? extends IOCBeanDef<?>> lookupBeans(Class<?> activityClass) {
        return this.getBeanManager().lookupBeans(activityClass);
    }

    public String getId(IOCBeanDef<?> beanDef) {
        for (Annotation annotation : beanDef.getQualifiers()) {
            if (!this.isNamed(annotation)) continue;
            return ((Named)annotation).value();
        }
        if (this.hasBeanName(beanDef)) {
            return beanDef.getName();
        }
        return "";
    }

    boolean isNamed(Annotation annotation) {
        return annotation instanceof Named;
    }

    public SyncBeanManager getBeanManager() {
        return this.beanManager;
    }

    private boolean hasBeanName(IOCBeanDef<?> beanDef) {
        return beanDef.getName() != null && !beanDef.getName().isEmpty();
    }
}

