/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.AnnotationAttributeConfiguration;
import org.infinispan.protostream.config.AnnotationAttributeConfigurationImpl;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;

final class AnnotationConfigurationImpl
implements AnnotationConfiguration {
    private final String name;
    private final AnnotationElement.AnnotationTarget[] target;
    private final Map<String, AnnotationAttributeConfiguration> attributes;
    private final AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator;
    private final String repeatable;
    protected AnnotationConfigurationImpl container;

    private AnnotationConfigurationImpl(String name, AnnotationElement.AnnotationTarget[] target, Map<String, AnnotationAttributeConfiguration> attributes, AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator, String repeatable) {
        this.name = name;
        this.target = target;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.annotationMetadataCreator = annotationMetadataCreator;
        this.repeatable = repeatable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AnnotationElement.AnnotationTarget[] target() {
        return this.target;
    }

    @Override
    public Map<String, AnnotationAttributeConfiguration> attributes() {
        return this.attributes;
    }

    @Override
    public AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> metadataCreator() {
        return this.annotationMetadataCreator;
    }

    @Override
    public String repeatable() {
        return this.repeatable;
    }

    static final class BuilderImpl
    implements AnnotationConfiguration.Builder {
        private final Configuration.AnnotationsConfig.Builder parentBuilder;
        private final String name;
        private final AnnotationElement.AnnotationTarget[] target;
        private final Map<String, AnnotationAttributeConfiguration.Builder> attributeBuilders = new HashMap<String, AnnotationAttributeConfiguration.Builder>();
        private AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator;
        private String repeatable;

        BuilderImpl(Configuration.AnnotationsConfig.Builder parentBuilder, String name, AnnotationElement.AnnotationTarget[] target) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("annotation name must not be null or empty");
            }
            this.name = name;
            this.target = target;
            this.parentBuilder = parentBuilder;
        }

        @Override
        public AnnotationAttributeConfiguration.Builder attribute(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("attribute name must not be null or empty");
            }
            if (this.attributeBuilders.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate attribute name definition: " + name);
            }
            AnnotationAttributeConfigurationImpl.BuilderImpl builder = new AnnotationAttributeConfigurationImpl.BuilderImpl(this, name);
            this.attributeBuilders.put(name, builder);
            return builder;
        }

        @Override
        public AnnotationConfiguration.Builder metadataCreator(AnnotationMetadataCreator<?, ? extends AnnotatedDescriptor> annotationMetadataCreator) {
            this.annotationMetadataCreator = annotationMetadataCreator;
            return this;
        }

        @Override
        public AnnotationConfiguration.Builder repeatable(String containerAnnotationName) {
            if (containerAnnotationName == null) {
                throw new IllegalArgumentException("containerAnnotationName cannot be null");
            }
            if (this.name.equals(containerAnnotationName)) {
                throw new IllegalArgumentException("The name of the container annotation ('" + containerAnnotationName + "') cannot be identical to the name of this annotation: '" + this.name + "'");
            }
            this.repeatable = containerAnnotationName;
            this.parentBuilder.annotation(containerAnnotationName, this.target).attribute("value").type(AnnotationElement.AttributeType.ANNOTATION).allowedValues(this.name).multiple(true);
            return this;
        }

        @Override
        public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
            return this.parentBuilder.annotation(annotationName, target);
        }

        AnnotationConfigurationImpl buildAnnotationConfiguration() {
            HashMap<String, AnnotationAttributeConfiguration> attributes = new HashMap<String, AnnotationAttributeConfiguration>(this.attributeBuilders.size());
            for (AnnotationAttributeConfiguration.Builder attributeBuilder : this.attributeBuilders.values()) {
                AnnotationAttributeConfiguration annotationAttributeConfig = ((AnnotationAttributeConfigurationImpl.BuilderImpl)attributeBuilder).buildAnnotationAttributeConfiguration();
                attributes.put(annotationAttributeConfig.name(), annotationAttributeConfig);
            }
            return new AnnotationConfigurationImpl(this.name, this.target, attributes, this.annotationMetadataCreator, this.repeatable);
        }

        @Override
        public Configuration build() {
            return this.parentBuilder.build();
        }
    }
}

