/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.solver.drools;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrMachineCapacity;
import org.optaplanner.examples.machinereassignment.domain.MrResource;

public class MrMachineUsage
implements Serializable,
Comparable<MrMachineUsage> {
    private static final Comparator<MrMachineUsage> COMPARATOR = Comparator.comparing(machineUsage -> machineUsage.getClass().getName()).thenComparing(machineUsage -> machineUsage.machineCapacity, Comparator.comparingLong(AbstractPersistable::getId)).thenComparingLong(machineUsage -> machineUsage.usage);
    private MrMachineCapacity machineCapacity;
    private long usage;

    public MrMachineUsage(MrMachineCapacity machineCapacity, long usage) {
        this.machineCapacity = machineCapacity;
        this.usage = usage;
    }

    public MrMachineCapacity getMachineCapacity() {
        return this.machineCapacity;
    }

    public long getUsage() {
        return this.usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MrMachineUsage other = (MrMachineUsage)o;
        return Objects.equals(this.machineCapacity, other.machineCapacity) && this.usage == other.usage;
    }

    public int hashCode() {
        return Objects.hash(this.machineCapacity, this.usage);
    }

    public MrMachine getMachine() {
        return this.machineCapacity.getMachine();
    }

    public MrResource getResource() {
        return this.machineCapacity.getResource();
    }

    public boolean isTransientlyConsumed() {
        return this.machineCapacity.getResource().isTransientlyConsumed();
    }

    public long getLoadCostWeight() {
        return this.machineCapacity.getResource().getLoadCostWeight();
    }

    public long getMaximumAvailable() {
        return this.machineCapacity.getMaximumCapacity() - this.usage;
    }

    public long getSafetyAvailable() {
        return this.machineCapacity.getSafetyCapacity() - this.usage;
    }

    public String toString() {
        return this.getMachine() + "-" + this.getResource() + "=" + this.usage;
    }

    @Override
    public int compareTo(MrMachineUsage o) {
        return COMPARATOR.compare(this, o);
    }
}

