/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class AuthMechListOperation
extends HotRodOperation<List<String>> {
    private static final Log log = LogFactory.getLog(AuthMechListOperation.class);
    private final Channel channel;
    private int mechCount = -1;
    private List<String> result;

    public AuthMechListOperation(Codec codec, AtomicInteger topologyId, Configuration cfg, Channel channel, ChannelFactory channelFactory) {
        super((short)33, (short)34, codec, 0, cfg, DEFAULT_CACHE_NAME_BYTES, topologyId, channelFactory);
        this.channel = channel;
    }

    @Override
    public CompletableFuture<List<String>> execute() {
        if (!this.channel.isActive()) {
            throw log.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        this.scheduleRead(this.channel);
        this.sendHeader(this.channel);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.mechCount < 0) {
            this.mechCount = ByteBufUtil.readVInt(buf);
            this.result = new ArrayList<String>(this.mechCount);
            decoder.checkpoint();
        }
        while (this.result.size() < this.mechCount) {
            this.result.add(ByteBufUtil.readString(buf));
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

