/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UtilityMessages {
    ERR_AGGREGATE_INPUT_STREAM_MARK_NOT_SUPPORTED("The aggregate input stream does not support the use of mark and reset functionality."),
    ERR_ARG_STRING_DANGLING_BACKSLASH("The provided string cannot be parsed as an argument list because it ends with a backslash that was not immediately preceded by another backslash.  The backslash character will be considered an escape to indicate that the next character should be included as-is with no interpretation."),
    ERR_ARG_STRING_UNMATCHED_QUOTE("The provided string cannot be parsed as an argument list because it has an unmatched quote starting at or near position {0}."),
    ERR_BASE32_DECODE_INVALID_LENGTH("A base32-encoded string must have a length that is a multiple of 8 bytes."),
    ERR_BASE32_DECODE_UNEXPECTED_CHAR("Invalid character ''{0}'' encountered."),
    ERR_BASE32_DECODE_UNEXPECTED_EQUAL("Unexpected equal sign found at position {0,number,0}."),
    ERR_BASE64_DECODE_INVALID_LENGTH("A base64-encoded string must have a length that is a multiple of 4 bytes."),
    ERR_BASE64_DECODE_UNEXPECTED_CHAR("Invalid character ''{0}'' encountered."),
    ERR_BASE64_DECODE_UNEXPECTED_EQUAL("Unexpected equal sign found at position {0,number,0}."),
    ERR_BASE64_URLDECODE_INVALID_LENGTH("The provided string did not have a valid length for base64url-encoded data."),
    ERR_BS_BUFFER_ARRAY_NULL("The provided array is null."),
    ERR_BS_BUFFER_BUFFER_NULL("The provided buffer is null."),
    ERR_BS_BUFFER_BYTE_STRING_NULL("The provided byte string is null."),
    ERR_BS_BUFFER_CAPACITY_NEGATIVE("The provided capacity {0,number,0} is negative."),
    ERR_BS_BUFFER_CHAR_SEQUENCE_NULL("The provided character sequence is null."),
    ERR_BS_BUFFER_LENGTH_NEGATIVE("The provided length {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_NEGATIVE("The provided offset {0,number,0} is negative."),
    ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE("The provided offset {0,number,0} plus the provided length {1,number,0} is greater than the size of the provided array ({2,number,0})."),
    ERR_BS_BUFFER_POS_NEGATIVE("The provided position {0,number,0} is negative."),
    ERR_BS_BUFFER_POS_TOO_LARGE("The provided position {0,number,0} is greater than the length of the buffer ({1,number,0})."),
    ERR_CL_TOOL_ERROR_CREATING_OUTPUT_FILE("Unable to open output file ''{0}'' for writing:  {0}"),
    ERR_COMMAND_LINE_TOOL_SHUTDOWN_HOOK_NOT_IMPLEMENTED("A shutdown hook was invoked for command-line tool ''{0}'' but the doShutdownHookProcessing method has not been implemented for that tool.  This method must be overridden and implemented for all tools that override the registerShutdownHook method to return true."),
    ERR_DECODE_UUID_INVALID_LENGTH("Unable to decode bytes ''{0}'' as a valid UUID because the length of the provided content was not exactly 128 bits."),
    ERR_DN_FILE_READER_CANNOT_BASE64_DECODE("Unable to base64-decode value ''{0}'' contained on line {1,number,0} of file ''{2}'':  {3}"),
    ERR_DN_FILE_READER_CANNOT_PARSE_DN("Unable to parse value ''{0}'' contained on line {1,number,0} of file ''{2}'' as a DN:  {3}"),
    ERR_FILE_VALUE_PATTERN_NOT_USABLE("Unable to access data in file ''{0}'' for use in the value pattern:  {1}"),
    ERR_FILTER_FILE_READER_CANNOT_PARSE_FILTER("Unable to parse value ''{0}'' contained on line {1,number,0} of file ''{2}'' as an LDAP search filter:  {3}"),
    ERR_FIXED_ARRAY_OS_WRITE_BEYOND_END("Attempted to write beyond the end of the array backing the output stream"),
    ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH("Unable to parse the provided timestamp ''{0}'' because it had an invalid number of characters before the sub-second and/or time zone portion."),
    ERR_GENTIME_DECODE_CANNOT_PARSE_TZ("Unable to parse time zone information from the provided timestamp ''{0}''."),
    ERR_HTTP_VALUE_PATTERN_NOT_USABLE("Unable to access data from ''{0}'' for use in the value pattern:  {1}"),
    ERR_INTERACTIVE_ARG_MENU_INVALID_CHOICE("Invalid choice.  Enter the desired option number or letter."),
    ERR_INTERACTIVE_ARG_PROMPT_INVALID_VALUE("Invalid value:  {0}"),
    ERR_INTERACTIVE_LDAP_CANNOT_AUTHENTICATE("Unable to authenticate to the directory server using the provided settings:  {0}"),
    ERR_INTERACTIVE_LDAP_CANNOT_CONNECT("Unable to establish a connection to server ''{0}'' on port {1,number,0}:  {2}"),
    ERR_INTERACTIVE_LDAP_CANNOT_CREATE_KEY_MANAGER("An error occurred while attempting to initialize the key manager for SSL/TLS encryption:  {0}.  Unable to communicate securely with the directory server."),
    ERR_INTERACTIVE_LDAP_CANNOT_CREATE_SOCKET_FACTORY("An error occurred while attempting to initialize the socket factory for SSL/TLS encryption:  {0}.  Unable to communicate securely with the directory server."),
    ERR_INTERACTIVE_LDAP_CANNOT_CREATE_TRUST_MANAGER("An error occurred while attempting to initialize the trust manager for SSL/TLS encryption:  {0}.  Unable to communicate securely with the directory server."),
    ERR_INTERACTIVE_LDAP_CANNOT_PERFORM_STARTTLS("Unable to secure the connection using StartTLS:  {0}"),
    ERR_INTERACTIVE_MENU_CANNOT_READ_CHOICE("An error occurred while attempting to determine the selected menu item:  {0}"),
    ERR_INTERACTIVE_MENU_CORRECT_VALIDATION_ERRORS("These errors must be corrected before the tool can be run."),
    ERR_INTERACTIVE_MENU_EXTENDED_VALIDATION_ERRORS("One or more errors were detected while performing extended argument validation:  {0}"),
    ERR_INTERACTIVE_MENU_INVALID_CHOICE("Invalid choice.  Enter the desired option number, or 'q' to quit."),
    ERR_INTERACTIVE_MULTI_SERVER_LDAP_NOT_SUPPORTED("Interactive mode is currently not supported for multi-server LDAP command-line tools."),
    ERR_INTERACTIVE_PROMPT_DIR_DOES_NOT_EXIST("File ''{0}'' does not exist.  You must provide a path to a directory that exists."),
    ERR_INTERACTIVE_PROMPT_ERROR_READING_RESPONSE("An error occurred while attempting to read a response from the user:  {0}"),
    ERR_INTERACTIVE_PROMPT_FILE_DOES_NOT_EXIST("File ''{0}'' does not exist.  You must provide a path to a file that exists."),
    ERR_INTERACTIVE_PROMPT_INTEGER_OUT_OF_RANGE("The value must be between {0} and {1}."),
    ERR_INTERACTIVE_PROMPT_INVALID_BOOLEAN("Unable to parse the provided value as a valid Boolean response.  Please enter either \"true\" or \"false\"."),
    ERR_INTERACTIVE_PROMPT_INVALID_DN("Unable to parse the provided value as a valid LDAP distinguished name.  Please enter a valid DN."),
    ERR_INTERACTIVE_PROMPT_INVALID_FILTER("Unable to parse the provided value as a valid LDAP search filter.  Please enter a valid filter."),
    ERR_INTERACTIVE_PROMPT_INVALID_INTEGER_WITHOUT_RANGE("Unable to parse the provided value as an integer.  Please enter a valid integer value."),
    ERR_INTERACTIVE_PROMPT_INVALID_INTEGER_WITH_RANGE("Unable to parse the provided value as an integer.  Please enter a valid integer value between {0} and {1}."),
    ERR_INTERACTIVE_PROMPT_INVALID_TIMESTAMP("Unable to parse the provided value as a timestamp.  Supported formats include any generalized time format, as well as local timestamps in any of the following formats:  'YYYYMMDDhhmmss.uuu', 'YYYYMMDDhhmmss', or 'YYYYMMDDhhmm'.  Please enter a valid timestamp."),
    ERR_INTERACTIVE_PROMPT_NULL_DN_NOT_ALLOWED("The null DN is not allowed for this value.  Please enter a non-empty DN."),
    ERR_INTERACTIVE_PROMPT_PARENT_DOES_NOT_EXIST("File ''{0}'' does not exist, and neither does its parent.  You must provide a path in which at least the parent directory exists."),
    ERR_INTERACTIVE_PROMPT_PATH_MUST_BE_DIR("Path ''{0}'' exists but references a file rather than a directory.  The specified path must reference a directory."),
    ERR_INTERACTIVE_PROMPT_PATH_MUST_BE_FILE("Path ''{0}'' exists but references a directory rather than a file.  The specified path must reference a file."),
    ERR_INTERACTIVE_PROMPT_VALUE_REQUIRED("You are require to supply a value."),
    ERR_INTERACTIVE_TRAILING_VALUE_INVALID("The specified value was invalid:  {0}"),
    ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER("Unable to create the key manager for secure communication:  {0}"),
    ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY("Unable to create the SSL socket factory to use for StartTLS communication with the server:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD("Unable to read the bind password:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD("Unable to read the key store password:  {0}"),
    ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD("Unable to read the trust store password:  {0}"),
    ERR_LDAP_TOOL_HOST_PORT_COUNT_MISMATCH("If either the ''--{0}'' or ''--{1}'' arguments are provided multiple times, then both arguments must be provided the same number of times."),
    ERR_LDAP_TOOL_INVALID_SASL_OPTION("SASL option ''{0}'' cannot be used with the {1} mechanism."),
    ERR_LDAP_TOOL_MALFORMED_SASL_OPTION("SASL option ''{0}'' is invalid.  SASL options must be in the form ''name=value''."),
    ERR_LDAP_TOOL_MISSING_REQUIRED_SASL_OPTION("SASL option ''{0}'' is required for use with the {1} mechanism."),
    ERR_LDAP_TOOL_NO_SASL_MECH("One or more SASL options were provided, but the ''mech'' option was not given to indicate which SASL mechanism to use."),
    ERR_LDAP_TOOL_START_TLS_FAILED("StartTLS negotiation failed:  {0}"),
    ERR_LDAP_TOOL_UNSUPPORTED_SASL_MECH("SASL mechanism ''{0}'' is not supported."),
    ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_EMPTY("If non-null, the sets of server name prefixes and server name suffixes must not be empty."),
    ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_MISMATCH("If both the sets of server name prefixes and server name suffixes are non-null, they must have the same number of elements."),
    ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_NULL("The sets of server name prefixes and server name suffixes must not both be null."),
    ERR_NO_EXCEPTION("No Exception"),
    ERR_PW_READER_FAILURE("An error occurred while attempting to read a password from the terminal:  {0}"),
    ERR_RATE_ADJUSTOR_DUPLICATE_HEADER_KEY("Header key ''{0}'' already has a value of ''{1}''.  Cannot also set it to ''{2}''."),
    ERR_RATE_ADJUSTOR_HEADER_EMPTY_KEY("Header line ''{0}'' is malformed because the key is an empty string."),
    ERR_RATE_ADJUSTOR_HEADER_NO_EQUAL("Header line ''{0}'' is malformed because it does not include an equal sign to separate the header key from its value."),
    ERR_RATE_ADJUSTOR_INVALID_DEFAULT_DURATION("Default duration ''{0}'' could not be parsed as a duration value:  {1}"),
    ERR_RATE_ADJUSTOR_INVALID_DURATION("Duration ''{0}'' from input line ''{1}'' could not be parsed as a duration value:  {2}"),
    ERR_RATE_ADJUSTOR_INVALID_FORMAT("The rate input included an invalid value, ''{0}'', for the ''{1}'' property in the header.  This key must have one of these values:  {2}."),
    ERR_RATE_ADJUSTOR_INVALID_KEYS("The header included the following invalid keys:  {0}. The supported keys are {1}."),
    ERR_RATE_ADJUSTOR_INVALID_LINE("Input line ''{0}'' has an invalid format.  All non-empty, non-comment lines must take the form ''absolute-rate-per-second, duration'' (e.g., ''1000, 1m'') or ''relative-rate, duration'' (e.g., ''2.5X, 1d''), where the rate is a multiplier on the baseline rate per second.  The duration can be omitted if a {1} value is provided in the header"),
    ERR_RATE_ADJUSTOR_INVALID_RATE("Rate ''{0}'' from input line ''{1}'' could not be parsed as a floating point value"),
    ERR_RATE_ADJUSTOR_MISSING_FORMAT("The rate input did not include a value for the ''{0}'' property in the header.  This key is required, and must have one of these values:  {1}.  All header lines must appear at the beginning of the file and must take the form ''{2} key=value''."),
    ERR_RATE_ADJUSTOR_NO_END_HEADER_FOUND("Unable to find a line comprised of the text ''{0}'' to denote the end of the header."),
    ERR_RATE_ADJUSTOR_RELATIVE_RATE_WITHOUT_BASELINE("Rate ''{0}'' from input line ''{1}'' specified a relative rate.  This is not supported because the target rate per second was not provided (e.g., using the ''--ratePerSecond'' command-line argument)."),
    ERR_REF_VALUE_PATTERN_INVALID_INDEX("The provided value pattern string contained a back-reference component with an index of ''{0}'', but there are not that many components to reference at that point in the pattern."),
    ERR_REF_VALUE_PATTERN_NOT_VALID("The provided value pattern string contained a back-reference component with an invalid value of ''{0}''."),
    ERR_REF_VALUE_PATTERN_ZERO_INDEX("The provided value pattern string contained a back-reference component with an index of zero.  Back-reference indexes should start with one rather than zero."),
    ERR_SASL_MISSING_REQUIRED_OPTION("SASL option ''{0}'' is required with the {1} mechanism but was not provided."),
    ERR_SASL_OPTION_GSSAPI_PASSWORD_REQUIRED("A password must be provided for a GSSAPI bind unless useTicketCache=true and requireCache=true options are provided."),
    ERR_SASL_OPTION_MALFORMED_BOOLEAN_VALUE("SASL option ''{0}'' must have a value of either ''true'' or ''false''."),
    ERR_SASL_OPTION_MECH_CONFLICT("Conflicting SASL mechanisms ''{0}'' and ''{1}'' were specified."),
    ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD("A password was provided, but SASL mechanism {0} does not accept a password."),
    ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD("SASL mechanism {0} requires a password but none was provided."),
    ERR_SASL_OPTION_MISSING_EQUAL("Unable to parse string ''{0}'' as a SASL option because it is missing an equal sign to separate the name from the value."),
    ERR_SASL_OPTION_NOT_MULTI_VALUED("SASL option ''{0}'' was provided multiple times."),
    ERR_SASL_OPTION_NO_MECH("No SASL mechanism was specified."),
    ERR_SASL_OPTION_STARTS_WITH_EQUAL("Unable to parse string ''{0}'' as a SASL option because it does not have an option name before the equal sign."),
    ERR_SASL_OPTION_UNSUPPORTED_FOR_MECH("SASL option ''{0}'' is not supported with the {1} mechanism."),
    ERR_SASL_OPTION_UNSUPPORTED_MECH("Unsupported SASL mechanism ''{0}''."),
    ERR_TEST_ATTR_EXISTS("Entry ''{0}'' was found to contain attribute ''{1}'' when that attribute was expected to be missing."),
    ERR_TEST_ATTR_EXISTS_WITH_VALUES("Entry ''{0}'' was found to contain attribute ''{1}'' with value(s) {2} when that attribute was expected to be missing."),
    ERR_TEST_ATTR_MISSING("Entry ''{0}'' exists but does not have any values for attribute ''{1}''."),
    ERR_TEST_ATTR_MISSING_VALUE("Entry ''{0}'' exists and contains attribute ''{1}'' with value(s) {2}, but does not include expected value(s) {3}."),
    ERR_TEST_DNS_NOT_EQUAL("The provided DN values ''{0}'' and ''{1}'' are not equal."),
    ERR_TEST_ENTRY_DOES_NOT_MATCH_FILTER("Entry ''{0}'' was found to exist in the server but does not match expected filter ''{1}''."),
    ERR_TEST_ENTRY_EXISTS("Entry ''{0}'' was found in the server but was expected to be missing."),
    ERR_TEST_ENTRY_HAS_CONTROL("Search result entry {0} was not expected to have any control with OID ''{1}'' but one was found."),
    ERR_TEST_ENTRY_MISSING("Entry ''{0}'' does not exist in the server."),
    ERR_TEST_ENTRY_MISSING_CONTROL("Search result entry {0} was expected to have at least one control with OID ''{1}'' but none was found."),
    ERR_TEST_MATCHED_DN_MISMATCH("Result {0} was expected to contain a matched DN value of ''{1}'' but ''{0}'' was found instead."),
    ERR_TEST_MULTI_RESULT_CODE_FOUND("Result {0} had one of the unacceptable result codes {1}."),
    ERR_TEST_MULTI_RESULT_CODE_MISSING("Result {0} did not have any of the acceptable result codes {1}."),
    ERR_TEST_PROCESSING_MULTI_RESULT_CODE_FOUND("Result {0} received from processing request {1} had one of the unacceptable result codes {2}."),
    ERR_TEST_PROCESSING_MULTI_RESULT_CODE_MISSING("Result {0} received from processing request {1} did not have any of the acceptable result codes {2}."),
    ERR_TEST_PROCESSING_SINGLE_RESULT_CODE_FOUND("Result {0} received from processing request {1} had an unacceptable result code of ''{2}''."),
    ERR_TEST_PROCESSING_SINGLE_RESULT_CODE_MISSING("Result {0} received from processing request {1} did not have the expected result code of {2}."),
    ERR_TEST_REF_HAS_CONTROL("Search result reference {0} was not expected to have any control with OID ''{1}'' but one was found."),
    ERR_TEST_REF_MISSING_CONTROL("Search result reference {0} was expected to have at least one control with OID ''{1}'' but none was found."),
    ERR_TEST_RESULT_CONTAINS_MATCHED_DN("Result {0} was not expected to contain a matched DN but a value of ''{1}'' was found."),
    ERR_TEST_RESULT_HAS_CONTROL("Result {0} was not expected to have any control with OID ''{1}'' but one was found."),
    ERR_TEST_RESULT_HAS_REFERRAL("Result {0} was not expected to have any referral URLs but one or more were found."),
    ERR_TEST_RESULT_MISSING_CONTROL("Result {0} was expected to have at least one control with OID ''{1}'' but none was found."),
    ERR_TEST_RESULT_MISSING_EXPECTED_MATCHED_DN("Result {0} was expected to contain a matched DN of ''{1}'' but none was found."),
    ERR_TEST_RESULT_MISSING_MATCHED_DN("Result {0} was expected to contain a matched DN but none was found."),
    ERR_TEST_RESULT_MISSING_REFERRAL("Result {0} was expected to have at least one referral URL but did not contain any."),
    ERR_TEST_SEARCH_ENTRIES_RETURNED("The search was not expected to have returned any entries, but result {0} indicates that the number of entries returned was {1}."),
    ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_MULTI_EXPECTED("The search was expected to have returned {0} entries, but result {1} indicates that the number of entries returned was {2}."),
    ERR_TEST_SEARCH_ENTRY_COUNT_MISMATCH_ONE_EXPECTED("The search was expected to have returned one entry, but result {0} indicates that the number of entries returned was {1}."),
    ERR_TEST_SEARCH_ENTRY_NOT_RETURNED("The search with result {0} was expected to have returned entry ''{1}'', but either was not included in the set of entries that were returned, or a search result listener was used for the search that makes it impossible to determine what entries were returned."),
    ERR_TEST_SEARCH_NO_ENTRIES_RETURNED("The search was expected to have returned one or more entries, but result {0} indicates that none were returned."),
    ERR_TEST_SEARCH_NO_REFS_RETURNED("The search was expected to have returned one or more references, but result {0} indicates that none were returned."),
    ERR_TEST_SEARCH_REFS_RETURNED("The search was not expected to have returned any references, but result {0} indicates that the number of references returned was {1}."),
    ERR_TEST_SEARCH_REF_COUNT_MISMATCH_MULTI_EXPECTED("The search was expected to have returned {0} references, but result {1} indicates that the number of references returned was {2}."),
    ERR_TEST_SEARCH_REF_COUNT_MISMATCH_ONE_EXPECTED("The search was expected to have returned one reference, but result {0} indicates that the number of references returned was {1}."),
    ERR_TEST_SINGLE_RESULT_CODE_FOUND("Result {0} had an unacceptable result code of ''{1}''."),
    ERR_TEST_SINGLE_RESULT_CODE_MISSING("Result {0} did not have the expected result code of ''{1}''."),
    ERR_TEST_VALUE_EXISTS("Entry ''{0}'' was found to contain attribute ''{1}'' with value ''{2}'' when that value was expected to be missing."),
    ERR_TEST_VALUE_MISSING("Entry ''{0}'' exists and contains attribute ''{1}'', but that attribute does not include value ''{2}''."),
    ERR_TEST_VALUE_NOT_VALID_DN("The provided string value ''{0}'' does not represent a valid LDAP distinguished name:  {1}"),
    ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE("{0}.  Thread stack trace:  {1}"),
    ERR_VALIDATOR_FALSE_CHECK_FAILURE("A result of true was found for a condition which the LDAP SDK requires to be false.  Thread stack trace {0}"),
    ERR_VALIDATOR_NULL_CHECK_FAILURE("A null object was provided where a non-null object is required (non-null index {0,number,0}).  Thread stack trace:  {1}"),
    ERR_VALIDATOR_TRUE_CHECK_FAILURE("A result of false was found for a condition which the LDAP SDK requires to be true.  Thread stack trace {0}"),
    ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE("The specified file does not contain any data."),
    ERR_VALUE_PATTERN_EMPTY_FORMAT("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length format string."),
    ERR_VALUE_PATTERN_EMPTY_INCREMENT("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length increment."),
    ERR_VALUE_PATTERN_EMPTY_LOWER_BOUND("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length lower bound."),
    ERR_VALUE_PATTERN_EMPTY_UPPER_BOUND("The provided value pattern string contained a numeric range starting at position {0,number,0} which contained a zero-length upper bound."),
    ERR_VALUE_PATTERN_INVALID_CHARACTER("The provided value pattern string contained an invalid character ''{0}'' at position {1,number,0}."),
    ERR_VALUE_PATTERN_NO_DELIMITER("The provided value pattern string contained a numeric range starting at position {0,number,0} which did not contain either a dash or colon to separate the lower bound from the upper bound."),
    ERR_VALUE_PATTERN_UNMATCHED_CLOSE("The provided value pattern string contained an unmatched closing brace at position {0,number,0}."),
    ERR_VALUE_PATTERN_UNMATCHED_OPEN("The provided value pattern string contained an unmatched opening brace at position {0,number,0}."),
    ERR_VALUE_PATTERN_VALUE_NOT_LONG("The provided value pattern string contained a numeric range starting at position {0,number,0} with a value that is outside the acceptable range.  Values must be between {1,number,0} and {2,number,0}."),
    INFO_CL_TOOL_ARGS_FROM_PROPERTIES_FILE("Arguments obtained from properties file ''{0}'':"),
    INFO_CL_TOOL_DESCRIPTION_APPEND_TO_OUTPUT_FILE("Indicates that the tool should append to the file specified by the {0} argument if it already exists.  If this argument is not provided and the output file already exists, it will be overwritten."),
    INFO_CL_TOOL_DESCRIPTION_HELP("Display usage information for this program."),
    INFO_CL_TOOL_DESCRIPTION_HELP_SUBCOMMANDS("Display the names and descriptions of the supported subcommands."),
    INFO_CL_TOOL_DESCRIPTION_INTERACTIVE("Launch the tool in interactive mode."),
    INFO_CL_TOOL_DESCRIPTION_OUTPUT_FILE("Write all standard output and standard error messages to the specified file instead of to the console."),
    INFO_CL_TOOL_DESCRIPTION_TEE_OUTPUT("Write all standard output and standard error messages to the console as well as to the specified output file.  The {0} argument must also be provided."),
    INFO_CL_TOOL_DESCRIPTION_VERSION("Display version information for this program."),
    INFO_CL_TOOL_LABEL_EXAMPLES("Examples"),
    INFO_CL_TOOL_USE_SUBCOMMAND_HELP("Use ''{0} '{'subcommand'}' --help'' to get more detailed help for a specific subcommand."),
    INFO_CL_TOOL_WROTE_PROPERTIES_FILE("Successfully wrote properties file {0}."),
    INFO_COLUMN_LABEL_TIMESTAMP("Timestamp"),
    INFO_INTEARCTIVE_MENU_TRAILING_ARGS_IDENTIFIER("{trailing arguments}"),
    INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUE("The current value for this argument is:"),
    INFO_INTERACTIVE_ARG_DESC_CURRENT_VALUES("The current values for this argument are:"),
    INFO_INTERACTIVE_ARG_MENU_PROMPT("Would you like to alter the values of any command-line arguments for the tool?"),
    INFO_INTERACTIVE_ARG_PROMPT_AT_LEAST_ONE_REQUIRED("This argument requires at least one value."),
    INFO_INTERACTIVE_ARG_PROMPT_CONSTRAINTS("Value Constraints:  "),
    INFO_INTERACTIVE_ARG_PROMPT_DESCRIPTION("Description:  "),
    INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUE("Enter a new value"),
    INFO_INTERACTIVE_ARG_PROMPT_NEW_VALUES("Enter the desired new value(s), pressing ENTER on an empty line to indicate no more values are needed."),
    INFO_INTERACTIVE_ARG_PROMPT_SINGLE_REQUIRED("This argument requires a value."),
    INFO_INTERACTIVE_ARG_PROMPT_SPECIFY_MULTIPLE_VALUES("Specify one or more new values for argument ''{0}''"),
    INFO_INTERACTIVE_ARG_PROMPT_SPECIFY_SINGLE_VALUE("Specify a new value for argument ''{0}''"),
    INFO_INTERACTIVE_LAUNCHING("Launching {0} in interactive mode."),
    INFO_INTERACTIVE_LDAP_AUTH_AUTHID_PROMPT("Enter the authentication ID to use to authenticate (typically ''dn:'' followed by the user DN or ''u:'' followed by the username)"),
    INFO_INTERACTIVE_LDAP_AUTH_AUTHZID_PROMPT("Enter the authorization ID to use (typically in the same format as the authentication ID), or simply press ENTER if you do not wish to use an alternate authorization identity"),
    INFO_INTERACTIVE_LDAP_AUTH_BIND_DN_PROMPT("Enter the DN of the user as whom you wish to bind, or simply press ENTER for anonymous simple authentication"),
    INFO_INTERACTIVE_LDAP_AUTH_OPTION_NONE("Do not authenticate"),
    INFO_INTERACTIVE_LDAP_AUTH_OPTION_SASL("Use SASL authentication"),
    INFO_INTERACTIVE_LDAP_AUTH_OPTION_SIMPLE("Use simple authentication"),
    INFO_INTERACTIVE_LDAP_AUTH_PROMPT("How do you wish to authenticate to the directory server?"),
    INFO_INTERACTIVE_LDAP_AUTH_PW_PROMPT("Enter the password for the user"),
    INFO_INTERACTIVE_LDAP_AUTH_REALM_PROMPT("Enter the authentication realm, or simply press ENTER for no realm"),
    INFO_INTERACTIVE_LDAP_AUTH_SASL_PROMPT("Which SASL mechanism would you like to use?"),
    INFO_INTERACTIVE_LDAP_CERT_AUTH_PROMPT("Do you wish to use the client certificate to authenticate using SASL EXTERNAL?"),
    INFO_INTERACTIVE_LDAP_CERT_NICKNAME_PROMPT("Enter the nickname for the desired certificate in the certificate keystore (or just press ENTER if there is only one client certificate in the keystore)"),
    INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_JKS("Yes, from a Java JKS keystore"),
    INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_NO("No"),
    INFO_INTERACTIVE_LDAP_CLIENT_CERT_OPTION_PKCS12("Yes, from a PKCS#12 keystore"),
    INFO_INTERACTIVE_LDAP_CLIENT_CERT_PROMPT("Do you want to present a client certificate to the directory server?"),
    INFO_INTERACTIVE_LDAP_KEYSTORE_PATH_PROMPT("Enter the path to the keystore file"),
    INFO_INTERACTIVE_LDAP_KEYSTORE_PIN_PROMPT("Enter the PIN needed to access the contents of the keystore (or just press ENTER if no PIN is required)"),
    INFO_INTERACTIVE_LDAP_PROMPT_HOST("Enter the address of the directory server"),
    INFO_INTERACTIVE_LDAP_PROMPT_PORT("Enter the port on which to communicate with the directory server"),
    INFO_INTERACTIVE_LDAP_RETRY_PROMPT("Would you like to re-enter LDAP connection settings?"),
    INFO_INTERACTIVE_LDAP_SASL_OPTION_CRAM_MD5("CRAM-MD5"),
    INFO_INTERACTIVE_LDAP_SASL_OPTION_DIGEST_MD5("DIGEST-MD5"),
    INFO_INTERACTIVE_LDAP_SASL_OPTION_PLAIN("PLAIN"),
    INFO_INTERACTIVE_LDAP_SECURITY_OPTION_NONE("No"),
    INFO_INTERACTIVE_LDAP_SECURITY_OPTION_SSL("Yes, with SSL"),
    INFO_INTERACTIVE_LDAP_SECURITY_OPTION_START_TLS("Yes, with StartTLS"),
    INFO_INTERACTIVE_LDAP_SECURITY_PROMPT("Should the LDAP communication be encrypted?"),
    INFO_INTERACTIVE_LDAP_TRUSTSTORE_PATH_PROMPT("Enter the path to the truststore file"),
    INFO_INTERACTIVE_LDAP_TRUSTSTORE_PIN_PROMPT("Enter the PIN needed to access the contents of the truststore (or just press ENTER if no PIN is required)"),
    INFO_INTERACTIVE_LDAP_TRUST_OPTION_BLIND("Blindly trust any server certificate"),
    INFO_INTERACTIVE_LDAP_TRUST_OPTION_JKS("Use a JKS truststore"),
    INFO_INTERACTIVE_LDAP_TRUST_OPTION_PKCS12("Use a PKCS#12 truststore"),
    INFO_INTERACTIVE_LDAP_TRUST_OPTION_PROMPT("Interactively prompt about whether to trust the server certificate"),
    INFO_INTERACTIVE_LDAP_TRUST_PROMPT("How do you wish to determine whether the server certificate should be trusted?"),
    INFO_INTERACTIVE_MENU_CURRENT_ARGS_HEADER("The arguments used to run {0} with the current settings would be:"),
    INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITHOUT_DEFAULT("Enter choice: "),
    INFO_INTERACTIVE_MENU_ENTER_CHOICE_WITH_DEFAULT("Enter choice [{0}]: "),
    INFO_INTERACTIVE_MENU_NO_CURRENT_ARGS("The {0} tool does not require any arguments to run with the current settings."),
    INFO_INTERACTIVE_MENU_OPTION_DISPLAY_ARGS("Display the arguments to run {0} with these settings"),
    INFO_INTERACTIVE_MENU_OPTION_QUIT("Quit this program"),
    INFO_INTERACTIVE_MENU_OPTION_REPROMPT_FOR_CONN_ARGS("Re-prompt for the LDAP connection arguments"),
    INFO_INTERACTIVE_MENU_OPTION_REPROMPT_FOR_CONN_AUTH_ARGS("Re-prompt for the LDAP connection and authentication arguments"),
    INFO_INTERACTIVE_MENU_OPTION_RUN("Run {0} with these settings"),
    INFO_INTERACTIVE_MENU_OPTION_UNDEFINED("Leave undefined"),
    INFO_INTERACTIVE_MENU_PROMPT_PRESS_ENTER_TO_CONTINUE("Press ENTER to continue"),
    INFO_INTERACTIVE_RUNNING_WITH_ARGS("Running {0} with the following arguments:"),
    INFO_INTERACTIVE_RUNNING_WITH_NO_ARGS("Running {0} without any arguments."),
    INFO_INTERACTIVE_SUBCOMMAND_PROMPT("Which subcommand do you want to use?"),
    INFO_INTERACTIVE_TRAILING_ARG_PROMPT("Trailing argument value"),
    INFO_INTERACTIVE_TRAILING_DESC_MULTIPLE_OPTIONAL("The {0} tool optionally allows one or more trailing arguments that are not immediately preceded by any identifiers.  The expected usage for the trailing arguments is:"),
    INFO_INTERACTIVE_TRAILING_DESC_MULTIPLE_REQUIRED("The {0} tool requires at least {1,number,0} trailing argument(s) (which are not immediately preceded by any identifiers) to be provided.  The expected usage for the trailing arguments is:"),
    INFO_INTERACTIVE_TRAILING_DESC_SINGLE_OPTIONAL("The {0} tool optionally allows a single trailing argument which is not immediately preceded by any identifier.  The expected usage for this argument is:"),
    INFO_INTERACTIVE_TRAILING_DESC_SINGLE_REQUIRED("The {0} tool requires exactly one trailing argument which is not immediately preceded by any identifier.  The expected usage for this argument is:"),
    INFO_INTERACTIVE_TRAILING_PROMPT_MULTIPLE("Enter the desired trailing argument values, pressing ENTER on a blank line to indicate that no more trailing arguments are needed."),
    INFO_INTERACTIVE_TRAILING_PROMPT_SINGLE("Enter the desired trailing argument value, or simply press ENTER to indicate no trailing argument should be provided"),
    INFO_LDAP_TOOL_ARG_GROUP_CONNECT("LDAP Connection Arguments"),
    INFO_LDAP_TOOL_ARG_GROUP_CONNECT_AND_AUTH("LDAP Connection and Authentication Arguments"),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_DN("The DN to use to bind to the directory server when performing simple authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_PW("The password to use to bind to the directory server when performing simple authentication or a password-based SASL mechanism."),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE("The path to the file containing the password to use to bind to the directory server when performing simple authentication or a password-based SASL mechanism."),
    INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_PROMPT("Indicates that the tool should interactively prompt the user for the bind password."),
    INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME("The nickname (alias) of the client certificate in the key store to present to the directory server for SSL client authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_HELP_SASL("Provide information about the supported SASL mechanisms, including the properties available for use with each."),
    INFO_LDAP_TOOL_DESCRIPTION_HOST("The IP address or resolvable name to use to connect to the directory server.  If this is not provided, then a default value of 'localhost' will be used."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the key store file."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD("The password to use to access the key store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the key store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_PROMPT("Indicates that the tool should interactively prompt the user for the password to use to access the key store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH("The path to the file to use as the key store for obtaining client certificates when communicating securely with the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_PORT("The port to use to connect to the directory server.  If this is not provided, then a default value of 389 will be used."),
    INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION("A name-value pair providing information to use when performing SASL authentication."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL("Trust any certificate presented by the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the trust store file."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD("The password to use to access the trust store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the trust store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_PROMPT("Indicates that the tool should interactively prompt the user for the password to use to access the trust store contents."),
    INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH("The path to the file to use as trust store when determining whether to trust a certificate presented by the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_USE_SSL("Use SSL when communicating with the directory server."),
    INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS("Use StartTLS when communicating with the directory server."),
    INFO_LDAP_TOOL_ENTER_BIND_PASSWORD("Enter the bind password:"),
    INFO_LDAP_TOOL_ENTER_KEY_STORE_PASSWORD("Enter the key store password:"),
    INFO_LDAP_TOOL_ENTER_TRUST_STORE_PASSWORD("Enter the trust store password:"),
    INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME("{nickname}"),
    INFO_LDAP_TOOL_PLACEHOLDER_DN("{dn}"),
    INFO_LDAP_TOOL_PLACEHOLDER_FORMAT("{format}"),
    INFO_LDAP_TOOL_PLACEHOLDER_HOST("{host}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD("{password}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PATH("{path}"),
    INFO_LDAP_TOOL_PLACEHOLDER_PORT("{port}"),
    INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION("{name=value}"),
    INFO_MULTI_LDAP_TOOL_GROUP_CONN_AND_AUTH("Connection and Authentication Arguments"),
    INFO_NUM_DAYS_PLURAL("{0,number,0} days"),
    INFO_NUM_DAYS_SINGULAR("{0,number,0} day"),
    INFO_NUM_HOURS_PLURAL("{0,number,0} hours"),
    INFO_NUM_HOURS_SINGULAR("{0,number,0} hour"),
    INFO_NUM_MINUTES_PLURAL("{0,number,0} minutes"),
    INFO_NUM_MINUTES_SINGULAR("{0,number,0} minute"),
    INFO_NUM_SECONDS_PLURAL("{0,number,0} seconds"),
    INFO_NUM_SECONDS_SINGULAR("{0,number,0} second"),
    INFO_NUM_SECONDS_WITH_DECIMAL("{0} seconds"),
    INFO_RATE_ADJUSTOR_GENERATE_SAMPLE_RATE_FILE_ARG_DESCRIPTION("The path to a sample variable data rate file that should be generated.  This file will contain comments that describe the expected format for the file to use with the {0} argument."),
    INFO_RATE_ADJUSTOR_VARIABLE_RATE_DATA_ARG_DESCRIPTION("The path to a file containing information that can be used to cause the tool to vary the target rate over time.  Use the {0} argument to generate a sample rate definition file with comments that describe the required format for this file."),
    INFO_SASL_ANONYMOUS_DESCRIPTION("A mechanism that can be used to destroy an existing authentication session, or to perform a bind without actually authenticating but optionally including a trace string that may help provide information about the client."),
    INFO_SASL_ANONYMOUS_OPTION_TRACE("A trace string that may be used to provide additional information about the client performing the bind.  Note, however, that because the client is not providing any proof of its identity, it is not possible to determine the validity of any trace information given."),
    INFO_SASL_CRAM_MD5_DESCRIPTION("A mechanism that can be used to perform password-based authentication in a manner that prevents an observer from discovering the password by generating an MD5 digest based on the provided password and additional information, including random data provided by the server."),
    INFO_SASL_CRAM_MD5_OPTION_AUTH_ID("A string which identifies the user that is trying to authenticate.  The value is typically in the form \"dn:\" followed by the DN of the target user's entry, or \"u:\" followed by the username for the target user."),
    INFO_SASL_DIGEST_MD5_DESCRIPTION("A mechanism that can be used to perform password-based authentication in a manner that prevents an observer from discovering the password by generating an MD5 digest based on the provided password and additional information, including random data provided by both the client and the server."),
    INFO_SASL_DIGEST_MD5_OPTION_AUTHZ_ID("A string which identifies the user under whose authority subsequent operations should be processed.  If this is not provided, then no alternate authorization identity will be used."),
    INFO_SASL_DIGEST_MD5_OPTION_AUTH_ID("A string which identifies the user that is trying to authenticate.  The value is typically in the form \"dn:\" followed by the DN of the target user's entry, or \"u:\" followed by the username for the target user."),
    INFO_SASL_DIGEST_MD5_OPTION_QOP("The quality of protection that should be used for any communication that occurs after the authentication has completed.  Allowed values are 'auth' (for just authentication with no communication protection), 'auth-int' (for integrity protection for communication, which does not encrypt but ensures that the communication cannot be imperceptibly altered by a man in the middle attack), and 'auth-conf' (for confidentiality protection for communication, which encrypts the communication so that it cannot be deciphered by a third-party observer).  If no value is specified, then a default of 'auth' will be assumed.  If any of multiple qualities of protection will be considered acceptable then the permissible QoP values may be separated by commas and listed in order from most desirable to least desirable."),
    INFO_SASL_DIGEST_MD5_OPTION_REALM("The realm for the user trying to authenticate.  If this is not provided, then no realm will be specified in the bind request."),
    INFO_SASL_EXTERNAL_DESCRIPTION("A mechanism that can allow the client to authenticate to the server using information that the server may have about the client which was not provided in the form of an LDAP message (e.g., a client certificate that was presented during an SSL or StartTLS handshake)."),
    INFO_SASL_GSSAPI_DESCRIPTION("A mechanism that can allow the client to authenticate to the server using Kerberos V.  It may be possible to leverage an existing Kerberos session or to authenticate using a newly-created session."),
    INFO_SASL_GSSAPI_OPTION_AUTHZ_ID("A string which identifies the user under whose authority subsequent operations should be processed.  If this is not provided, then no alternate authorization identity will be used."),
    INFO_SASL_GSSAPI_OPTION_AUTH_ID("A string which identifies the user that is trying to authenticate.  This should generally be the user's Kerberos principal."),
    INFO_SASL_GSSAPI_OPTION_CONFIG_FILE("The path to a file containing the JAAS configuration that will be used for Kerberos processing.  if this is not specified then an automatically-generated JAAS configuration will be used."),
    INFO_SASL_GSSAPI_OPTION_DEBUG("Indicates whether JAAS and Kerberos processing debug information may be written to standard error."),
    INFO_SASL_GSSAPI_OPTION_KDC_ADDRESS("The address of the Kerberos KDC that should be used during authentication processing.  If this is not provided, then an attempt will be made to determine the appropriate KDC address from the underlying system configuration."),
    INFO_SASL_GSSAPI_OPTION_PROTOCOL("The name of the protocol used in the directory server's service principal.  If this is not provided, then a default protocol of \"ldap\" will be used."),
    INFO_SASL_GSSAPI_OPTION_QOP("The quality of protection that should be used for any communication that occurs after the authentication has completed.  Allowed values are 'auth' (for just authentication with no communication protection), 'auth-int' (for integrity protection for communication, which does not encrypt but ensures that the communication cannot be imperceptibly altered by a man in the middle attack), and 'auth-conf' (for confidentiality protection for communication, which encrypts the communication so that it cannot be deciphered by a third-party observer).  If no value is specified, then a default of 'auth' will be assumed.  If any of multiple qualities of protection will be considered acceptable then the permissible QoP values may be separated by commas and listed in order from most desirable to least desirable."),
    INFO_SASL_GSSAPI_OPTION_REALM("The name of the Kerberos realm in which the authentication will be processed.  if this is not provided, then an attempt will be made to determine the appropriate realm from the underlying system configuration."),
    INFO_SASL_GSSAPI_OPTION_RENEW_TGT("Indicates whether to attempt to renew the client's Kerberos ticket-granting ticket if authentication succeeds using an existing Kerberos session.  If this is not provided, then no attempt will be made to renew the TGT."),
    INFO_SASL_GSSAPI_OPTION_REQUIRE_TICKET_CACHE("Indicates whether the client will be required to have an existing Kerberos session that will be used for the authentication rather than using a newly-created session.  This option will only be examined if a ticket cache should be used during authentication processing.  If this is not provided, then an existing Kerberos session will not be required."),
    INFO_SASL_GSSAPI_OPTION_TICKET_CACHE("Specifies the path to a ticket cache file that should be used to look for an existing Kerberos session.  This option will only be examined if a ticket cache should be used during authentication processing.  If this is not provided, then the default ticket cache file path will be used."),
    INFO_SASL_GSSAPI_OPTION_USE_TICKET_CACHE("Indicates whether to attempt to use a ticket cache in order to determine whether the user has an existing Kerberos session that may be used instead of using a newly-created session."),
    INFO_SASL_HELP_MECHANISM("The {0} SASL Mechanism"),
    INFO_SASL_HELP_MECHANISM_OPTIONS("The SASL options available for use with the {0} mechanism include:"),
    INFO_SASL_HELP_PASSWORD_OPTIONAL("A password may optionally be provided when using the {0} SASL mechanism."),
    INFO_SASL_HELP_PASSWORD_REQUIRED("A password must be provided when using the {0} SASL mechanism."),
    INFO_SASL_PLAIN_DESCRIPTION("A mechanism that can allow the client to perform password-based authentication, optionally using an alternate authorization identity."),
    INFO_SASL_PLAIN_OPTION_AUTHZ_ID("A string which identifies the user under whose authority subsequent operations should be processed.  If this is not provided, then no alternate authorization identity will be used."),
    INFO_SASL_PLAIN_OPTION_AUTH_ID("A string which identifies the user that is trying to authenticate.  The value is typically in the from \"dn:\" followed by the DN of the target user's entry, or \"u:\" followed  by the username for the target user.");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<UtilityMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<UtilityMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private UtilityMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                s = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception e) {
                s = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-util");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

