/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.protocols.FcHeader;
import org.jgroups.protocols.FlowControl;
import org.jgroups.protocols.TP;
import org.jgroups.util.Average;
import org.jgroups.util.Util;

@MBean(description="Simple flow control protocol based on a credit system")
public class UFC
extends FlowControl {
    protected static final FcHeader UFC_REPLENISH_HDR = new FcHeader(1);
    protected static final FcHeader UFC_CREDIT_REQUEST_HDR = new FcHeader(2);
    protected final Map<Address, FlowControl.Credit> sent = Util.createConcurrentMap();
    protected final Average avg_block_time = new Average();

    @Override
    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return UFC.printMap(this.sent);
    }

    @Override
    @ManagedOperation(description="Print credits")
    public String printCredits() {
        StringBuilder sb = new StringBuilder(super.printCredits());
        sb.append("\nsenders:\n").append(UFC.printMap(this.sent));
        return sb.toString();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("senders", UFC.printMap(this.sent));
        return retval;
    }

    @Override
    protected boolean handleMulticastMessage() {
        return false;
    }

    @Override
    protected Header getReplenishHeader() {
        return UFC_REPLENISH_HDR;
    }

    @Override
    protected Header getCreditRequestHeader() {
        return UFC_CREDIT_REQUEST_HDR;
    }

    @Override
    public void unblock() {
        super.unblock();
    }

    @Override
    @ManagedAttribute(description="Number of times flow control blocks sender")
    public int getNumberOfBlockings() {
        int retval = 0;
        for (FlowControl.Credit cred : this.sent.values()) {
            retval += cred.getNumBlockings();
        }
        return retval;
    }

    @Override
    @ManagedAttribute(description="Average time blocked (in ms) in flow control when trying to send a message")
    public double getAverageTimeBlocked() {
        return this.avg_block_time.getAverage() / 1000000.0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        TP transport = this.getTransport();
        if (transport instanceof BasicTCP) {
            this.log.info(this.getClass().getSimpleName() + " is not needed (and can be removed) as we're running on a TCP transport");
        }
    }

    @Override
    public void stop() {
        super.stop();
        for (FlowControl.Credit cred : this.sent.values()) {
            cred.set(this.max_credits);
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg_block_time.clear();
        for (FlowControl.Credit cred : this.sent.values()) {
            cred.reset();
        }
    }

    @Override
    protected Object handleDownMessage(Event evt, Message msg, Address dest, int length) {
        boolean rc;
        long block_time;
        if (dest == null) {
            this.log.error("%s doesn't handle multicast messages; passing message down", this.getClass().getSimpleName());
            return this.down_prot.down(evt);
        }
        FlowControl.Credit cred = this.sent.get(dest);
        if (cred == null) {
            return this.down_prot.down(evt);
        }
        long l = block_time = this.max_block_times != null ? this.getMaxBlockTime(length) : this.max_block_time;
        while (this.running && this.sent.containsKey(dest) && !(rc = cred.decrementIfEnoughCredits(length, block_time)) && this.running && this.max_block_times == null) {
            if (!cred.needToSendCreditRequest()) continue;
            this.sendCreditRequest(dest, Math.max(0L, this.max_credits - cred.get()));
        }
        return this.down_prot.down(evt);
    }

    @Override
    protected void handleViewChange(List<Address> mbrs) {
        super.handleViewChange(mbrs);
        if (mbrs == null) {
            return;
        }
        for (Address addr : mbrs) {
            if (this.sent.containsKey(addr)) continue;
            this.sent.put(addr, new FlowControl.Credit(this.max_credits, this.avg_block_time));
        }
        Iterator<Address> it = this.sent.keySet().iterator();
        while (it.hasNext()) {
            Address addr;
            addr = it.next();
            if (mbrs.contains(addr)) continue;
            it.remove();
        }
    }

    @Override
    protected void handleCredit(Address sender, long increase) {
        FlowControl.Credit cred;
        if (sender == null || (cred = this.sent.get(sender)) == null || increase <= 0L) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            long new_credit = Math.min(this.max_credits, cred.get() + increase);
            this.log.trace("received %d credits from %s, old credits: %s, new credits: %d", increase, sender, cred, new_credit);
        }
        cred.increment(increase);
    }
}

