/*
 * Decompiled with CFR 0.152.
 */
package com.example.schooltimetabling.solver;

import com.example.schooltimetabling.domain.Lesson;
import java.time.Duration;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;

public class TimeTableConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.roomConflict(constraintFactory), this.teacherConflict(constraintFactory), this.studentGroupConflict(constraintFactory), this.teacherRoomStability(constraintFactory), this.teacherTimeEfficiency(constraintFactory), this.studentGroupSubjectVariety(constraintFactory)};
    }

    Constraint roomConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(Lesson.class, Joiners.equal(Lesson::getTimeslot), Joiners.equal(Lesson::getRoom)).penalize("Room conflict", (Score)HardSoftScore.ONE_HARD);
    }

    Constraint teacherConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(Lesson.class, Joiners.equal(Lesson::getTimeslot), Joiners.equal(Lesson::getTeacher)).penalize("Teacher conflict", (Score)HardSoftScore.ONE_HARD);
    }

    Constraint studentGroupConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(Lesson.class, Joiners.equal(Lesson::getTimeslot), Joiners.equal(Lesson::getStudentGroup)).penalize("Student group conflict", (Score)HardSoftScore.ONE_HARD);
    }

    Constraint teacherRoomStability(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(Lesson.class, Joiners.equal(Lesson::getTeacher)).filter((lesson1, lesson2) -> lesson1.getRoom() != lesson2.getRoom()).penalize("Teacher room stability", (Score)HardSoftScore.ONE_SOFT);
    }

    Constraint teacherTimeEfficiency(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Lesson.class).join(Lesson.class, Joiners.equal(Lesson::getTeacher), Joiners.equal(lesson -> lesson.getTimeslot().getDayOfWeek())).filter((lesson1, lesson2) -> {
            Duration between = Duration.between(lesson1.getTimeslot().getEndTime(), lesson2.getTimeslot().getStartTime());
            return !between.isNegative() && between.compareTo(Duration.ofMinutes(30L)) <= 0;
        }).reward("Teacher time efficiency", (Score)HardSoftScore.ONE_SOFT);
    }

    Constraint studentGroupSubjectVariety(ConstraintFactory constraintFactory) {
        return constraintFactory.from(Lesson.class).join(Lesson.class, Joiners.equal(Lesson::getSubject), Joiners.equal(Lesson::getStudentGroup), Joiners.equal(lesson -> lesson.getTimeslot().getDayOfWeek())).filter((lesson1, lesson2) -> {
            Duration between = Duration.between(lesson1.getTimeslot().getEndTime(), lesson2.getTimeslot().getStartTime());
            return !between.isNegative() && between.compareTo(Duration.ofMinutes(30L)) <= 0;
        }).penalize("Student group subject variety", (Score)HardSoftScore.ONE_SOFT);
    }
}

