/*
 * Decompiled with CFR 0.152.
 */
package com.example.schooltimetabling.solver;

import com.example.schooltimetabling.domain.TimeTable;
import com.example.schooltimetabling.persistence.TimeTableRepository;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timeTable"})
public class TimeTableController {
    @Autowired
    private TimeTableRepository timeTableRepository;
    @Autowired
    private SolverManager<TimeTable, Long> solverManager;
    @Autowired
    private ScoreManager<TimeTable> scoreManager;

    @GetMapping
    public TimeTable getTimeTable() {
        SolverStatus solverStatus = this.getSolverStatus();
        TimeTable solution = this.timeTableRepository.findById(TimeTableRepository.SINGLETON_TIME_TABLE_ID);
        this.scoreManager.updateScore((Object)solution);
        solution.setSolverStatus(solverStatus);
        return solution;
    }

    @PostMapping(value={"/solve"})
    public void solve() {
        this.solverManager.solveAndListen((Object)TimeTableRepository.SINGLETON_TIME_TABLE_ID, this.timeTableRepository::findById, this.timeTableRepository::save);
    }

    public SolverStatus getSolverStatus() {
        return this.solverManager.getSolverStatus((Object)TimeTableRepository.SINGLETON_TIME_TABLE_ID);
    }

    @PostMapping(value={"/stopSolving"})
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)TimeTableRepository.SINGLETON_TIME_TABLE_ID);
    }
}

