/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class LinkCollectingAssociationHandler
implements SimpleAssociationHandler {
    private static final String AMBIGUOUS_ASSOCIATIONS = "Detected multiple association links with same relation type! Disambiguate association %s using @RestResource!";
    private final PersistentEntities entities;
    private final Associations associations;
    private final Path basePath;
    private final boolean nested;
    private final List<Link> links;

    public LinkCollectingAssociationHandler(PersistentEntities entities, Path path, Associations associations) {
        this(entities, path, associations, false);
    }

    private LinkCollectingAssociationHandler(PersistentEntities entities, Path path, Associations associations, boolean nested) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)path, (String)"Path must not be null!");
        Assert.notNull((Object)associations, (String)"AssociationLinks must not be null!");
        this.entities = entities;
        this.associations = associations;
        this.basePath = path;
        this.links = new ArrayList<Link>();
        this.nested = nested;
    }

    public LinkCollectingAssociationHandler nested() {
        return this.nested ? this : new LinkCollectingAssociationHandler(this.entities, this.basePath, this.associations, true);
    }

    public Links getLinks() {
        return Links.of(this.links);
    }

    public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
        PersistentProperty property = association.getInverse();
        if (this.associations.isLinkableAssociation(property)) {
            Links existingLinks = Links.of(this.links);
            for (Link link : this.associations.getLinksFor(association, this.basePath)) {
                if (existingLinks.hasLink(link.getRel())) {
                    throw new MappingException(String.format(AMBIGUOUS_ASSOCIATIONS, property.toString()));
                }
                this.links.add(link);
            }
        }
    }
}

