/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.marshalling.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.guvnor.ala.marshalling.Marshaller;

public abstract class JSONBaseMarshaller<T>
implements Marshaller<T> {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected final Class<T> type;

    public JSONBaseMarshaller(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String marshal(T value) throws IOException {
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public T unmarshal(String marshalledValue) throws IOException {
        return (T)this.objectMapper.readValue(marshalledValue, this.type);
    }
}

