/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public class CoreIndexer
implements Indexer {
    private final IOService ioService;
    private final Class<? extends FileAttributeView>[] views;

    @SafeVarargs
    public CoreIndexer(IOService ioService, Class<? extends FileAttributeView> ... views) {
        this.ioService = ioService;
        this.views = views;
    }

    public boolean supportsPath(Path path) {
        return true;
    }

    public KObject toKObject(Path path) {
        if (!this.ioService.exists(path)) {
            return null;
        }
        for (Class<? extends FileAttributeView> view : this.views) {
            this.ioService.getFileAttributeView(path, view);
        }
        FileAttribute[] attrs = this.ioService.convert(this.ioService.readAttributes(path));
        return KObjectUtil.toKObject(path, attrs);
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey(path);
    }
}

