/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanPingService {
    private Logger logger = LoggerFactory.getLogger(InfinispanPingService.class);
    protected static final String PING = "org.appformer.ext.metadata.infinispan.ping";
    private final ExecutorService executor;
    private long sleep = this.getTimeoutOrElse("org.appformer.ext.metadata.infinispan.ping", 5);
    private boolean alive = false;
    private RemoteCacheManager cacheManager;
    private boolean stop = false;

    public InfinispanPingService(RemoteCacheImpl remoteCache) {
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(() -> {
            while (!this.stop) {
                try {
                    this.alive = remoteCache.ping().isSuccess();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.error("Infinispan server is not started");
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.error("Infinispan server is not started", (Throwable)e);
                    }
                    this.alive = false;
                }
                try {
                    Thread.sleep(this.sleep * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    protected int getTimeoutOrElse(String timeout, int defaultValue) {
        String t = System.getProperty(timeout);
        return t != null && !t.isEmpty() ? Integer.parseInt(t) : defaultValue;
    }

    public boolean ping() {
        return this.alive;
    }

    public void stop() {
        this.stop = true;
        this.executor.shutdownNow();
    }
}

