/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.InstanceGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.kie.api.runtime.KieContainer;

public class RuleScenarioRunnerHelper
extends AbstractRunnerHelper {
    @Override
    protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, ScesimModelDescriptor scesimModelDescriptor, Settings settings) {
        if (!ScenarioSimulationModel.Type.RULE.equals((Object)settings.getType())) {
            throw new ScenarioException("Impossible to run a not-RULE simulation with RULE runner");
        }
        RuleScenarioExecutableBuilder ruleScenarioExecutableBuilder = this.createBuilderWrapper(kieContainer, settings);
        if (settings.getRuleFlowGroup() != null) {
            ruleScenarioExecutableBuilder.setActiveRuleFlowGroup(settings.getRuleFlowGroup());
        }
        this.loadInputData(scenarioRunnerData.getBackgrounds(), ruleScenarioExecutableBuilder);
        this.loadInputData(scenarioRunnerData.getGivens(), ruleScenarioExecutableBuilder);
        scenarioRunnerData.getExpects().stream().filter(ScenarioExpect::isNewFact).flatMap(output -> output.getExpectedResult().stream().map(ScenarioResult::new)).forEach(scenarioResult -> {
            Class clazz = ScenarioBeanUtil.loadClass(scenarioResult.getFactIdentifier().getClassName(), kieContainer.getClassLoader());
            ExpressionEvaluator expressionEvaluator = expressionEvaluatorFactory.getOrCreate(scenarioResult.getFactMappingValue());
            scenarioRunnerData.addResult((ScenarioResult)scenarioResult);
            ruleScenarioExecutableBuilder.addInternalCondition(clazz, this.createExtractorFunction(expressionEvaluator, scenarioResult.getFactMappingValue(), scesimModelDescriptor), (ScenarioResult)scenarioResult);
        });
        return ruleScenarioExecutableBuilder.run();
    }

    @Override
    protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
        CoverageAgendaListener coverageAgendaListener = (CoverageAgendaListener)((Object)requestContext.get("COVERAGE_LISTENER"));
        Map<String, Integer> ruleExecuted = coverageAgendaListener.getRuleExecuted();
        Set availableRules = (Set)requestContext.get("RULES_AVAILABLE");
        ScenarioResultMetadata scenarioResultMetadata = new ScenarioResultMetadata(scenarioWithIndex);
        scenarioResultMetadata.addAllAvailable(availableRules);
        scenarioResultMetadata.addAllExecuted(ruleExecuted);
        AtomicInteger counter = new AtomicInteger(0);
        coverageAgendaListener.getAuditsMessages().forEach(auditMessage -> scenarioResultMetadata.addAuditMessage(counter.addAndGet(1), (String)auditMessage, "EXECUTED"));
        return scenarioResultMetadata;
    }

    @Override
    protected void verifyConditions(ScesimModelDescriptor scesimModelDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, Map<String, Object> requestContext) {
        for (InstanceGiven input : scenarioRunnerData.getGivens()) {
            FactIdentifier factIdentifier = input.getFactIdentifier();
            List<ScenarioExpect> assertionOnFact = scenarioRunnerData.getExpects().stream().filter(elem -> !elem.isNewFact()).filter(elem -> Objects.equals(elem.getFactIdentifier(), factIdentifier)).collect(Collectors.toList());
            if (assertionOnFact.isEmpty()) continue;
            this.getScenarioResultsFromGivenFacts(scesimModelDescriptor, assertionOnFact, input, expressionEvaluatorFactory).forEach(scenarioRunnerData::addResult);
        }
    }

    protected List<ScenarioResult> getScenarioResultsFromGivenFacts(ScesimModelDescriptor scesimModelDescriptor, List<ScenarioExpect> scenarioOutputsPerFact, InstanceGiven input, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        Object factInstance = input.getValue();
        ArrayList<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
        for (ScenarioExpect scenarioExpect : scenarioOutputsPerFact) {
            if (scenarioExpect.isNewFact()) continue;
            for (FactMappingValue expectedResult : scenarioExpect.getExpectedResult()) {
                ExpressionEvaluator expressionEvaluator = expressionEvaluatorFactory.getOrCreate(expectedResult);
                ScenarioResult scenarioResult = this.fillResult(expectedResult, () -> this.createExtractorFunction(expressionEvaluator, expectedResult, scesimModelDescriptor).apply(factInstance), expressionEvaluator);
                scenarioResults.add(scenarioResult);
            }
        }
        return scenarioResults;
    }

    protected Function<Object, ValueWrapper> createExtractorFunction(ExpressionEvaluator expressionEvaluator, FactMappingValue expectedResult, ScesimModelDescriptor scesimModelDescriptor) {
        return objectToCheck -> {
            ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)scesimModelDescriptor.getFactMapping(expectedResult.getFactIdentifier(), expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List<String> pathToValue = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            ScenarioBeanWrapper<?> scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject(objectToCheck, pathToValue, false);
            Object resultValue = scenarioBeanWrapper.getBean();
            Object expectedResultValue = expectedResult.getRawValue();
            return this.getResultWrapper(factMapping.getClassName(), expectedResult, expressionEvaluator, expectedResultValue, resultValue, scenarioBeanWrapper.getBeanClass());
        };
    }

    protected void loadInputData(List<InstanceGiven> dataToLoad, RuleScenarioExecutableBuilder executableBuilder) {
        for (InstanceGiven instanceGiven : dataToLoad) {
            executableBuilder.insert(instanceGiven.getValue());
        }
    }

    @Override
    protected Object createObject(ValueWrapper<Object> initialInstance, String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        return ScenarioBeanUtil.fillBean(initialInstance, className, params, classLoader);
    }

    protected RuleScenarioExecutableBuilder createBuilderWrapper(KieContainer kieContainer, Settings settings) {
        return RuleScenarioExecutableBuilder.createBuilder(kieContainer, settings.getDmoSession(), settings.isStateless());
    }
}

