/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.controller;

import java.net.URLEncoder;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.common.KeyStoreHelperUtil;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpResponse;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestControllerImpl
implements KieServerController {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRestControllerImpl.class);
    private final KieServerRegistry context;

    public DefaultRestControllerImpl(KieServerRegistry context) {
        this.context = context;
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, String user, String password, String token) {
        logger.debug("About to send PUT request to '{}' with payload '{}' by thread {}", new Object[]{uri, body, Thread.currentThread().getId()});
        KieServerHttpRequest request = this.newRequest(uri, user, password, token).body((CharSequence)body).put();
        KieServerHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending PUT request to " + uri + " response code " + response.code());
    }

    protected <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, String user, String password, String token) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieServerHttpRequest request = this.newRequest(uri, user, password, token).body((CharSequence)body).post();
        KieServerHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode() || response.code() == Response.Status.OK.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending POST request to " + uri + " response code " + response.code());
    }

    protected <T> T makeHttpDeleteRequestAndCreateCustomResponse(String uri, Class<T> resultType, String user, String password, String token) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieServerHttpRequest request = this.newRequest(uri, user, password, token).delete();
        KieServerHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.NO_CONTENT.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending DELETE request to " + uri + " response code " + response.code());
    }

    private KieServerHttpRequest newRequest(String uri, String userName, String password, String token) {
        KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)uri).followRedirects(true).timeout(5000L);
        httpRequest.accept("application/json");
        if (token != null && !token.isEmpty()) {
            httpRequest.tokenAuthorization(token);
        } else {
            httpRequest.basicAuthorization(userName, password);
        }
        return httpRequest;
    }

    private <T> T deserialize(String content, Class<T> type) {
        if (type == null) {
            return null;
        }
        try {
            return (T)MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while deserializing data received from server!", e);
        }
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).marshall(object);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while serializing request data!", e);
        }
    }

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                KieServerSetup kieServerSetup;
                if (controllerUrl == null || controllerUrl.isEmpty() || (kieServerSetup = this.connectToSingleController(serverInfo, config, controllerUrl)) == null || !kieServerSetup.hasNoErrors()) continue;
                return kieServerSetup;
            }
            throw new KieControllerNotConnectedException("Unable to connect to any controller");
        }
        throw new KieControllerNotDefinedException("Unable to connect to any controller");
    }

    public void disconnect(KieServerInfo serverInfo) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        for (String controllerUrl : controllers) {
            boolean disconnected;
            if (controllerUrl != null && !controllerUrl.isEmpty() && (disconnected = this.disconnectFromSingleController(serverInfo, config, controllerUrl))) break;
        }
    }

    public KieServerSetup update(KieServerStateInfo serverTemplateUpdate) {
        if (!Boolean.valueOf(System.getProperty("org.kie.server.update..notifications.rest.enabled", "true")).booleanValue()) {
            return new KieServerSetup();
        }
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerSetup kieServerSetup = null;
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                if (controllerUrl == null || controllerUrl.isEmpty()) continue;
                String connectAndSyncUrl = controllerUrl + "/server/" + KieServerEnvironment.getServerId();
                String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                String password = KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config);
                String token = config.getConfigItemValue("org.kie.server.controller.token");
                try {
                    kieServerSetup = this.makeHttpPostRequestAndCreateCustomResponse(connectAndSyncUrl, this.serialize(serverTemplateUpdate), KieServerSetup.class, userName, password, token);
                }
                catch (Exception e) {
                    logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                    logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
                }
            }
        } else {
            logger.warn("No controllers found to update to new status {}", (Object)serverTemplateUpdate);
        }
        return kieServerSetup;
    }

    public KieServerSetup connectToSingleController(Object info, KieServerConfig config, String controllerUrl) {
        String connectAndSyncUrl = controllerUrl + "/server/" + KieServerEnvironment.getServerId();
        String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
        String password = KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config);
        String token = config.getConfigItemValue("org.kie.server.controller.token");
        try {
            KieServerSetup kieServerSetup = this.makeHttpPutRequestAndCreateCustomResponse(connectAndSyncUrl, this.serialize(info), KieServerSetup.class, userName, password, token);
            if (kieServerSetup != null && kieServerSetup.hasNoErrors()) {
                return kieServerSetup;
            }
        }
        catch (Exception e) {
            logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
            logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
        }
        return null;
    }

    public boolean disconnectFromSingleController(KieServerInfo serverInfo, KieServerConfig config, String controllerUrl) {
        String connectAndSyncUrl = null;
        try {
            connectAndSyncUrl = controllerUrl + "/server/" + KieServerEnvironment.getServerId() + "/?location=" + URLEncoder.encode(serverInfo.getLocation(), "UTF-8");
            String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
            String password = KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config);
            String token = config.getConfigItemValue("org.kie.server.controller.token");
            this.makeHttpDeleteRequestAndCreateCustomResponse(connectAndSyncUrl, null, userName, password, token);
            return true;
        }
        catch (Exception e) {
            logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
            return false;
        }
    }

    public void startContainer(String containerId) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                if (controllerUrl == null || controllerUrl.isEmpty()) continue;
                String connectAndSyncUrl = controllerUrl + "/management/servers/" + KieServerEnvironment.getServerId() + "/containers/" + containerId + "/status/started";
                String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                String password = KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config);
                String token = config.getConfigItemValue("org.kie.server.controller.token");
                try {
                    this.makeHttpPostRequestAndCreateCustomResponse(connectAndSyncUrl, "", null, userName, password, token);
                    break;
                }
                catch (Exception e) {
                    logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                    logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
                }
            }
        }
    }

    public void stopContainer(String containerId) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                if (controllerUrl == null || controllerUrl.isEmpty()) continue;
                String connectAndSyncUrl = controllerUrl + "/management/servers/" + KieServerEnvironment.getServerId() + "/containers/" + containerId + "/status/stopped";
                String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                String password = KeyStoreHelperUtil.loadControllerPassword((KieServerConfig)config);
                String token = config.getConfigItemValue("org.kie.server.controller.token");
                try {
                    this.makeHttpPostRequestAndCreateCustomResponse(connectAndSyncUrl, "", null, userName, password, token);
                    break;
                }
                catch (Exception e) {
                    logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                    logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
                }
            }
        }
    }
}

