/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.assembler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.errors.SrcError;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.DescrBuildWarning;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.ParserError;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.api.pmml.PMMLConstants;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.jci.CompilationProblem;
import org.kie.pmml.pmml_4_2.PMML4Compiler;
import org.kie.pmml.pmml_4_2.PMML4Exception;
import org.kie.pmml.pmml_4_2.PMMLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLAssemblerService
implements KieAssemblerService {
    private ClassLoader rootClassLoader;
    private KnowledgeBuilderConfigurationImpl configuration;
    private KnowledgeBuilderImpl kbuilder;
    private static final String JAVA_ROOT = "src/main/java/";
    private static final PMML4Compiler pmmlCompiler = new PMML4Compiler();
    private static final Logger log = LoggerFactory.getLogger(PMMLAssemblerService.class);

    private static boolean isOtherImplementationPresent() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean isToEnable() {
        if (!PMMLAssemblerService.isOtherImplementationPresent()) {
            return true;
        }
        String property = System.getProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        return property.equals(PMMLConstants.LEGACY.getName());
    }

    private static boolean isjPMMLAvailableToClassLoader(ClassLoader classLoader) {
        try {
            classLoader.loadClass("org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator");
            log.info("jpmml libraries available on classpath, skipping kie-pmml parsing and compilation");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public ResourceType getResourceType() {
        return PMMLAssemblerService.isToEnable() ? ResourceType.PMML : ResourceType.NOOP;
    }

    public synchronized void addResource(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        this.kbuilder = (KnowledgeBuilderImpl)kbuilder;
        this.configuration = this.kbuilder.getBuilderConfiguration();
        this.rootClassLoader = this.kbuilder.getRootClassLoader();
        if (!PMMLAssemblerService.isjPMMLAvailableToClassLoader(this.rootClassLoader)) {
            this.addPackage(resource);
        }
    }

    public synchronized void addResources(Object kbuilder, Collection<ResourceWithConfiguration> resources, ResourceType type) throws Exception {
        for (ResourceWithConfiguration rd : resources) {
            if (rd.getBeforeAdd() != null) {
                rd.getBeforeAdd().accept(kbuilder);
            }
            this.addResource(kbuilder, rd.getResource(), type, rd.getResourceConfiguration());
            if (rd.getAfterAdd() == null) continue;
            rd.getAfterAdd().accept(kbuilder);
        }
    }

    private void addPackage(Resource resource) throws DroolsParserException, IOException {
        if (pmmlCompiler != null && pmmlCompiler.getResults().isEmpty()) {
            List<PackageDescr> packages;
            PMML pmml = pmmlCompiler.loadModel("org.kie.pmml.pmml_4_2.descr", resource.getInputStream());
            this.addPMMLPojos(pmmlCompiler, resource, pmml);
            if (pmmlCompiler.getResults().isEmpty() && (packages = this.getPackageDescrs(resource, pmml)) != null && !packages.isEmpty()) {
                for (PackageDescr descr : packages) {
                    this.kbuilder.addPackage(descr);
                }
            }
        }
        pmmlCompiler.getResults().forEach(result -> this.kbuilder.addBuilderResult(result));
    }

    private List<PackageDescr> getPackageDescrs(Resource resource, PMML pmml) throws DroolsParserException, IOException {
        List<PMMLResource> resources = pmmlCompiler.precompile(pmml, null);
        if (resources != null && !resources.isEmpty()) {
            return this.generatedResourcesToPackageDescr(resource, resources);
        }
        return null;
    }

    private List<PackageDescr> generatedResourcesToPackageDescr(Resource resource, List<PMMLResource> resources) throws DroolsParserException {
        ArrayList<PackageDescr> pkgDescrs = new ArrayList<PackageDescr>();
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        for (PMMLResource res : resources) {
            for (Map.Entry<String, String> entry : res.getRules().entrySet()) {
                String key = entry.getKey();
                String src = entry.getValue();
                PackageDescr descr = null;
                descr = parser.parse(false, src);
                if (descr != null) {
                    descr.setResource(resource);
                    pkgDescrs.add(descr);
                    this.dumpGeneratedRule(descr, key, src);
                    continue;
                }
                this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new ParserError(resource, "Parser returned a null Package", 0, 0));
            }
        }
        return pkgDescrs;
    }

    private void dumpGeneratedRule(PackageDescr descr, String resName, String src) {
        File dumpDir = this.configuration.getDumpDir();
        if (dumpDir != null) {
            try {
                String dirName = dumpDir.getCanonicalPath().endsWith("/") ? dumpDir.getCanonicalPath() : dumpDir.getCanonicalPath() + "/";
                String outputPath = dirName + resName + ".drl";
                try (FileOutputStream fos = new FileOutputStream(outputPath);){
                    fos.write(src.getBytes());
                }
                catch (IOException iox) {
                    this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new DescrBuildWarning(null, (BaseDescr)descr, (Object)descr.getResource(), "Unable to write generated rules the dump directory: " + outputPath));
                }
            }
            catch (IOException e) {
                this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new DescrBuildWarning(null, (BaseDescr)descr, (Object)descr.getResource(), "Unable to access the dump directory"));
            }
        }
    }

    private void addPMMLPojos(PMML4Compiler compiler, Resource resource, PMML pmml) {
        KieFileSystem javaSource = KieServices.Factory.get().newKieFileSystem();
        HashMap<String, String> javaSources = new HashMap<String, String>();
        Map<String, String> modelSources = null;
        try {
            modelSources = compiler.getJavaClasses(pmml);
        }
        catch (PMML4Exception px) {
            this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new SrcError((Object)resource, px.getMessage()));
        }
        if (compiler.getResults().isEmpty()) {
            if (modelSources != null && !modelSources.isEmpty()) {
                javaSources.putAll(modelSources);
            }
            for (Map.Entry entry : javaSources.entrySet()) {
                String key = (String)entry.getKey();
                String javaCode = (String)entry.getValue();
                if (javaCode == null || javaCode.trim().isEmpty()) continue;
                Resource res = ResourceFactory.newByteArrayResource((byte[])javaCode.getBytes()).setResourceType(ResourceType.JAVA);
                String sourcePath = key.replaceAll("\\.", "/") + ".java";
                res.setSourcePath(sourcePath);
                javaSource.write(res);
            }
            MemoryFileSystem src = ((KieFileSystemImpl)javaSource).asMemoryFileSystem();
            List<String> javaFileNames = this.getJavaFileNames((ResourceReader)src);
            if (javaFileNames != null && !javaFileNames.isEmpty()) {
                ClassLoader classLoader = this.rootClassLoader;
                KnowledgeBuilderConfigurationImpl kconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{classLoader});
                JavaDialectConfiguration javaConf = (JavaDialectConfiguration)kconf.getDialectConfiguration("java");
                MemoryFileSystem trgMfs = new MemoryFileSystem();
                this.compileJavaClasses(javaConf, this.rootClassLoader, javaFileNames, JAVA_ROOT, (ResourceReader)src, trgMfs);
                HashMap<String, byte[]> classesMap = new HashMap<String, byte[]>();
                for (String name : trgMfs.getFileNames()) {
                    classesMap.put(name, trgMfs.getBytes(name));
                }
                if (!classesMap.isEmpty()) {
                    ProjectClassLoader projectClassLoader = (ProjectClassLoader)this.rootClassLoader;
                    if (ClassUtils.isCaseSenstiveOS()) {
                        projectClassLoader.reinitTypes();
                    }
                    projectClassLoader.storeClasses(classesMap);
                }
            }
        }
    }

    private List<String> getJavaFileNames(ResourceReader src) {
        ArrayList<String> javaFileNames = new ArrayList<String>();
        for (String fname : src.getFileNames()) {
            if (!fname.endsWith(".java")) continue;
            javaFileNames.add(fname);
        }
        return javaFileNames;
    }

    private void compileJavaClasses(JavaDialectConfiguration javaConf, ClassLoader classLoader, List<String> javaFiles, String rootFolder, ResourceReader source, MemoryFileSystem trgMfs) {
        if (!javaFiles.isEmpty()) {
            String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
            File dumpDir = javaConf.getPackageBuilderConfiguration().getDumpDir();
            if (dumpDir != null) {
                try {
                    String dumpDirName = dumpDir.getCanonicalPath().endsWith("/") ? dumpDir.getCanonicalPath() : dumpDir.getCanonicalPath() + "/";
                    for (String srcFile : sourceFiles) {
                        String baseName = (srcFile.startsWith(JAVA_ROOT) ? srcFile.substring(JAVA_ROOT.length()) : srcFile).replaceAll("/", ".");
                        String fname = dumpDirName + baseName;
                        byte[] srcData = source.getBytes(srcFile);
                        try (FileOutputStream fos = new FileOutputStream(fname);){
                            fos.write(srcData);
                        }
                        catch (IOException iox) {
                            this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new SrcError((Object)fname, iox.getMessage()));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            JavaCompiler javaCompiler = this.createCompiler(javaConf, rootFolder);
            CompilationResult res = javaCompiler.compile(sourceFiles, source, (ResourceStore)trgMfs, classLoader);
            for (CompilationProblem problem : res.getErrors()) {
                this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new SrcError((Object)problem.getFileName(), problem.getMessage()));
            }
            for (CompilationProblem problem : res.getWarnings()) {
                this.kbuilder.addBuilderResult((KnowledgeBuilderResult)new SrcError((Object)problem.getFileName(), problem.getMessage()));
            }
        }
    }

    private JavaCompiler createCompiler(JavaDialectConfiguration javaConf, String prefix) {
        JavaCompiler javaCompiler = JavaCompilerFactory.INSTANCE.loadCompiler(javaConf);
        if (javaCompiler instanceof EclipseJavaCompiler) {
            ((EclipseJavaCompiler)javaCompiler).setPrefix(prefix);
        }
        return javaCompiler;
    }
}

