/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.server.api.model.definition.ProcessStartSpec;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ConvertUtils;
import org.kie.server.services.jbpm.locator.ByProcessInstanceIdContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(ProcessServiceBase.class);
    private ProcessService processService;
    private DefinitionService definitionService;
    private RuntimeDataService runtimeDataService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public ProcessServiceBase(ProcessService processService, DefinitionService definitionService, RuntimeDataService runtimeDataService, KieServerRegistry context) {
        this.processService = processService;
        this.definitionService = definitionService;
        this.runtimeDataService = runtimeDataService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
    }

    public void setMarshallerHelper(MarshallerHelper marshallerHelper) {
        this.marshallerHelper = marshallerHelper;
    }

    public String startProcess(String containerId, String processId, String marshallingType) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        this.definitionService.getProcessDefinition(containerId, processId);
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, null});
        Long processInstanceId = this.processService.startProcess(containerId, processId);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
        return response;
    }

    public String startProcess(String containerId, String processId, String payload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        this.definitionService.getProcessDefinition(containerId, processId);
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, parameters);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
    }

    public String startProcessFromNodeIds(String containerId, String processId, String payload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        this.definitionService.getProcessDefinition(containerId, processId);
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        ProcessStartSpec parameters = (ProcessStartSpec)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, ProcessStartSpec.class);
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters.getVariables()});
        Long newProcessInstanceId = this.processService.startProcessFromNodeIds(containerId, processId, parameters.getVariables(), new String[0]);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)newProcessInstanceId);
    }

    public String startProcessWithCorrelationKeyFromNodeIds(String containerId, String processId, String correlationKey, String payload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        this.definitionService.getProcessDefinition(containerId, processId);
        logger.debug("About to unmarshal parameters from start spec parameters: '{}'", (Object)payload);
        ProcessStartSpec parameters = (ProcessStartSpec)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, ProcessStartSpec.class);
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        logger.debug("Calling start  from custom nodes process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters.getVariables()});
        Long newProcessInstanceId = this.processService.startProcessFromNodeIds(containerId, processId, actualCorrelationKey, parameters.getVariables(), (String[])parameters.getNodeIds().stream().toArray(String[]::new));
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)newProcessInstanceId);
    }

    public String startProcessWithCorrelation(String containerId, String processId, String correlationKey, String payload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        this.definitionService.getProcessDefinition(containerId, processId);
        logger.debug("About to unmarshal parameters from start spec parameters: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        logger.debug("Calling start from custom nodes process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, actualCorrelationKey, parameters);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstanceId);
    }

    public Object abortProcessInstance(String containerId, Number processInstanceId) {
        try {
            containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
            this.processService.abortProcessInstance(containerId, Long.valueOf(processInstanceId.longValue()));
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentNotFoundException(e.getMessage());
        }
    }

    protected List<Long> convert(List<? extends Number> input) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Number number : input) {
            result.add(number.longValue());
        }
        return result;
    }

    public Object abortProcessInstances(String containerId, List<Long> processInstanceIds) {
        this.processService.abortProcessInstances(containerId, this.convert(processInstanceIds));
        return null;
    }

    public void signalProcessInstance(String containerId, Number processInstanceId, String signalName, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Calling signal '{}' process instance with id {} on container {} and event {}", new Object[]{signalName, processInstanceId, containerId, null});
        this.processService.signalProcessInstance(containerId, Long.valueOf(processInstanceId.longValue()), signalName, null);
    }

    public void signalProcessInstance(String containerId, Number processInstanceId, String signalName, String eventPayload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        logger.debug("Calling signal '{}' process instance with id {} on container {} and event {}", new Object[]{signalName, processInstanceId, containerId, event});
        this.processService.signalProcessInstance(containerId, Long.valueOf(processInstanceId.longValue()), signalName, event);
    }

    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, String marshallingType) {
        List<Long> ids = this.convert(processInstanceIds);
        if (ids.isEmpty()) {
            return;
        }
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(ids.get(0)));
        logger.debug("Calling signal '{}' process instances with id {} on container {} and event {}", new Object[]{signalName, processInstanceIds, containerId, null});
        this.processService.signalProcessInstances(containerId, this.convert(processInstanceIds), signalName, null);
    }

    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, String eventPayload, String marshallingType) {
        List<Long> ids = this.convert(processInstanceIds);
        if (ids.isEmpty()) {
            return;
        }
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(ids.get(0)));
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        logger.debug("Calling signal '{}' process instances with id {} on container {} and event {}", new Object[]{signalName, processInstanceIds, containerId, event});
        this.processService.signalProcessInstances(containerId, ids, signalName, event);
    }

    public void signalProcessInstanceByCorrelationKey(String containerId, String correlationKey, String signalName, String eventPayload, String marshallingType) {
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        logger.debug("Calling signal '{}' process instances with correlation key {} on container {} and event {}", new Object[]{signalName, correlationKey, containerId, event});
        this.processService.signalProcessInstanceByCorrelationKey(actualCorrelationKey, signalName, event);
    }

    public void signalProcessInstancesByCorrelationKey(String containerId, List<String> correlationKeys, String signalName, String eventPayload, String marshallingType) {
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        List keys = correlationKeys.stream().map(e -> this.correlationKeyFactory.newCorrelationKey(Arrays.asList(e.split(":")))).collect(Collectors.toList());
        logger.debug("Calling signal '{}' process instances with correlation key {} on container {} and event {}", new Object[]{signalName, keys, containerId, event});
        this.processService.signalProcessInstancesByCorrelationKeys(keys, signalName, event);
    }

    public void signal(String containerId, String signalName, String marshallingType) {
        logger.debug("Calling signal '{}' on container {} and event {}", new Object[]{signalName, containerId, null});
        this.processService.signalEvent(containerId, signalName, null);
    }

    public void signal(String containerId, String signalName, String eventPayload, String marshallingType) {
        logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
        Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, marshallingType, Object.class);
        logger.debug("Calling signal '{}' on container {} and event {}", new Object[]{signalName, containerId, event});
        this.processService.signalEvent(containerId, signalName, event);
    }

    public String getProcessInstance(String containerId, Number processInstanceId, boolean withVars, String marshallingType) {
        ProcessInstanceDesc instanceDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        if (instanceDesc == null) {
            throw new ProcessInstanceNotFoundException("Unable to find process instance with id " + processInstanceId);
        }
        if (!(containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()))).equals(instanceDesc.getDeploymentId())) {
            ConvertUtils.throwException(instanceDesc.getId(), containerId);
        }
        ProcessInstance processInstance = ConvertUtils.convertToProcessInstance(instanceDesc);
        if (Boolean.TRUE.equals(withVars) && processInstance.getState().equals(1)) {
            Map variables = this.processService.getProcessInstanceVariables(containerId, Long.valueOf(processInstanceId.longValue()));
            processInstance.setVariables(variables);
        }
        logger.debug("About to marshal process instance with id '{}' {}", (Object)processInstanceId, (Object)processInstance);
        return this.marshallerHelper.marshal(containerId, marshallingType, (Object)processInstance, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
    }

    public void setProcessVariable(String containerId, Number processInstanceId, String varName, String variablePayload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("About to unmarshal variable from payload: '{}'", (Object)variablePayload);
        Object variable = this.marshallerHelper.unmarshal(containerId, variablePayload, marshallingType, Object.class);
        logger.debug("Setting variable '{}' on process instance with id {} with value {}", new Object[]{varName, processInstanceId, variable});
        this.processService.setProcessVariable(containerId, Long.valueOf(processInstanceId.longValue()), varName, variable);
    }

    public void setProcessVariables(String containerId, Number processInstanceId, String variablePayload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("About to unmarshal variables from payload: '{}'", (Object)variablePayload);
        Map variables = (Map)this.marshallerHelper.unmarshal(containerId, variablePayload, marshallingType, Map.class);
        logger.debug("Setting variables '{}' on process instance with id {} with value {}", new Object[]{variables.keySet(), processInstanceId, variables.values()});
        this.processService.setProcessVariables(containerId, Long.valueOf(processInstanceId.longValue()), variables);
    }

    public String getProcessInstanceVariable(String containerId, Number processInstanceId, String varName, String marshallingType) {
        Object variable = this.processService.getProcessInstanceVariable(containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue())), Long.valueOf(processInstanceId.longValue()), varName);
        if (variable == null) {
            throw new IllegalStateException("Unable to find variable '" + varName + "' within process instance with id " + processInstanceId);
        }
        logger.debug("About to marshal process variable with name '{}' {}", (Object)varName, variable);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, variable);
        return response;
    }

    public String getProcessInstanceVariables(String containerId, Number processInstanceId, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        Map variables = this.processService.getProcessInstanceVariables(containerId, Long.valueOf(processInstanceId.longValue()));
        logger.debug("About to marshal process variables {}", (Object)variables);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)variables);
        return response;
    }

    public String getAvailableSignals(String containerId, Number processInstanceId, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        Collection signals = this.processService.getAvailableSignals(containerId, Long.valueOf(processInstanceId.longValue()));
        logger.debug("About to marshal available signals {}", (Object)signals);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)signals);
        return response;
    }

    public void completeWorkItem(String containerId, Number processInstanceId, Number workItemId, String resultPayload, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("About to unmarshal work item result from payload: '{}'", (Object)resultPayload);
        Map results = (Map)this.marshallerHelper.unmarshal(containerId, resultPayload, marshallingType, Map.class);
        logger.debug("Completing work item '{}' on process instance id {} with value {}", new Object[]{workItemId, processInstanceId, results});
        this.processService.completeWorkItem(containerId, Long.valueOf(processInstanceId.longValue()), Long.valueOf(workItemId.longValue()), results);
    }

    public void abortWorkItem(String containerId, Number processInstanceId, Number workItemId) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        logger.debug("Aborting work item '{}' on process instance id {}", (Object)workItemId, (Object)processInstanceId);
        this.processService.abortWorkItem(containerId, Long.valueOf(processInstanceId.longValue()), Long.valueOf(workItemId.longValue()));
    }

    public String getWorkItem(String containerId, Number processInstanceId, Number workItemId, String marshallingType) {
        WorkItem workItem = this.processService.getWorkItem(containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue())), Long.valueOf(processInstanceId.longValue()), Long.valueOf(workItemId.longValue()));
        if (workItem == null) {
            throw new IllegalStateException("Unable to find work item with id " + workItemId);
        }
        WorkItemInstance workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
        logger.debug("About to marshal work item {}", (Object)workItemInstance);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)workItemInstance, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        return response;
    }

    public String getWorkItemByProcessInstance(String containerId, Number processInstanceId, String marshallingType) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByProcessInstanceIdContainerLocator(processInstanceId.longValue()));
        List workItems = this.processService.getWorkItemByProcessInstance(containerId, Long.valueOf(processInstanceId.longValue()));
        WorkItemInstance[] instances = new WorkItemInstance[workItems.size()];
        int counter = 0;
        for (WorkItem workItem : workItems) {
            WorkItemInstance workItemInstance;
            instances[counter] = workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((org.drools.core.process.instance.WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((org.drools.core.process.instance.WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
            ++counter;
        }
        WorkItemInstanceList result = new WorkItemInstanceList(instances);
        logger.debug("About to marshal work items {}", (Object)result);
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)result);
        return response;
    }

    public ProcessInstanceList getProcessInstancesByParent(long parentProcessInstanceId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        return this.getProcessInstancesByParent(null, parentProcessInstanceId, status, page, pageSize, sort, sortOrder);
    }

    public ProcessInstanceList getProcessInstancesByParent(String containerId, long parentProcessInstanceId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        sort = ConvertUtils.checkSort(sort);
        status = ConvertUtils.checkStatus(status);
        Collection instances = this.runtimeDataService.getProcessInstancesByParent(Long.valueOf(parentProcessInstanceId), status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        logger.debug("Found {} process instances , statuses '{}'", (Object)instances.size(), status);
        ProcessInstanceList processInstanceList = ConvertUtils.convertToProcessInstanceList(instances, containerId);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return processInstanceList;
    }
}

