/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;

public class LhsBuilder
implements SourceBuilder {
    private static final char QUOTE_DOUBLE = '\"';
    private static final char QUOTE_LEFT = '\u201c';
    private static final char QUOTE_RIGHT = '\u201d';
    private int headerRow;
    private int headerCol;
    private String colDefPrefix;
    private String colDefSuffix;
    private boolean multiple;
    private boolean forAll;
    private String andop;
    private Map<Integer, String> constraints;
    private List<String> values;
    private boolean hasValues;
    private Map<Integer, FieldType> fieldTypes;
    private static Set<String> operators = new HashSet<String>();
    private static Set<String> annotations;
    private static final Pattern patParFrm;
    private static final Pattern patFrm;
    private static final Pattern patPar;
    private static final Pattern patEval;
    private static final Pattern patOopath;

    public LhsBuilder(int row, int column, String colDefinition) {
        this.headerRow = row;
        this.headerCol = column;
        this.constraints = new HashMap<Integer, String>();
        this.fieldTypes = new HashMap<Integer, FieldType>();
        this.values = new ArrayList<String>();
        this.forAll = false;
        String colDef = colDefinition == null ? "" : colDefinition;
        String annDef = "";
        int annPos = this.findFirstAnnotationPos(colDef);
        if (annPos > 0) {
            annDef = " " + colDef.substring(annPos);
            colDef = colDef.substring(0, annPos).trim();
        }
        if ("".equals(colDef)) {
            this.colDefSuffix = "";
            this.colDefPrefix = "";
            this.multiple = false;
            this.andop = "";
            return;
        }
        this.multiple = true;
        Matcher matEval = patEval.matcher(colDef);
        if (matEval.find()) {
            this.colDefPrefix = colDef.substring(0, matEval.start()) + "eval(";
            this.colDefSuffix = ")";
            this.andop = " && ";
            return;
        }
        this.andop = ", ";
        Matcher matParFrm = patParFrm.matcher(colDef);
        if (matParFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matParFrm.start()) + '(';
            this.colDefSuffix = ") from" + colDef.substring(matParFrm.end()) + annDef;
            return;
        }
        Matcher matFrm = patFrm.matcher(colDef);
        if (matFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matFrm.start()) + "(";
            this.colDefSuffix = ") from " + colDef.substring(matFrm.end()) + annDef;
            return;
        }
        Matcher matPar = patPar.matcher(colDef);
        if (matPar.find()) {
            this.colDefPrefix = colDef.substring(0, matPar.start()) + '(';
            this.colDefSuffix = ")" + colDef.substring(matPar.end()) + annDef;
            return;
        }
        if (patOopath.matcher(colDef).matches()) {
            this.colDefPrefix = colDef + '[';
            this.colDefSuffix = "]" + annDef;
            return;
        }
        this.colDefPrefix = colDef + '(';
        this.colDefSuffix = ")" + annDef;
    }

    private int findFirstAnnotationPos(String colDef) {
        int pos = -1;
        for (String annotation : annotations) {
            int annPos = colDef.indexOf(annotation);
            if (annPos <= 0) continue;
            pos = pos < 0 ? annPos : Math.min(pos, annPos);
        }
        return pos;
    }

    @Override
    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.CONDITION;
    }

    @Override
    public void addTemplate(int row, int column, String content) {
        content = content.trim();
        if (this.constraints.containsKey(column)) {
            throw new IllegalArgumentException("Internal error: Can't have a constraint added twice to one spreadsheet col.");
        }
        if (this.fieldTypes.containsKey(column)) {
            throw new IllegalArgumentException("Internal error: Can't have a FieldType added twice to one spreadsheet col.");
        }
        FieldType fieldType = this.calcFieldType(content);
        if (!this.isMultipleConstraints()) {
            this.constraints.put(column, content);
        } else if (fieldType == FieldType.FORALL_FIELD) {
            this.forAll = true;
            this.constraints.put(column, content);
        } else if (fieldType == FieldType.NORMAL_FIELD) {
            this.constraints.put(column, content);
        } else if (fieldType == FieldType.SINGLE_FIELD) {
            this.constraints.put(column, content + " == \"" + "$param" + "\"");
        } else if (fieldType == FieldType.OPERATOR_FIELD) {
            this.constraints.put(column, content + " \"" + "$param" + "\"");
        }
        this.fieldTypes.put(column, fieldType);
    }

    @Override
    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    @Override
    public void addCellValue(int row, int column, String value) {
        this.addCellValue(row, column, value, true);
    }

    @Override
    public void addCellValue(int row, int column, String value, boolean trim) {
        this.hasValues = true;
        Integer key = new Integer(column);
        String content = this.constraints.get(key);
        if (content == null) {
            throw new DecisionTableParseException("No code snippet for CONDITION in cell " + RuleSheetParserUtil.rc2name(this.headerRow + 2, this.headerCol));
        }
        SnippetBuilder snip = new SnippetBuilder(content, trim);
        String result = snip.build(this.fixValue(column, value));
        this.values.add(result);
    }

    private String fixValue(int column, String value) {
        String _value = value;
        FieldType fieldType = this.fieldTypes.get(column);
        if (fieldType == FieldType.NORMAL_FIELD || !this.isMultipleConstraints() || this.isForAll()) {
            return value;
        }
        if (this.isDelimitedString(_value)) {
            _value = _value.substring(1, _value.length() - 1);
        }
        return _value;
    }

    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        if (!this.isMultipleConstraints()) {
            String nl = "";
            for (String content : this.values) {
                buf.append(nl).append(content);
                nl = "\n";
            }
            return buf.toString();
        }
        buf.append(this.colDefPrefix);
        String sep = "";
        for (String constraint : this.values) {
            buf.append(sep).append(constraint);
            sep = this.andop;
        }
        buf.append(this.colDefSuffix);
        return buf.toString();
    }

    boolean isMultipleConstraints() {
        return this.multiple;
    }

    boolean isForAll() {
        return this.forAll;
    }

    public FieldType calcFieldType(String content) {
        SnippetBuilder.SnippetType snippetType = SnippetBuilder.getType((String)content);
        if (snippetType.equals((Object)SnippetBuilder.SnippetType.FORALL)) {
            return FieldType.FORALL_FIELD;
        }
        if (!snippetType.equals((Object)SnippetBuilder.SnippetType.SINGLE)) {
            return FieldType.NORMAL_FIELD;
        }
        for (String op : operators) {
            if (!content.endsWith(op)) continue;
            return FieldType.OPERATOR_FIELD;
        }
        return FieldType.SINGLE_FIELD;
    }

    @Override
    public boolean hasValues() {
        return this.hasValues;
    }

    private boolean isDelimitedString(String content) {
        return this.isDelimitedString(content, '\"', '\"') || this.isDelimitedString(content, '\u201c', '\u201d') || this.isDelimitedString(content, '\u201c', '\u201c') || this.isDelimitedString(content, '\u201d', '\u201d');
    }

    private boolean isDelimitedString(String content, char openQuote, char closeQuote) {
        return content.indexOf(openQuote) == 0 && content.indexOf(closeQuote, 1) == content.length() - 1;
    }

    @Override
    public int getColumn() {
        return this.headerCol;
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
        operators.add("memberOf");
        operators.add("str[startsWith]");
        operators.add("str[endsWith]");
        operators.add("str[length]");
        annotations = new HashSet<String>();
        annotations.add("@watch");
        patParFrm = Pattern.compile("\\(\\s*\\)\\s*from\\b");
        patFrm = Pattern.compile("\\s+from\\s+");
        patPar = Pattern.compile("\\(\\s*\\)\\s*\\Z");
        patEval = Pattern.compile("\\beval\\s*(?:\\(\\s*\\)\\s*)?$");
        patOopath = Pattern.compile(".*\\:\\s*/.*");
    }

    static class FieldType {
        private String fieldType;
        public static final FieldType SINGLE_FIELD = new FieldType("single");
        public static final FieldType OPERATOR_FIELD = new FieldType("operator");
        public static final FieldType NORMAL_FIELD = new FieldType("normal");
        public static final FieldType FORALL_FIELD = new FieldType("forall");

        private FieldType(String fieldType) {
            this.fieldType = fieldType;
        }
    }
}

