/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.search;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.ext.metadata.search.DateRange;
import org.uberfire.ext.metadata.search.IOSearchService;
import org.uberfire.ext.metadata.search.SearchIndex;

public class InfinispanSearchIndex
implements SearchIndex {
    private final IndexProvider indexProvider;
    private final Analyzer analyzer;

    public InfinispanSearchIndex(IndexProvider indexProvider, Analyzer analyzer) {
        this.indexProvider = (IndexProvider)Preconditions.checkNotNull((Object)indexProvider, (Object)"indexProvider");
        this.analyzer = (Analyzer)Preconditions.checkNotNull((Object)analyzer, (Object)"analyzer");
    }

    public List<KObject> searchByAttrs(Map<String, ?> attrs, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return Collections.emptyList();
        }
        if (attrs == null || attrs.size() == 0) {
            return Collections.emptyList();
        }
        int totalNumHitsEstimate = this.searchByAttrsHits(attrs, clusterSegments);
        return this.search(this.buildQuery(attrs, clusterSegments), totalNumHitsEstimate, filter, clusterSegments);
    }

    public List<KObject> fullTextSearch(String term, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return Collections.emptyList();
        }
        int totalNumHitsEstimate = this.fullTextSearchHits(term, clusterSegments);
        return this.search(this.buildQuery(term, clusterSegments), totalNumHitsEstimate, filter, clusterSegments);
    }

    public int searchByAttrsHits(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return 0;
        }
        if (attrs == null || attrs.size() == 0) {
            return 0;
        }
        return this.searchHits(this.buildQuery(attrs, clusterSegments), clusterSegments);
    }

    public int fullTextSearchHits(String term, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return 0;
        }
        return this.searchHits(this.buildQuery(term, clusterSegments), clusterSegments);
    }

    private int searchHits(Query query, ClusterSegment ... clusterSegments) {
        return Math.toIntExact(this.indexProvider.findHitsByQuery(this.getIndices(clusterSegments), query));
    }

    private List<String> getIndices(ClusterSegment[] clusterSegments) {
        return Arrays.asList(clusterSegments).stream().map(clusterSegment -> this.format(clusterSegment.getClusterId())).collect(Collectors.toList());
    }

    private List<KObject> search(Query query, int totalNumHitsEstimate, IOSearchService.Filter filter, ClusterSegment ... clusterSegments) {
        List hits = this.indexProvider.findByQuery(this.getIndices(clusterSegments), query, totalNumHitsEstimate);
        return hits.stream().filter(kObject -> filter.accept(kObject)).collect(Collectors.toList());
    }

    private Query buildQuery(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (Map.Entry<String, ?> entry : attrs.entrySet()) {
            if (entry.getValue() instanceof DateRange) {
                Long from = ((DateRange)entry.getValue()).after().getTime();
                Long to = ((DateRange)entry.getValue()).before().getTime();
                query.add((Query)LegacyNumericRangeQuery.newLongRange((String)entry.getKey(), (Long)from, (Long)to, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
                continue;
            }
            if (entry.getValue() instanceof String) {
                query.add((Query)new WildcardQuery(new Term(entry.getKey(), entry.getValue().toString())), BooleanClause.Occur.MUST);
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            query.add((Query)new TermQuery(new Term(entry.getKey(), (Boolean)entry.getValue() != false ? "0" : "1")), BooleanClause.Occur.MUST);
        }
        return this.composeQuery((Query)query.build(), clusterSegments);
    }

    private Query buildQuery(String term, ClusterSegment ... clusterSegments) {
        Query fullText;
        try {
            fullText = new QueryParser("fullText", this.analyzer).parse(term);
            if (fullText.toString().isEmpty()) {
                fullText = new WildcardQuery(new Term("fullText", this.format(term) + "*"));
            }
        }
        catch (ParseException ex) {
            fullText = new WildcardQuery(new Term("fullText", this.format(term) + "*"));
        }
        return this.composeQuery(fullText, clusterSegments);
    }

    private Query composeQuery(Query query, ClusterSegment ... clusterSegments) {
        if (clusterSegments == null || clusterSegments.length == 0) {
            return query;
        }
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        BooleanClause.Occur occur = clusterSegments.length == 1 ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        for (ClusterSegment clusterSegment : clusterSegments) {
            BooleanQuery.Builder clusterSegmentQuery = new BooleanQuery.Builder();
            this.addClusterIdTerms(clusterSegmentQuery, clusterSegment);
            this.addSegmentIdTerms(clusterSegmentQuery, clusterSegment);
            booleanQuery.add((Query)clusterSegmentQuery.build(), occur);
        }
        return booleanQuery.build();
    }

    private void addClusterIdTerms(BooleanQuery.Builder query, ClusterSegment clusterSegment) {
        if (clusterSegment.getClusterId() != null) {
            TermQuery cluster = new TermQuery(new Term("cluster.id", clusterSegment.getClusterId()));
            query.add((Query)cluster, BooleanClause.Occur.MUST);
        }
    }

    private void addSegmentIdTerms(BooleanQuery.Builder query, ClusterSegment clusterSegment) {
        if (clusterSegment.segmentIds() == null || clusterSegment.segmentIds().length == 0) {
            return;
        }
        if (clusterSegment.segmentIds().length == 1) {
            TermQuery segment = new TermQuery(new Term("segment.id", clusterSegment.segmentIds()[0]));
            query.add((Query)segment, BooleanClause.Occur.MUST);
        } else {
            BooleanQuery.Builder segments = new BooleanQuery.Builder();
            for (String segmentId : clusterSegment.segmentIds()) {
                TermQuery segment = new TermQuery(new Term("segment.id", segmentId));
                segments.add((Query)segment, BooleanClause.Occur.SHOULD);
            }
            query.add((Query)segments.build(), BooleanClause.Occur.MUST);
        }
    }

    private String format(String term) {
        return AttributesUtil.toProtobufFormat(term.toLowerCase());
    }
}

