/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedDocValuesWriter
extends DocValuesWriter {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    PackedLongValues finalOrds;
    int[] finalSortedValues;
    int[] finalOrdMap;
    private static final int EMPTY_ORD = -1;

    public SortedDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(iwBytesUsed)), 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if ((long)docID < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (value == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + 32766);
        }
        while (this.pending.size() < (long)docID) {
            this.pending.add(-1L);
        }
        this.addOneValue(value);
    }

    @Override
    public void finish(int maxDoc) {
        while (this.pending.size() < (long)maxDoc) {
            this.pending.add(-1L);
        }
        this.updateBytesUsed();
        assert (this.pending.size() == (long)maxDoc);
        int valueCount = this.hash.size();
        if (this.finalOrds == null) {
            this.finalOrds = this.pending.build();
            this.finalSortedValues = this.hash.sort();
            this.finalOrdMap = new int[valueCount];
            for (int ord = 0; ord < valueCount; ++ord) {
                this.finalOrdMap[this.finalSortedValues[ord]] = ord;
            }
        }
    }

    private void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        this.pending.add(termID);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void flush(SegmentWriteState state, final Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.maxDoc();
        final int valueCount = this.hash.size();
        dvConsumer.addSortedField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new ValuesIterator(SortedDocValuesWriter.this.finalSortedValues, valueCount, SortedDocValuesWriter.this.hash);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new OrdsIterator(SortedDocValuesWriter.this.finalOrdMap, maxDoc, SortedDocValuesWriter.this.finalOrds);
                }
                return new SortingOrdsIterator(SortedDocValuesWriter.this.finalOrdMap, maxDoc, SortedDocValuesWriter.this.finalOrds, sortMap);
            }
        });
    }

    @Override
    Sorter.DocComparator getDocComparator(int numDoc, SortField sortField) throws IOException {
        assert (sortField.getType() == SortField.Type.STRING);
        final int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        return new Sorter.DocComparator(){

            @Override
            public int compare(int docID1, int docID2) {
                int ord1 = (int)SortedDocValuesWriter.this.finalOrds.get(docID1);
                ord1 = ord1 == -1 ? missingOrd : SortedDocValuesWriter.this.finalOrdMap[ord1];
                int ord2 = (int)SortedDocValuesWriter.this.finalOrds.get(docID2);
                ord2 = ord2 == -1 ? missingOrd : SortedDocValuesWriter.this.finalOrdMap[ord2];
                return reverseMul * Integer.compare(ord1, ord2);
            }
        };
    }

    private static class SortingOrdsIterator
    implements Iterator<Number> {
        final PackedLongValues ords;
        final int[] ordMap;
        final Sorter.DocMap sortMap;
        final int maxDoc;
        int docUpto;

        SortingOrdsIterator(int[] ordMap, int maxDoc, PackedLongValues ords, Sorter.DocMap sortMap) {
            this.ordMap = ordMap;
            this.maxDoc = maxDoc;
            assert (ords.size() == (long)maxDoc);
            this.ords = ords;
            this.sortMap = sortMap;
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int oldUpto = this.sortMap.newToOld(this.docUpto);
            int ord = (int)this.ords.get(oldUpto);
            ++this.docUpto;
            return ord == -1 ? ord : this.ordMap[ord];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrdsIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final int[] ordMap;
        final int maxDoc;
        int docUpto;

        OrdsIterator(int[] ordMap, int maxDoc, PackedLongValues ords) {
            this.ordMap = ordMap;
            this.maxDoc = maxDoc;
            assert (ords.size() == (long)maxDoc);
            this.iter = ords.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int ord = (int)this.iter.next();
            ++this.docUpto;
            return ord == -1 ? ord : this.ordMap[ord];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<BytesRef> {
        final int[] sortedValues;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int valueCount;
        int ordUpto;

        ValuesIterator(int[] sortedValues, int valueCount, BytesRefHash hash) {
            this.sortedValues = sortedValues;
            this.valueCount = valueCount;
            this.hash = hash;
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.valueCount;
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hash.get(this.sortedValues[this.ordUpto], this.scratch);
            ++this.ordUpto;
            return this.scratch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

