/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.Scope;
import org.hibernate.validator.engine.groups.Group;
import org.hibernate.validator.engine.groups.GroupChain;
import org.hibernate.validator.engine.groups.GroupChainGenerator;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintOrigin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescriptorImpl
implements ElementDescriptor {
    protected final BeanMetaData<?> metaDataBean;
    private final Class<?> type;
    private final Set<ConstraintDescriptorImpl<?>> constraintDescriptors = new HashSet();

    public ElementDescriptorImpl(Class<?> type, BeanMetaData<?> metaDataBean) {
        this.metaDataBean = metaDataBean;
        this.type = type;
    }

    public void addConstraintDescriptor(ConstraintDescriptorImpl constraintDescriptor) {
        this.constraintDescriptors.add(constraintDescriptor);
    }

    public boolean hasConstraints() {
        return this.constraintDescriptors.size() != 0;
    }

    public Class<?> getElementClass() {
        return this.type;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.findConstraints().getConstraintDescriptors();
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return new ConstraintFinderImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintFinderImpl
    implements ElementDescriptor.ConstraintFinder {
        private List<Class<?>> groups;
        private Set<ConstraintOrigin> definedInSet;
        private Set<ElementType> elementTypes = new HashSet<ElementType>();

        ConstraintFinderImpl() {
            this.elementTypes.add(ElementType.TYPE);
            this.elementTypes.add(ElementType.METHOD);
            this.elementTypes.add(ElementType.FIELD);
            this.definedInSet = new HashSet<ConstraintOrigin>();
            this.definedInSet.add(ConstraintOrigin.DEFINED_LOCALLY);
            this.definedInSet.add(ConstraintOrigin.DEFINED_IN_HIERARCHY);
            this.groups = Collections.emptyList();
        }

        public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... classes) {
            this.groups = new ArrayList();
            for (Class<?> clazz : classes) {
                if (Default.class.equals(clazz) && ElementDescriptorImpl.this.metaDataBean.defaultGroupSequenceIsRedefined()) {
                    this.groups.addAll(ElementDescriptorImpl.this.metaDataBean.getDefaultGroupSequence());
                    continue;
                }
                this.groups.add(clazz);
            }
            return this;
        }

        public ElementDescriptor.ConstraintFinder lookingAt(Scope visibility) {
            if (visibility.equals((Object)Scope.LOCAL_ELEMENT)) {
                this.definedInSet.remove((Object)ConstraintOrigin.DEFINED_IN_HIERARCHY);
            }
            return this;
        }

        public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... elementTypes) {
            this.elementTypes.clear();
            this.elementTypes.addAll(Arrays.asList(elementTypes));
            return this;
        }

        public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
            HashSet matchingDescriptors = new HashSet();
            this.findMatchingDescriptors(matchingDescriptors);
            return Collections.unmodifiableSet(matchingDescriptors);
        }

        private void findMatchingDescriptors(Set<ConstraintDescriptor<?>> matchingDescriptors) {
            if (!this.groups.isEmpty()) {
                GroupChain groupChain = new GroupChainGenerator().getGroupChainFor(this.groups);
                Iterator<Group> groupIterator = groupChain.getGroupIterator();
                while (groupIterator.hasNext()) {
                    Group g = groupIterator.next();
                    this.addMatchingDescriptorsForGroup(g.getGroup(), matchingDescriptors);
                }
            } else {
                for (ConstraintDescriptorImpl descriptor : ElementDescriptorImpl.this.constraintDescriptors) {
                    if (!this.definedInSet.contains((Object)descriptor.getDefinedOn()) || !this.elementTypes.contains((Object)descriptor.getElementType())) continue;
                    matchingDescriptors.add(descriptor);
                }
            }
        }

        public boolean hasConstraints() {
            return this.getConstraintDescriptors().size() != 0;
        }

        private void addMatchingDescriptorsForGroup(Class<?> group, Set<ConstraintDescriptor<?>> matchingDescriptors) {
            for (ConstraintDescriptorImpl descriptor : ElementDescriptorImpl.this.constraintDescriptors) {
                if (!this.definedInSet.contains((Object)descriptor.getDefinedOn()) || !this.elementTypes.contains((Object)descriptor.getElementType()) || !descriptor.getGroups().contains(group)) continue;
                matchingDescriptors.add(descriptor);
            }
        }
    }
}

