/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.client.handlers;

import java.util.concurrent.CountDownLatch;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.websocket.client.handlers.CommandScriptMessageHandler;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.services.api.KieServerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerSetupMessageHandler
implements InternalMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(KieServerSetupMessageHandler.class);
    private KieServerRegistry context;
    private CountDownLatch waitLatch;
    private KieServerSetup kieServerSetup;

    public KieServerSetupMessageHandler(KieServerRegistry context, CountDownLatch waitLatch, KieServerSetup kieServerSetup) {
        this.context = context;
        this.waitLatch = waitLatch;
        this.kieServerSetup = kieServerSetup;
    }

    public String onMessage(String message) {
        try {
            logger.debug("Received message with setup information {}", (Object)message);
            KieServerSetup setup = (KieServerSetup)this.deserialize(message, KieServerSetup.class);
            this.kieServerSetup.setContainers(setup.getContainers());
            this.kieServerSetup.setServerConfig(setup.getServerConfig());
            this.kieServerSetup.setMessages(setup.getMessages());
        }
        finally {
            this.waitLatch.countDown();
        }
        return null;
    }

    public InternalMessageHandler getNextHandler() {
        return new CommandScriptMessageHandler(this.context);
    }
}

