/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseDefinitionNotFoundException;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.commands.GetUserTaskCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.jbpm.locator.ByTaskIdContainerLocator;
import org.kie.server.services.jbpm.ui.form.render.FormReader;
import org.kie.server.services.jbpm.ui.form.render.FormRenderer;
import org.kie.server.services.jbpm.ui.form.render.model.FormField;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;
import org.kie.server.services.jbpm.ui.form.render.model.FormLayout;
import org.kie.server.services.jbpm.ui.form.render.model.FormModel;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutColumn;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutItem;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutRow;

public class FormRendererBase {
    private static final String SUPPORTED_FORM_SUFFIX = "-taskform.frm";
    private static final String ENDPOINT = "/files";
    private static final ServiceLoader<FormRenderer> formRenderers = ServiceLoader.load(FormRenderer.class);
    private DefinitionService definitionService;
    private FormManagerService formManagerService;
    private UserTaskService userTaskService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private KieServerRegistry registry;
    private Map<String, FormRenderer> renderers = new HashMap<String, FormRenderer>();
    private FormReader formReader = new FormReader();
    private Map<String, Map<String, String>> indexedForms = new ConcurrentHashMap<String, Map<String, String>>();

    public FormRendererBase(DefinitionService definitionService, UserTaskService userTaskService, FormManagerService formManagerService, CaseRuntimeDataService caseRuntimeDataService, KieServerRegistry registry) {
        this.definitionService = definitionService;
        this.userTaskService = userTaskService;
        this.formManagerService = formManagerService;
        this.caseRuntimeDataService = caseRuntimeDataService;
        this.registry = registry;
        for (FormRenderer renderer : formRenderers) {
            renderer.configure(System.getProperty("org.kie.server.location"), ENDPOINT);
            this.renderers.put(renderer.getName(), renderer);
        }
    }

    public void indexDeploymentForms(String containerId) {
        List supportedFormsOnly;
        Map forms = this.formManagerService.getAllFormsByDeployment(containerId);
        if (forms != null && !(supportedFormsOnly = forms.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(".frm")).map(entry -> (String)entry.getValue()).collect(Collectors.toList())).isEmpty()) {
            HashMap<String, String> formsByDeployment = new HashMap<String, String>();
            this.indexedForms.put(containerId, formsByDeployment);
            for (String formContent : supportedFormsOnly) {
                String formId = this.formReader.readFromString(formContent).getId();
                formsByDeployment.put(formId, formContent);
            }
        }
    }

    public void dropDeploymentForms(String containerId) {
        this.indexedForms.remove(containerId);
    }

    public String getProcessRenderedForm(String renderer, String containerId, String processId) {
        String resolvedContainerId = this.registry.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        ProcessDefinition processDesc = this.definitionService.getProcessDefinition(resolvedContainerId, processId);
        if (processDesc == null) {
            throw new ProcessDefinitionNotFoundException("Process definition " + resolvedContainerId + " : " + processId + " not found");
        }
        String formStructure = this.formManagerService.getFormByKey(resolvedContainerId, processId + SUPPORTED_FORM_SUFFIX);
        FormInstance form = this.formReader.readFromString(formStructure);
        if (form == null) {
            form = this.generateDefaultProcessForm(processDesc);
        }
        form.setNestedFormsLookup(formId -> {
            Map<String, String> forms = this.indexedForms.get(resolvedContainerId);
            String formStructureNested = forms.get(formId);
            return this.formReader.readFromString(formStructureNested);
        });
        FormRenderer formRenderer = this.renderers.get(renderer);
        if (formRenderer == null) {
            throw new IllegalArgumentException("Form renderer with name " + renderer + " not found");
        }
        String output = formRenderer.renderProcess(resolvedContainerId, processDesc, form);
        return output;
    }

    public String getTaskRenderedForm(String renderer, String containerId, long taskId) {
        String resolvedContainerId = this.registry.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(Long.valueOf(taskId)));
        Task task = (Task)this.userTaskService.execute(resolvedContainerId, (Command)new GetUserTaskCommand(this.registry.getIdentityProvider().getName(), taskId));
        if (task == null) {
            throw new TaskNotFoundException("No task with id " + taskId + " found");
        }
        String name = this.getTaskFormName(task);
        String formStructure = this.formManagerService.getFormByKey(resolvedContainerId, name);
        FormInstance form = this.formReader.readFromString(formStructure);
        if (form == null) {
            Map inputs = this.definitionService.getTaskInputMappings(resolvedContainerId, task.getTaskData().getProcessId(), task.getName());
            Map outputs = this.definitionService.getTaskOutputMappings(resolvedContainerId, task.getTaskData().getProcessId(), task.getName());
            form = this.generateDefaultTaskForm(task, inputs, outputs);
        }
        form.setNestedFormsLookup(formId -> {
            Map<String, String> forms = this.indexedForms.get(resolvedContainerId);
            String formStructureNested = forms.get(formId);
            return this.formReader.readFromString(formStructureNested);
        });
        Map inputData = this.userTaskService.getTaskInputContentByTaskId(resolvedContainerId, Long.valueOf(taskId));
        Map outputData = this.userTaskService.getTaskOutputContentByTaskId(resolvedContainerId, Long.valueOf(taskId));
        FormRenderer formRenderer = this.renderers.get(renderer);
        if (formRenderer == null) {
            throw new IllegalArgumentException("Form renderer with name " + renderer + " not found");
        }
        String output = formRenderer.renderTask(resolvedContainerId, task, form, inputData, outputData);
        return output;
    }

    public String getCaseRenderedForm(String renderer, String containerId, String caseDefinitionId) {
        FormRenderer formRenderer;
        if (this.caseRuntimeDataService == null) {
            throw new RuntimeException("Case capability in jBPM UI are not enabled");
        }
        String resolvedContainerId = this.registry.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        CaseDefinition caseDefinition = this.caseRuntimeDataService.getCase(resolvedContainerId, caseDefinitionId);
        if (caseDefinition == null) {
            throw new CaseDefinitionNotFoundException("Case definition " + resolvedContainerId + " : " + caseDefinitionId + " not found");
        }
        String formStructure = this.formManagerService.getFormByKey(resolvedContainerId, caseDefinitionId + SUPPORTED_FORM_SUFFIX);
        FormInstance form = this.formReader.readFromString(formStructure);
        if (form != null) {
            form.setNestedFormsLookup(formId -> {
                Map<String, String> forms = this.indexedForms.get(resolvedContainerId);
                String formStructureNested = forms.get(formId);
                return this.formReader.readFromString(formStructureNested);
            });
        }
        if ((formRenderer = this.renderers.get(renderer)) == null) {
            throw new IllegalArgumentException("Form renderer with name " + renderer + " not found");
        }
        String output = formRenderer.renderCase(resolvedContainerId, caseDefinition, form);
        return output;
    }

    public InputStream readResources(String resourcePath) {
        return this.getClass().getResourceAsStream("/form-templates-providers" + resourcePath);
    }

    protected String getTaskFormName(Task task) {
        String formName = ((InternalTask)task).getFormName();
        if (formName != null && !formName.equals("")) {
            if (formName.endsWith(".frm")) {
                return formName;
            }
            return formName + SUPPORTED_FORM_SUFFIX;
        }
        if (task.getNames() != null && !task.getNames().isEmpty() && (formName = ((I18NText)task.getNames().get(0)).getText()) != null) {
            return formName.replace(" ", "") + SUPPORTED_FORM_SUFFIX;
        }
        return null;
    }

    protected FormInstance generateDefaultProcessForm(ProcessDefinition processDesc) {
        FormInstance form = new FormInstance();
        form.setId(UUID.randomUUID().toString());
        form.setName("Default form - " + processDesc.getName());
        form.setModel(new FormModel());
        form.setFields(new ArrayList<FormField>());
        FormLayout layout = new FormLayout();
        layout.setRows(new ArrayList<LayoutRow>());
        form.setLayout(layout);
        Map variables = processDesc.getProcessVariables();
        if (variables != null) {
            for (Map.Entry entry : variables.entrySet()) {
                FormField field = new FormField();
                field.setId(UUID.randomUUID().toString());
                field.setBinding((String)entry.getKey());
                field.setCode(((String)entry.getValue()).contains("Boolean") ? "CheckBox" : "TextBox");
                field.setLabel((String)entry.getKey());
                field.setName((String)entry.getKey());
                field.setType((String)entry.getValue());
                form.getFields().add(field);
                LayoutRow row = new LayoutRow();
                layout.getRows().add(row);
                row.setColumns(new ArrayList<LayoutColumn>());
                LayoutColumn column = new LayoutColumn();
                column.setSpan("12");
                column.setItems(new ArrayList<LayoutItem>());
                row.getColumns().add(column);
                LayoutItem item = new LayoutItem();
                item.setFieldId(field.getId());
                item.setFormId(form.getId());
                column.getItems().add(item);
            }
        }
        return form;
    }

    protected FormInstance generateDefaultTaskForm(Task task, Map<String, String> inputs, Map<String, String> outputs) {
        LayoutItem item;
        LayoutColumn column;
        LayoutRow row;
        FormField field;
        FormInstance form = new FormInstance();
        form.setId(UUID.randomUUID().toString());
        form.setName("Default form - " + task.getName());
        form.setModel(new FormModel());
        form.setFields(new ArrayList<FormField>());
        FormLayout layout = new FormLayout();
        layout.setRows(new ArrayList<LayoutRow>());
        form.setLayout(layout);
        if (inputs != null) {
            for (Map.Entry<String, String> entry : inputs.entrySet()) {
                field = new FormField();
                field.setId(UUID.randomUUID().toString());
                field.setBinding(entry.getKey());
                field.setCode(entry.getValue().contains("Boolean") ? "CheckBox" : "TextBox");
                field.setLabel(entry.getKey());
                field.setName(entry.getKey());
                field.setType(entry.getValue());
                field.setReadOnly(true);
                form.getFields().add(field);
                row = new LayoutRow();
                layout.getRows().add(row);
                row.setColumns(new ArrayList<LayoutColumn>());
                column = new LayoutColumn();
                column.setSpan("12");
                column.setItems(new ArrayList<LayoutItem>());
                row.getColumns().add(column);
                item = new LayoutItem();
                item.setFieldId(field.getId());
                item.setFormId(form.getId());
                column.getItems().add(item);
            }
        }
        if (outputs != null) {
            for (Map.Entry<String, String> entry : outputs.entrySet()) {
                field = new FormField();
                field.setId(UUID.randomUUID().toString());
                field.setBinding(entry.getKey());
                field.setCode(entry.getValue().contains("Boolean") ? "CheckBox" : "TextBox");
                field.setLabel(entry.getKey());
                field.setName(entry.getKey());
                field.setType(entry.getValue());
                form.getFields().add(field);
                row = new LayoutRow();
                layout.getRows().add(row);
                row.setColumns(new ArrayList<LayoutColumn>());
                column = new LayoutColumn();
                column.setSpan("12");
                column.setItems(new ArrayList<LayoutItem>());
                row.getColumns().add(column);
                item = new LayoutItem();
                item.setFieldId(field.getId());
                item.setFormId(form.getId());
                column.getItems().add(item);
            }
        }
        return form;
    }
}

