/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(RuleSetNodeInstance.class);
    private static final String ACT_AS_WAIT_STATE_PROPERTY = "org.jbpm.rule.task.waitstate";
    private static final String FIRE_RULE_LIMIT_PROPERTY = "org.jbpm.rule.task.firelimit";
    private static final String FIRE_RULE_LIMIT_PARAMETER = "FireRuleLimit";
    private static final int DEFAULT_FIRE_RULE_LIMIT = Integer.parseInt(System.getProperty("org.jbpm.rule.task.firelimit", "10000"));
    private Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private String ruleFlowGroup;
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();

    protected RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        try {
            super.internalTrigger(from, type);
            if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
                return;
            }
            if (!"DROOLS_DEFAULT".equals(type)) {
                throw new IllegalArgumentException("A RuleSetNode only accepts default incoming connections!");
            }
            RuleSetNode ruleSetNode = this.getRuleSetNode();
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            Map<String, Object> inputs = this.evaluateParameters(ruleSetNode);
            if (ruleSetNode.isDMN()) {
                String namespace = this.resolveVariable(ruleSetNode.getNamespace());
                String model = this.resolveVariable(ruleSetNode.getModel());
                String decision = this.resolveVariable(ruleSetNode.getDecision());
                String decisionService = this.resolveVariable(ruleSetNode.getDecisionService());
                DMNRuntime runtime = (DMNRuntime)((KieSession)kruntime).getKieRuntime(DMNRuntime.class);
                DMNModel dmnModel = runtime.getModel(namespace, model);
                if (dmnModel == null) {
                    dmnModel = runtime.getModelById(namespace, model);
                }
                if (dmnModel == null) {
                    throw new IllegalArgumentException("DMN model '" + model + "' not found with namespace '" + namespace + "'");
                }
                DMNResult dmnResult = null;
                DMNContext context = runtime.newContext();
                for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                    context.set(entry.getKey(), entry.getValue());
                }
                dmnResult = decision != null && !decision.isEmpty() ? runtime.evaluateByName(dmnModel, context, new String[]{decision}) : (decisionService != null && !decisionService.isEmpty() ? runtime.evaluateDecisionService(dmnModel, context, decisionService) : runtime.evaluateAll(dmnModel, context));
                if (dmnResult.hasErrors()) {
                    String errors = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().map(Object::toString).collect(Collectors.joining(", "));
                    throw new RuntimeException("DMN result errors:: " + errors);
                }
                this.processOutputs(dmnResult.getContext().getAll());
                this.triggerCompleted();
            } else {
                this.setRuleFlowGroup(this.resolveRuleFlowGroup(ruleSetNode.getRuleFlowGroup()));
                for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                    if (FIRE_RULE_LIMIT_PARAMETER.equals(entry.getKey())) continue;
                    String inputKey = this.getRuleFlowGroup() + "_" + this.getProcessInstance().getId() + "_" + entry.getKey();
                    this.factHandles.put(inputKey, kruntime.insert(entry.getValue()));
                }
                if (this.actAsWaitState()) {
                    this.addRuleSetListener();
                    ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).activateRuleFlowGroup(this.getRuleFlowGroup(), this.getProcessInstance().getId(), this.getUniqueId());
                } else {
                    int fireLimit = DEFAULT_FIRE_RULE_LIMIT;
                    if (inputs.containsKey(FIRE_RULE_LIMIT_PARAMETER)) {
                        fireLimit = Integer.parseInt(inputs.get(FIRE_RULE_LIMIT_PARAMETER).toString());
                    }
                    ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).activateRuleFlowGroup(this.getRuleFlowGroup(), this.getProcessInstance().getId(), this.getUniqueId());
                    int fired = ((KieSession)this.getProcessInstance().getKnowledgeRuntime()).fireAllRules(fireLimit);
                    if (fired == fireLimit) {
                        throw new RuntimeException("Fire rule limit reached " + fireLimit + ", limit can be set via system property " + FIRE_RULE_LIMIT_PROPERTY + " or via data input of business rule task named " + FIRE_RULE_LIMIT_PARAMETER);
                    }
                    this.removeEventListeners();
                    this.retractFacts();
                    this.triggerCompleted();
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable e) {
        ExceptionScopeInstance exceptionScopeInstance = this.getExceptionScopeInstance(e);
        if (exceptionScopeInstance == null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null && (exceptionScopeInstance = this.getExceptionScopeInstance(rootCause)) != null) {
                exceptionScopeInstance.handleException(rootCause.getClass().getName(), rootCause);
                return;
            }
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
        }
        exceptionScopeInstance.handleException(e.getClass().getName(), e);
    }

    private ExceptionScopeInstance getExceptionScopeInstance(Throwable e) {
        return (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", e.getClass().getName());
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addRuleSetListener();
    }

    private String getRuleSetEventType() {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime instanceof StatefulKnowledgeSession) {
            return "RuleFlowGroup_" + this.getRuleFlowGroup() + "_" + ((StatefulKnowledgeSession)kruntime).getIdentifier();
        }
        return "RuleFlowGroup_" + this.getRuleFlowGroup();
    }

    private void addRuleSetListener() {
        this.getProcessInstance().addEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void cancel(NodeInstance.CancelType cancelType) {
        super.cancel(cancelType);
        if (this.actAsWaitState()) {
            ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).deactivateRuleFlowGroup(this.getRuleFlowGroup());
        }
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (this.getRuleSetEventType().equals(type)) {
            this.removeEventListeners();
            this.retractFacts();
            this.triggerCompleted();
        }
    }

    public void retractFacts() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        for (Map.Entry<String, FactHandle> entry : this.factHandles.entrySet()) {
            Object object = kruntime.getObject(entry.getValue());
            String key = entry.getKey();
            key = key.replaceAll(this.getRuleFlowGroup() + "_", "");
            key = key.replaceAll(this.getProcessInstance().getId() + "_", "");
            objects.put(key, object);
            kruntime.delete(entry.getValue());
        }
        this.processOutputs(objects);
        this.factHandles.clear();
    }

    protected void processOutputs(Map<String, Object> objects) {
        RuleSetNode ruleSetNode = this.getRuleSetNode();
        if (ruleSetNode != null) {
            for (DataAssociation association : ruleSetNode.getOutAssociations()) {
                if (association.getTransformation() != null) {
                    Transformation transformation = association.getTransformation();
                    DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                    if (transformer == null) continue;
                    Object parameterValue = transformer.transform(transformation.getCompiledExpression(), objects);
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                    if (variableScopeInstance != null && parameterValue != null) {
                        variableScopeInstance.setVariable(association.getTarget(), parameterValue);
                        continue;
                    }
                    logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                    logger.warn("Continuing without setting variable.");
                    continue;
                }
                if (association.getAssignments() != null && !association.getAssignments().isEmpty()) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null) {
                    Variable varDef;
                    DataType dataType;
                    Object value = objects.get(association.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new MapVariableResolverFactory(objects));
                        }
                        catch (Throwable parameterValue) {
                            // empty catch block
                        }
                    }
                    if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && value instanceof String) {
                        value = dataType.readValue((String)value);
                    }
                    variableScopeInstance.setVariable(association.getTarget(), value);
                    continue;
                }
                logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
            }
        }
    }

    protected Map<String, Object> evaluateParameters(RuleSetNode ruleSetNode) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        for (DataAssociation association : ruleSetNode.getInAssociations()) {
            if (association.getTransformation() != null) {
                Object parameterValue;
                Transformation transformation = association.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null || (parameterValue = transformer.transform(transformation.getCompiledExpression(), this.getSourceParameters(association))) == null && !ruleSetNode.isDMN()) continue;
                replacements.put(association.getTarget(), parameterValue);
                continue;
            }
            if (association.getAssignments() != null && !association.getAssignments().isEmpty()) continue;
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getSources().get(0));
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(association.getSources().get(0));
            } else {
                try {
                    parameterValue = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)association.getSources().get(0));
                    logger.error("when trying to execute RuleSetNode {}", (Object)ruleSetNode.getName());
                    logger.error("Continuing without setting parameter.");
                }
            }
            if (parameterValue == null && !ruleSetNode.isDMN()) continue;
            replacements.put(association.getTarget(), parameterValue);
        }
        for (Map.Entry<String, Object> entry : ruleSetNode.getParameters().entrySet()) {
            Object value;
            if (!(entry.getValue() instanceof String) || (value = this.resolveVariable(entry.getValue())) == null) continue;
            replacements.put(entry.getKey(), value);
        }
        return replacements;
    }

    private Object resolveVariable(Object s) {
        if (s instanceof String) {
            Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher((String)s);
            while (matcher.find()) {
                Object variableValue;
                String paramName = matcher.group(1);
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    if (variableValue == null) continue;
                    return variableValue;
                }
                try {
                    variableValue = MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    if (variableValue == null) continue;
                    return variableValue;
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                }
            }
        }
        return s;
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELSafeHelper.getEvaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }

    private String resolveRuleFlowGroup(String origin) {
        return this.resolveVariable(origin);
    }

    public Map<String, FactHandle> getFactHandles() {
        return this.factHandles;
    }

    public void setFactHandles(Map<String, FactHandle> factHandles) {
        this.factHandles = factHandles;
    }

    public String getRuleFlowGroup() {
        if (this.ruleFlowGroup == null || this.ruleFlowGroup.trim().length() == 0) {
            this.ruleFlowGroup = this.getRuleSetNode().getRuleFlowGroup();
        }
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    protected boolean actAsWaitState() {
        Object asWaitState = this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get(ACT_AS_WAIT_STATE_PROPERTY);
        if (asWaitState != null) {
            return Boolean.parseBoolean(asWaitState.toString());
        }
        return false;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List list = this.subContextInstances.computeIfAbsent(contextId, key -> new ArrayList());
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getRuleSetNode();
    }
}

