/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.selector.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.SimpleStrategyRegistrationImpl;
import org.hibernate.boot.registry.selector.StrategyRegistration;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.internal.SimpleCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.dialect.CUBRIDDialect;
import org.hibernate.dialect.Cache71Dialect;
import org.hibernate.dialect.DB2390Dialect;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyTenFiveDialect;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.DerbyTenSixDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FirebirdDialect;
import org.hibernate.dialect.FrontBaseDialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.Ingres10Dialect;
import org.hibernate.dialect.Ingres9Dialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.InterbaseDialect;
import org.hibernate.dialect.JDataStoreDialect;
import org.hibernate.dialect.MckoiDialect;
import org.hibernate.dialect.MimerSQLDialect;
import org.hibernate.dialect.MySQL57InnoDBDialect;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.PointbaseDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.PostgresPlusDialect;
import org.hibernate.dialect.ProgressDialect;
import org.hibernate.dialect.SAPDBDialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseASE157Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.dialect.TeradataDialect;
import org.hibernate.dialect.TimesTenDialect;
import org.hibernate.engine.transaction.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.BorlandEnterpriseServerJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossAppServerJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JRun4JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.OC4JJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.OrionJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.ResinJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.SunOneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereExtendedJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WeblogicJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.internal.EntityCopyAllowedLoggedObserver;
import org.hibernate.event.internal.EntityCopyAllowedObserver;
import org.hibernate.event.internal.EntityCopyNotAllowedObserver;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.global.GlobalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.persistent.PersistentTableBulkIdStrategy;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.jboss.logging.Logger;

public class StrategySelectorBuilder {
    private static final Logger log = Logger.getLogger(StrategySelectorBuilder.class);
    private final List<StrategyRegistration> explicitStrategyRegistrations = new ArrayList<StrategyRegistration>();

    public <T> void addExplicitStrategyRegistration(Class<T> strategy, Class<? extends T> implementation, String name) {
        this.addExplicitStrategyRegistration(new SimpleStrategyRegistrationImpl<T>(strategy, implementation, name));
    }

    public <T> void addExplicitStrategyRegistration(StrategyRegistration<T> strategyRegistration) {
        if (!strategyRegistration.getStrategyRole().isInterface()) {
            log.debug((Object)("Registering non-interface strategy : " + strategyRegistration.getStrategyRole().getName()));
        }
        if (!strategyRegistration.getStrategyRole().isAssignableFrom(strategyRegistration.getStrategyImplementation())) {
            throw new StrategySelectionException("Implementation class [" + strategyRegistration.getStrategyImplementation().getName() + "] does not implement strategy interface [" + strategyRegistration.getStrategyRole().getName() + "]");
        }
        this.explicitStrategyRegistrations.add(strategyRegistration);
    }

    public StrategySelector buildSelector(ClassLoaderService classLoaderService) {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(classLoaderService);
        this.addDialects(strategySelector);
        this.addJtaPlatforms(strategySelector);
        this.addTransactionCoordinatorBuilders(strategySelector);
        this.addMultiTableBulkIdStrategies(strategySelector);
        this.addEntityCopyObserverStrategies(strategySelector);
        this.addImplicitNamingStrategies(strategySelector);
        this.addCacheKeysFactories(strategySelector);
        for (StrategyRegistrationProvider provider : classLoaderService.loadJavaServices(StrategyRegistrationProvider.class)) {
            for (StrategyRegistration discoveredStrategyRegistration : provider.getStrategyRegistrations()) {
                this.applyFromStrategyRegistration(strategySelector, discoveredStrategyRegistration);
            }
        }
        for (StrategyRegistration explicitStrategyRegistration : this.explicitStrategyRegistrations) {
            this.applyFromStrategyRegistration(strategySelector, explicitStrategyRegistration);
        }
        return strategySelector;
    }

    private <T> void applyFromStrategyRegistration(StrategySelectorImpl strategySelector, StrategyRegistration<T> strategyRegistration) {
        for (String name : strategyRegistration.getSelectorNames()) {
            strategySelector.registerStrategyImplementor(strategyRegistration.getStrategyRole(), name, strategyRegistration.getStrategyImplementation());
        }
    }

    private void addDialects(StrategySelectorImpl strategySelector) {
        this.addDialect(strategySelector, Cache71Dialect.class);
        this.addDialect(strategySelector, CUBRIDDialect.class);
        this.addDialect(strategySelector, DB2Dialect.class);
        this.addDialect(strategySelector, DB2390Dialect.class);
        this.addDialect(strategySelector, DB2400Dialect.class);
        this.addDialect(strategySelector, DerbyTenFiveDialect.class);
        this.addDialect(strategySelector, DerbyTenSixDialect.class);
        this.addDialect(strategySelector, DerbyTenSevenDialect.class);
        this.addDialect(strategySelector, FirebirdDialect.class);
        this.addDialect(strategySelector, FrontBaseDialect.class);
        this.addDialect(strategySelector, H2Dialect.class);
        this.addDialect(strategySelector, HSQLDialect.class);
        this.addDialect(strategySelector, InformixDialect.class);
        this.addDialect(strategySelector, IngresDialect.class);
        this.addDialect(strategySelector, Ingres9Dialect.class);
        this.addDialect(strategySelector, Ingres10Dialect.class);
        this.addDialect(strategySelector, InterbaseDialect.class);
        this.addDialect(strategySelector, JDataStoreDialect.class);
        this.addDialect(strategySelector, MckoiDialect.class);
        this.addDialect(strategySelector, MimerSQLDialect.class);
        this.addDialect(strategySelector, MySQL5Dialect.class);
        this.addDialect(strategySelector, MySQL5InnoDBDialect.class);
        this.addDialect(strategySelector, MySQL57InnoDBDialect.class);
        this.addDialect(strategySelector, Oracle8iDialect.class);
        this.addDialect(strategySelector, Oracle9iDialect.class);
        this.addDialect(strategySelector, Oracle10gDialect.class);
        this.addDialect(strategySelector, PointbaseDialect.class);
        this.addDialect(strategySelector, PostgresPlusDialect.class);
        this.addDialect(strategySelector, PostgreSQL81Dialect.class);
        this.addDialect(strategySelector, PostgreSQL82Dialect.class);
        this.addDialect(strategySelector, PostgreSQL9Dialect.class);
        this.addDialect(strategySelector, ProgressDialect.class);
        this.addDialect(strategySelector, SAPDBDialect.class);
        this.addDialect(strategySelector, SQLServerDialect.class);
        this.addDialect(strategySelector, SQLServer2005Dialect.class);
        this.addDialect(strategySelector, SQLServer2008Dialect.class);
        this.addDialect(strategySelector, Sybase11Dialect.class);
        this.addDialect(strategySelector, SybaseAnywhereDialect.class);
        this.addDialect(strategySelector, SybaseASE15Dialect.class);
        this.addDialect(strategySelector, SybaseASE157Dialect.class);
        this.addDialect(strategySelector, TeradataDialect.class);
        this.addDialect(strategySelector, TimesTenDialect.class);
    }

    private void addDialect(StrategySelectorImpl strategySelector, Class<? extends Dialect> dialectClass) {
        String simpleName = dialectClass.getSimpleName();
        if (simpleName.endsWith("Dialect")) {
            simpleName = simpleName.substring(0, simpleName.length() - "Dialect".length());
        }
        strategySelector.registerStrategyImplementor(Dialect.class, simpleName, dialectClass);
    }

    private void addJtaPlatforms(StrategySelectorImpl strategySelector) {
        this.addJtaPlatforms(strategySelector, BorlandEnterpriseServerJtaPlatform.class, "Borland", "org.hibernate.service.jta.platform.internal.BorlandEnterpriseServerJtaPlatform");
        this.addJtaPlatforms(strategySelector, BitronixJtaPlatform.class, "Bitronix", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        this.addJtaPlatforms(strategySelector, JBossAppServerJtaPlatform.class, "JBossAS", "org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform");
        this.addJtaPlatforms(strategySelector, JBossStandAloneJtaPlatform.class, "JBossTS", "org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform");
        this.addJtaPlatforms(strategySelector, JOnASJtaPlatform.class, "JOnAS", "org.hibernate.service.jta.platform.internal.JOnASJtaPlatform");
        this.addJtaPlatforms(strategySelector, JOTMJtaPlatform.class, "JOTM", "org.hibernate.service.jta.platform.internal.JOTMJtaPlatform");
        this.addJtaPlatforms(strategySelector, JRun4JtaPlatform.class, "JRun4", "org.hibernate.service.jta.platform.internal.JRun4JtaPlatform");
        this.addJtaPlatforms(strategySelector, OC4JJtaPlatform.class, "OC4J", "org.hibernate.service.jta.platform.internal.OC4JJtaPlatform");
        this.addJtaPlatforms(strategySelector, OrionJtaPlatform.class, "Orion", "org.hibernate.service.jta.platform.internal.OrionJtaPlatform");
        this.addJtaPlatforms(strategySelector, ResinJtaPlatform.class, "Resin", "org.hibernate.service.jta.platform.internal.ResinJtaPlatform");
        this.addJtaPlatforms(strategySelector, SunOneJtaPlatform.class, "SunOne", "org.hibernate.service.jta.platform.internal.SunOneJtaPlatform");
        this.addJtaPlatforms(strategySelector, WeblogicJtaPlatform.class, "Weblogic", "org.hibernate.service.jta.platform.internal.WeblogicJtaPlatform");
        this.addJtaPlatforms(strategySelector, WebSphereJtaPlatform.class, "WebSphere", "org.hibernate.service.jta.platform.internal.WebSphereJtaPlatform");
        this.addJtaPlatforms(strategySelector, WebSphereExtendedJtaPlatform.class, "WebSphereExtended", "org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform");
    }

    private void addJtaPlatforms(StrategySelectorImpl strategySelector, Class<? extends JtaPlatform> impl, String ... names) {
        for (String name : names) {
            strategySelector.registerStrategyImplementor(JtaPlatform.class, name, impl);
        }
    }

    private void addTransactionCoordinatorBuilders(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jdbc", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "jta", JtaTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "org.hibernate.transaction.JDBCTransactionFactory", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "org.hibernate.transaction.JTATransactionFactory", JtaTransactionCoordinatorBuilderImpl.class);
        strategySelector.registerStrategyImplementor(TransactionCoordinatorBuilder.class, "org.hibernate.transaction.CMTTransactionFactory", JtaTransactionCoordinatorBuilderImpl.class);
    }

    private void addMultiTableBulkIdStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "persistent", PersistentTableBulkIdStrategy.class);
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "global_temporary", GlobalTemporaryTableBulkIdStrategy.class);
        strategySelector.registerStrategyImplementor(MultiTableBulkIdStrategy.class, "local_temporary", LocalTemporaryTableBulkIdStrategy.class);
    }

    private void addEntityCopyObserverStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(EntityCopyObserver.class, "disallow", EntityCopyNotAllowedObserver.class);
        strategySelector.registerStrategyImplementor(EntityCopyObserver.class, "allow", EntityCopyAllowedObserver.class);
        strategySelector.registerStrategyImplementor(EntityCopyObserver.class, "log", EntityCopyAllowedLoggedObserver.class);
    }

    private void addImplicitNamingStrategies(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "default", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "jpa", ImplicitNamingStrategyJpaCompliantImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "legacy-jpa", ImplicitNamingStrategyLegacyJpaImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "legacy-hbm", ImplicitNamingStrategyLegacyHbmImpl.class);
        strategySelector.registerStrategyImplementor(ImplicitNamingStrategy.class, "component-path", ImplicitNamingStrategyComponentPathImpl.class);
    }

    private void addCacheKeysFactories(StrategySelectorImpl strategySelector) {
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "default", DefaultCacheKeysFactory.class);
        strategySelector.registerStrategyImplementor(CacheKeysFactory.class, "simple", SimpleCacheKeysFactory.class);
    }
}

