/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JMSSendTaskDefinitions.wid", name="JMSSendTask", displayName="JMSSendTask", defaultHandler="mvel: new org.jbpm.process.workitem.jms.JMSSendTaskWorkItemHandler()", documentation="jbpm-workitems-jms/index.html", category="jbpm-workitems-jms", icon="JMSSendTask.png", parameters={@WidParameter(name="Signal"), @WidParameter(name="SignalProcessInstanceId"), @WidParameter(name="SignalWorkItemId"), @WidParameter(name="SignalDeploymentId"), @WidParameter(name="Data")}, mavenDepends={@WidMavenDepends(group="org.jbpm", artifact="jbpm-workitems-jms", version="7.45.0.Final")}, serviceInfo=@WidService(category="JMS", description="Send JSM messages", keywords="jsm,send,task", action=@WidAction(title="Send JMS Message"), authinfo=@WidAuth(required=true, params={"connectionFactoryName", "destinationName"}, paramsdescription={"Connection Factory JNDI Name", "Destination JNDI Name"})))
public class JMSSendTaskWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(JMSSendTaskWorkItemHandler.class);
    private String connectionFactoryName;
    private String destinationName;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private boolean transacted = false;

    public JMSSendTaskWorkItemHandler() {
        this.connectionFactoryName = "java:/JmsXA";
        this.destinationName = "queue/KIE.SIGNAL";
        this.init();
    }

    public JMSSendTaskWorkItemHandler(String connectionFactoryName, String destinationName) {
        this.connectionFactoryName = connectionFactoryName;
        this.destinationName = destinationName;
        this.init();
    }

    public JMSSendTaskWorkItemHandler(ConnectionFactory connectionFactory, Destination destination) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.init();
    }

    public JMSSendTaskWorkItemHandler(String connectionFactoryName, String destinationName, boolean transacted) {
        this.connectionFactoryName = connectionFactoryName;
        this.destinationName = destinationName;
        this.transacted = transacted;
        this.init();
    }

    public JMSSendTaskWorkItemHandler(ConnectionFactory connectionFactory, Destination destination, boolean transacted) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.transacted = transacted;
        this.init();
    }

    public JMSSendTaskWorkItemHandler(ConnectionFactory connectionFactory, Destination destination, boolean transacted, boolean doInit) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.transacted = transacted;
        if (doInit) {
            this.init();
        }
    }

    protected void init() {
        try {
            InitialContext ctx = new InitialContext();
            if (this.connectionFactory == null) {
                this.connectionFactory = (ConnectionFactory)ctx.lookup(this.connectionFactoryName);
            }
            if (this.destination == null) {
                this.destination = (Destination)ctx.lookup(this.destinationName);
            }
            logger.info("JMS based work item handler successfully activated on destination {}", (Object)this.destination);
        }
        catch (Exception e) {
            logger.error("Unable to initialize JMS send work item handler due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected Message createMessage(WorkItem workItem, Session session) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        this.addPropertyIfExists("KIE_Signal", workItem.getParameter("Signal"), (Message)message);
        this.addPropertyIfExists("KIE_SignalProcessInstanceId", workItem.getParameter("SignalProcessInstanceId"), (Message)message);
        this.addPropertyIfExists("KIE_SignalWorkItemId", workItem.getParameter("SignalWorkItemId"), (Message)message);
        this.addPropertyIfExists("KIE_SignalDeploymentId", workItem.getParameter("SignalDeploymentId"), (Message)message);
        this.addPropertyIfExists("KIE_ProcessInstanceId", workItem.getProcessInstanceId(), (Message)message);
        this.addPropertyIfExists("KIE_DeploymentId", ((WorkItemImpl)workItem).getDeploymentId(), (Message)message);
        Object data = workItem.getParameter("Data");
        if (data != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(data);
                message.writeBytes(bout.toByteArray());
            }
            catch (IOException e) {
                logger.warn("Error serializing context data", (Throwable)e);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (this.connectionFactory == null || this.destination == null) {
            throw new RuntimeException("Connection factory and destination must be set for JMS send task handler");
        }
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        try {
            connection = this.connectionFactory.createConnection();
            session = connection.createSession(this.transacted, 1);
            Message message = this.createMessage(workItem, session);
            producer = session.createProducer(this.destination);
            producer.send(message);
            manager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing producer", (Throwable)e);
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue session", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue connection", (Throwable)e);
                }
            }
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void close() {
        this.connectionFactory = null;
        this.destination = null;
    }

    protected void addPropertyIfExists(String propertyName, Object properyValue, Message msg) throws JMSException {
        if (properyValue != null) {
            msg.setObjectProperty(propertyName, properyValue);
        }
    }
}

