/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieSessionLookupHandler;

public class JBPMKieSessionLookupHandler
implements KieSessionLookupHandler {
    public CommandExecutor lookupKieSession(String kieSessionId, KieContainerInstance containerInstance, KieServerRegistry registry) {
        String managerId = kieSessionId;
        Long processInstanceId = null;
        if (kieSessionId.indexOf("#") != -1) {
            String[] managerAndInstanceIds = kieSessionId.split("#");
            managerId = managerAndInstanceIds[0];
            processInstanceId = Long.parseLong(managerAndInstanceIds[1]);
        }
        if (RuntimeManagerRegistry.get().isRegistered(managerId)) {
            RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(managerId);
            Context ctx = EmptyContext.get();
            if (processInstanceId != null) {
                ctx = ProcessInstanceIdContext.get((Long)processInstanceId);
            }
            RuntimeEngine engine = runtimeManager.getRuntimeEngine(ctx);
            return new RuntimeEngineDisposableCommandExecutor(runtimeManager, engine);
        }
        return null;
    }

    private class RuntimeEngineDisposableCommandExecutor
    implements CommandExecutor {
        private RuntimeManager runtimeManager;
        private RuntimeEngine engine;

        public RuntimeEngineDisposableCommandExecutor(RuntimeManager runtimeManager, RuntimeEngine engine) {
            this.runtimeManager = runtimeManager;
            this.engine = engine;
        }

        public <T> T execute(Command<T> command) {
            try {
                Object object = this.engine.getKieSession().execute(command);
                return (T)object;
            }
            finally {
                this.runtimeManager.disposeRuntimeEngine(this.engine);
            }
        }
    }
}

