/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.config.solver.recaller.BestSolutionRecallerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.io.XStreamConfigReader;
import org.optaplanner.core.impl.solver.random.DefaultRandomFactory;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="solver")
public class SolverConfig
extends AbstractConfig<SolverConfig> {
    public static final String MOVE_THREAD_COUNT_NONE = "NONE";
    public static final String MOVE_THREAD_COUNT_AUTO = "AUTO";
    protected static final long DEFAULT_RANDOM_SEED = 0L;
    private static final Logger logger = LoggerFactory.getLogger(SolverConfig.class);
    @XStreamOmitField
    private ClassLoader classLoader = null;
    protected EnvironmentMode environmentMode = null;
    protected Boolean daemon = null;
    protected RandomType randomType = null;
    protected Long randomSeed = null;
    protected Class<? extends RandomFactory> randomFactoryClass = null;
    protected String moveThreadCount = null;
    protected Integer moveThreadBufferSize = null;
    protected Class<? extends ThreadFactory> threadFactoryClass = null;
    @XStreamAlias(value="scanAnnotatedClasses")
    @Deprecated
    protected ScanAnnotatedClassesConfig scanAnnotatedClassesConfig = null;
    protected Class<?> solutionClass = null;
    @XStreamImplicit(itemFieldName="entityClass")
    protected List<Class<?>> entityClassList = null;
    @XStreamAlias(value="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig;
    @XStreamImplicit
    protected List<PhaseConfig> phaseConfigList = null;

    public static SolverConfig createFromXmlResource(String solverConfigResource) {
        return SolverConfig.createFromXmlResource(solverConfigResource, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SolverConfig createFromXmlResource(String solverConfigResource, ClassLoader classLoader) {
        ClassLoader actualClassLoader = classLoader != null ? classLoader : SolverConfig.class.getClassLoader();
        try (InputStream in = actualClassLoader.getResourceAsStream(solverConfigResource);){
            if (in == null) {
                String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                if (!solverConfigResource.startsWith("/")) throw new IllegalArgumentException(errorMessage);
                errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A solverConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the solverConfigResource.";
                throw new IllegalArgumentException(errorMessage);
            }
            SolverConfig solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
            return solverConfig;
        }
        catch (ConversionException e) {
            String string;
            String lineNumber = e.get("line number");
            StringBuilder stringBuilder = new StringBuilder().append("Unmarshalling of solverConfigResource (").append(solverConfigResource).append(") fails on line number (").append(lineNumber).append(").");
            if (Objects.equals(e.get("required-type"), "java.lang.Class")) {
                string = "\n  Maybe the classname on line number (" + lineNumber + ") is surrounded by whitespace, which is invalid.";
                throw new IllegalArgumentException(stringBuilder.append(string).toString(), e);
            }
            string = "";
            throw new IllegalArgumentException(stringBuilder.append(string).toString(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the solverConfigResource (" + solverConfigResource + ") failed.", e);
        }
    }

    public static SolverConfig createFromXmlFile(File solverConfigFile) {
        return SolverConfig.createFromXmlFile(solverConfigFile, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SolverConfig createFromXmlFile(File solverConfigFile, ClassLoader classLoader) {
        try (FileInputStream in = new FileInputStream(solverConfigFile);){
            SolverConfig solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
            return solverConfig;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The solverConfigFile (" + solverConfigFile + ") was not found.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the solverConfigFile (" + solverConfigFile + ") failed.", e);
        }
    }

    public static SolverConfig createFromXmlInputStream(InputStream in) {
        return SolverConfig.createFromXmlInputStream(in, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SolverConfig createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            SolverConfig solverConfig = SolverConfig.createFromXmlReader(reader, classLoader);
            return solverConfig;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading solverConfigInputStream failed.", e);
        }
    }

    public static SolverConfig createFromXmlReader(Reader reader) {
        return SolverConfig.createFromXmlReader(reader, null);
    }

    public static SolverConfig createFromXmlReader(Reader reader, ClassLoader classLoader) {
        XStream xStream = XStreamConfigReader.buildXStream(classLoader);
        Object solverConfigObject = xStream.fromXML(reader);
        if (!(solverConfigObject instanceof SolverConfig)) {
            throw new IllegalArgumentException("The " + SolverConfig.class.getSimpleName() + "'s XML root element resolves to a different type (" + (solverConfigObject == null ? null : solverConfigObject.getClass().getSimpleName()));
        }
        SolverConfig solverConfig = (SolverConfig)solverConfigObject;
        solverConfig.setClassLoader(classLoader);
        return solverConfig;
    }

    public SolverConfig() {
    }

    public SolverConfig(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SolverConfig(SolverConfig inheritedConfig) {
        this.inherit(inheritedConfig);
        if (this.environmentMode == EnvironmentMode.PRODUCTION) {
            this.environmentMode = EnvironmentMode.NON_REPRODUCIBLE;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(Boolean daemon) {
        this.daemon = daemon;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public void setRandomType(RandomType randomType) {
        this.randomType = randomType;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<? extends RandomFactory> getRandomFactoryClass() {
        return this.randomFactoryClass;
    }

    public void setRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
    }

    public String getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public void setMoveThreadCount(String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
    }

    public Integer getMoveThreadBufferSize() {
        return this.moveThreadBufferSize;
    }

    public void setMoveThreadBufferSize(Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    @Deprecated
    public ScanAnnotatedClassesConfig getScanAnnotatedClassesConfig() {
        return this.scanAnnotatedClassesConfig;
    }

    @Deprecated
    public void setScanAnnotatedClassesConfig(ScanAnnotatedClassesConfig scanAnnotatedClassesConfig) {
        this.scanAnnotatedClassesConfig = scanAnnotatedClassesConfig;
    }

    public Class<?> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<?> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public List<Class<?>> getEntityClassList() {
        return this.entityClassList;
    }

    public void setEntityClassList(List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
    }

    public ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<PhaseConfig> getPhaseConfigList() {
        return this.phaseConfigList;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public SolverConfig withEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
        return this;
    }

    public SolverConfig withDaemon(Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public SolverConfig withRandomType(RandomType randomType) {
        this.randomType = randomType;
        return this;
    }

    public SolverConfig withRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public SolverConfig withRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
        return this;
    }

    public SolverConfig withMoveThreadCount(String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
        return this;
    }

    public SolverConfig withMoveThreadBufferSize(Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
        return this;
    }

    public SolverConfig withThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
        return this;
    }

    public SolverConfig withSolutionClass(Class<?> solutionClass) {
        this.solutionClass = solutionClass;
        return this;
    }

    public SolverConfig withEntityClassList(List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
        return this;
    }

    public SolverConfig withEntityClasses(Class<?> ... entityClasses) {
        this.entityClassList = Arrays.asList(entityClasses);
        return this;
    }

    public SolverConfig withScoreDirectorFactory(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
        return this;
    }

    public SolverConfig withTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
        return this;
    }

    public SolverConfig withPhaseList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
        return this;
    }

    public SolverConfig withPhases(PhaseConfig ... phaseConfigs) {
        this.phaseConfigList = Arrays.asList(phaseConfigs);
        return this;
    }

    public EnvironmentMode determineEnvironmentMode() {
        if (this.environmentMode == EnvironmentMode.PRODUCTION) {
            this.environmentMode = EnvironmentMode.NON_REPRODUCIBLE;
        }
        return (EnvironmentMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.environmentMode), (Object)((Object)EnvironmentMode.REPRODUCIBLE)));
    }

    public void offerRandomSeedFromSubSingleIndex(long subSingleIndex) {
        if ((this.environmentMode == null || this.environmentMode.isReproducible()) && this.randomFactoryClass == null && this.randomSeed == null) {
            this.randomSeed = subSingleIndex;
        }
    }

    public <Solution_> Solver<Solution_> buildSolver(SolverConfigContext configContext) {
        configContext.validate();
        EnvironmentMode environmentMode_ = this.determineEnvironmentMode();
        boolean daemon_ = (Boolean)ObjectUtils.defaultIfNull((Object)this.daemon, (Object)false);
        RandomFactory randomFactory = this.buildRandomFactory(environmentMode_);
        Integer moveThreadCount_ = this.resolveMoveThreadCount();
        InnerScoreDirectorFactory<Solution_> scoreDirectorFactory = this.buildScoreDirectorFactory(configContext, environmentMode_);
        boolean constraintMatchEnabledPreference = environmentMode_.isAsserted();
        DefaultSolverScope<Solution_> solverScope = new DefaultSolverScope<Solution_>();
        solverScope.setScoreDirector(scoreDirectorFactory.buildScoreDirector(true, constraintMatchEnabledPreference));
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecallerConfig().buildBestSolutionRecaller(environmentMode_);
        HeuristicConfigPolicy configPolicy = new HeuristicConfigPolicy(environmentMode_, moveThreadCount_, this.moveThreadBufferSize, this.threadFactoryClass, scoreDirectorFactory);
        TerminationConfig terminationConfig_ = this.terminationConfig == null ? new TerminationConfig() : this.terminationConfig;
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination(daemon_);
        Termination termination = terminationConfig_.buildTermination(configPolicy, basicPlumbingTermination);
        List<Phase<Solution_>> phaseList = this.buildPhaseList(configPolicy, bestSolutionRecaller, termination);
        return new DefaultSolver(environmentMode_, randomFactory, bestSolutionRecaller, basicPlumbingTermination, termination, phaseList, solverScope);
    }

    protected RandomFactory buildRandomFactory(EnvironmentMode environmentMode_) {
        RandomFactory randomFactory;
        if (this.randomFactoryClass != null) {
            if (this.randomType != null || this.randomSeed != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (" + this.randomFactoryClass + ") has a non-null randomType (" + (Object)((Object)this.randomType) + ") or a non-null randomSeed (" + this.randomSeed + ").");
            }
            randomFactory = ConfigUtils.newInstance(this, "randomFactoryClass", this.randomFactoryClass);
        } else {
            RandomType randomType_ = (RandomType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.randomType), (Object)((Object)RandomType.JDK)));
            Long randomSeed_ = this.randomSeed;
            if (this.randomSeed == null && environmentMode_ != EnvironmentMode.NON_REPRODUCIBLE) {
                randomSeed_ = 0L;
            }
            randomFactory = new DefaultRandomFactory(randomType_, randomSeed_);
        }
        return randomFactory;
    }

    protected int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected Integer resolveMoveThreadCount() {
        Integer resolvedMoveThreadCount;
        int availableProcessorCount = this.getAvailableProcessors();
        if (this.moveThreadCount == null || this.moveThreadCount.equals(MOVE_THREAD_COUNT_NONE)) {
            return null;
        }
        if (this.moveThreadCount.equals(MOVE_THREAD_COUNT_AUTO)) {
            resolvedMoveThreadCount = availableProcessorCount - 2;
            if (resolvedMoveThreadCount <= 1) {
                return null;
            }
        } else {
            resolvedMoveThreadCount = ConfigUtils.resolvePoolSize("moveThreadCount", this.moveThreadCount, logger, MOVE_THREAD_COUNT_NONE, MOVE_THREAD_COUNT_AUTO);
        }
        if (resolvedMoveThreadCount < 1) {
            throw new IllegalArgumentException("The moveThreadCount (" + this.moveThreadCount + ") resulted in a resolvedMoveThreadCount (" + resolvedMoveThreadCount + ") that is lower than 1.");
        }
        if (resolvedMoveThreadCount > availableProcessorCount) {
            logger.warn("The resolvedMoveThreadCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedMoveThreadCount, (Object)availableProcessorCount);
        }
        return resolvedMoveThreadCount;
    }

    public <Solution_> InnerScoreDirectorFactory<Solution_> buildScoreDirectorFactory(SolverConfigContext configContext, EnvironmentMode environmentMode) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.buildSolutionDescriptor(configContext);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = this.scoreDirectorFactoryConfig == null ? new ScoreDirectorFactoryConfig() : this.scoreDirectorFactoryConfig;
        return scoreDirectorFactoryConfig_.buildScoreDirectorFactory(configContext, this.classLoader, environmentMode, solutionDescriptor);
    }

    public <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(SolverConfigContext configContext) {
        ScoreDefinition deprecatedScoreDefinition;
        ScoreDefinition scoreDefinition = deprecatedScoreDefinition = this.scoreDirectorFactoryConfig == null ? null : this.scoreDirectorFactoryConfig.buildDeprecatedScoreDefinition();
        if (this.scanAnnotatedClassesConfig != null) {
            if (this.solutionClass != null || this.entityClassList != null) {
                throw new IllegalArgumentException("The solver configuration with scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ") cannot also have a solutionClass (" + this.solutionClass + ") or an entityClass (" + this.entityClassList + ").\nMaybe delete the scanAnnotatedClasses element in the solver config.");
            }
            return this.scanAnnotatedClassesConfig.buildSolutionDescriptor(configContext, this.classLoader, deprecatedScoreDefinition);
        }
        if (this.solutionClass == null) {
            throw new IllegalArgumentException("The solver configuration must have a solutionClass (" + this.solutionClass + "), if it has no scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ").");
        }
        if (ConfigUtils.isEmptyCollection(this.entityClassList)) {
            throw new IllegalArgumentException("The solver configuration must have at least 1 entityClass (" + this.entityClassList + "), if it has no scanAnnotatedClasses (" + this.scanAnnotatedClassesConfig + ").");
        }
        return SolutionDescriptor.buildSolutionDescriptor(this.solutionClass, this.entityClassList, deprecatedScoreDefinition);
    }

    protected <Solution_> List<Phase<Solution_>> buildPhaseList(HeuristicConfigPolicy configPolicy, BestSolutionRecaller bestSolutionRecaller, Termination termination) {
        List<PhaseConfig> phaseConfigList_ = this.phaseConfigList;
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            phaseConfigList_ = Arrays.asList(new ConstructionHeuristicPhaseConfig(), new LocalSearchPhaseConfig());
        }
        ArrayList<Phase<Solution_>> phaseList = new ArrayList<Phase<Solution_>>(phaseConfigList_.size());
        int phaseIndex = 0;
        for (PhaseConfig phaseConfig : phaseConfigList_) {
            Phase phase = phaseConfig.buildPhase(phaseIndex, configPolicy, bestSolutionRecaller, termination);
            phaseList.add(phase);
            ++phaseIndex;
        }
        return phaseList;
    }

    @Override
    public SolverConfig inherit(SolverConfig inheritedConfig) {
        this.classLoader = ConfigUtils.inheritOverwritableProperty(this.classLoader, inheritedConfig.getClassLoader());
        this.environmentMode = ConfigUtils.inheritOverwritableProperty(this.environmentMode, inheritedConfig.getEnvironmentMode());
        this.daemon = ConfigUtils.inheritOverwritableProperty(this.daemon, inheritedConfig.getDaemon());
        this.randomType = ConfigUtils.inheritOverwritableProperty(this.randomType, inheritedConfig.getRandomType());
        this.randomSeed = ConfigUtils.inheritOverwritableProperty(this.randomSeed, inheritedConfig.getRandomSeed());
        this.randomFactoryClass = ConfigUtils.inheritOverwritableProperty(this.randomFactoryClass, inheritedConfig.getRandomFactoryClass());
        this.moveThreadCount = ConfigUtils.inheritOverwritableProperty(this.moveThreadCount, inheritedConfig.getMoveThreadCount());
        this.moveThreadBufferSize = ConfigUtils.inheritOverwritableProperty(this.moveThreadBufferSize, inheritedConfig.getMoveThreadBufferSize());
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        this.scanAnnotatedClassesConfig = ConfigUtils.inheritConfig(this.scanAnnotatedClassesConfig, inheritedConfig.getScanAnnotatedClassesConfig());
        this.solutionClass = ConfigUtils.inheritOverwritableProperty(this.solutionClass, inheritedConfig.getSolutionClass());
        this.entityClassList = ConfigUtils.inheritMergeableListProperty(this.entityClassList, inheritedConfig.getEntityClassList());
        this.scoreDirectorFactoryConfig = ConfigUtils.inheritConfig(this.scoreDirectorFactoryConfig, inheritedConfig.getScoreDirectorFactoryConfig());
        this.terminationConfig = ConfigUtils.inheritConfig(this.terminationConfig, inheritedConfig.getTerminationConfig());
        this.phaseConfigList = ConfigUtils.inheritMergeableListConfig(this.phaseConfigList, inheritedConfig.getPhaseConfigList());
        return this;
    }

    @Override
    public SolverConfig copyConfig() {
        return new SolverConfig().inherit(this);
    }
}

