/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kie.server.api.model.definition.ProcessInstanceField;
import org.kie.server.api.model.definition.ProcessInstanceQueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;

public class ProcessInstanceQueryFilterSpecBuilder {
    private List<QueryParam> parameters = new ArrayList<QueryParam>();
    private ProcessInstanceQueryFilterSpec filterSpec = new ProcessInstanceQueryFilterSpec();

    public ProcessInstanceQueryFilterSpec get() {
        if (!this.parameters.isEmpty()) {
            this.filterSpec.setParameters(this.parameters.toArray(new QueryParam[this.parameters.size()]));
        }
        return this.filterSpec;
    }

    public ProcessInstanceQueryFilterSpecBuilder orderBy(ProcessInstanceField field, boolean isAscending) {
        this.filterSpec.setOrderBy(field.toString());
        this.filterSpec.setAscending(isAscending);
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder isNull(ProcessInstanceField field) {
        this.parameters.add(new QueryParam(field.toString(), "IS_NULL", null));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder isNotNull(ProcessInstanceField field) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_NULL", null));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder equalsTo(ProcessInstanceField field, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(field.toString(), "EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder notEqualsTo(ProcessInstanceField field, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder likeTo(ProcessInstanceField field, boolean caseSensitive, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LIKE_TO", Arrays.asList(value, caseSensitive)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder greaterThan(ProcessInstanceField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "GREATER_THAN", Arrays.asList(value)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder greaterOrEqualTo(ProcessInstanceField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "GREATER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder lowerThan(ProcessInstanceField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LOWER_THAN", Arrays.asList(value)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder lowerOrEqualTo(ProcessInstanceField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LOWER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder between(ProcessInstanceField field, Comparable<?> start, Comparable<?> end) {
        this.parameters.add(new QueryParam(field.toString(), "BETWEEN", Arrays.asList(start, end)));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder in(ProcessInstanceField field, List<?> values) {
        this.parameters.add(new QueryParam(field.toString(), "IN", values));
        return this;
    }

    public ProcessInstanceQueryFilterSpecBuilder notIn(ProcessInstanceField field, List<?> values) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_IN", values));
        return this;
    }
}

