/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.services.taskassigning.planning.TaskAssigningServiceConfig;
import org.kie.server.services.taskassigning.planning.TaskAssigningValidationException;

public class TaskAssigningPlanningKieServerExtensionHelper {
    static final int DEFAULT_PUBLISH_WINDOW_SIZE = 2;
    static final String DEFAULT_SYNC_INTERVAL = "PT2S";
    static final String DEFAULT_SYNC_QUERIES_SHIFT = "PT10M";
    static final String DEFAULT_USERS_SYNC_INTERVAL = "PT2H";
    static final String DEFAULT_WAIT_FOR_IMPROVED_SOLUTION_DURATION = "PT0S";
    static final String DEFAULT_IMPROVE_SOLUTION_ON_BACKGROUND_DURATION = "PT1M";
    private static final String CAUSE = ", cause :";

    private TaskAssigningPlanningKieServerExtensionHelper() {
    }

    public static TaskAssigningServiceConfig readAndValidateTaskAssigningServiceConfig() throws TaskAssigningValidationException {
        String targetUserId = StringUtils.trimToNull((String)System.getProperty("org.kie.server.taskAssigning.processRuntime.targetUser"));
        if (Objects.isNull(targetUserId)) {
            throw new TaskAssigningValidationException(String.format("Parameter %s must have a non empty string value", "org.kie.server.taskAssigning.processRuntime.targetUser"));
        }
        int publishWindowSize = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterThanZeroInteger(System.getProperty("org.kie.server.taskAssigning.publishWindowSize", Integer.toString(2)), String.format("Parameter %s must be configured with a greater than zero integer value", "org.kie.server.taskAssigning.publishWindowSize"));
        Duration syncInterval = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterThanZeroDuration(System.getProperty("org.kie.server.taskAssigning.solutionSyncInterval", DEFAULT_SYNC_INTERVAL), String.format("Parameter %s must be configured with a greater than zero time duration", "org.kie.server.taskAssigning.solutionSyncInterval"));
        Duration syncQueriesShift = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterThanZeroDuration(System.getProperty("org.kie.server.taskAssigning.solutionSyncQueriesShift", DEFAULT_SYNC_QUERIES_SHIFT), String.format("Parameter %s must be configured with a greater than zero time duration", "org.kie.server.taskAssigning.solutionSyncQueriesShift"));
        Duration usersSyncInterval = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterOrEqualThanZeroDuration(System.getProperty("org.kie.server.taskAssigning.usersSyncInterval", DEFAULT_USERS_SYNC_INTERVAL), String.format("Parameter %s must be configured with a greater or equal to zero time duration", "org.kie.server.taskAssigning.usersSyncInterval"));
        Duration waitForImprovedSolutionDuration = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterOrEqualThanZeroDuration(System.getProperty("org.kie.server.taskAssigning.waitForImprovedSolutionDuration", DEFAULT_WAIT_FOR_IMPROVED_SOLUTION_DURATION), String.format("Parameter %s must be configured with a greater or equal to zero time duration", "org.kie.server.taskAssigning.waitForImprovedSolutionDuration"));
        Duration improveSolutionOnBackgroundDuration = TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateGreaterOrEqualThanZeroDuration(System.getProperty("org.kie.server.taskAssigning.improveSolutionOnBackgroundDuration", DEFAULT_IMPROVE_SOLUTION_ON_BACKGROUND_DURATION), String.format("Parameter %s must be configured with a greater or equal to zero time duration", "org.kie.server.taskAssigning.improveSolutionOnBackgroundDuration"));
        return new TaskAssigningServiceConfig(targetUserId, publishWindowSize, syncInterval, syncQueriesShift, usersSyncInterval, waitForImprovedSolutionDuration, improveSolutionOnBackgroundDuration);
    }

    private static Duration parseAndValidateGreaterThanZeroDuration(String value, String validationErrorMessage) throws TaskAssigningValidationException {
        return TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateDuration(value, duration -> duration.toMillis() > 0L, validationErrorMessage);
    }

    private static Duration parseAndValidateGreaterOrEqualThanZeroDuration(String value, String validationErrorMessage) throws TaskAssigningValidationException {
        return TaskAssigningPlanningKieServerExtensionHelper.parseAndValidateDuration(value, duration -> duration.toMillis() >= 0L, validationErrorMessage);
    }

    private static Duration parseAndValidateDuration(String value, Predicate<Duration> validation, String validationErrorMessage) throws TaskAssigningValidationException {
        Duration result;
        try {
            result = Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            String msg = validationErrorMessage + CAUSE + e.toString();
            throw new TaskAssigningValidationException(msg);
        }
        if (validation.negate().test(result)) {
            throw new TaskAssigningValidationException(validationErrorMessage);
        }
        return result;
    }

    private static int parseAndValidateGreaterThanZeroInteger(String value, String validationErrorMessage) throws TaskAssigningValidationException {
        int result;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = validationErrorMessage + CAUSE + e.toString();
            throw new TaskAssigningValidationException(msg);
        }
        if (result <= 0) {
            throw new TaskAssigningValidationException(validationErrorMessage);
        }
        return result;
    }
}

