/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtil.class);

    private PropertyUtil() {
    }

    public static <T, E extends Exception> T readSystemProperty(String propertyName, T defaultValue, PropertyParser<T, E> parser) {
        String strValue = null;
        try {
            strValue = System.getProperty(propertyName);
            if (strValue == null) {
                LOGGER.debug("Property: {}  was not configured. Default value will be used instead: {}", (Object)propertyName, defaultValue);
                return defaultValue;
            }
            return parser.parse(strValue);
        }
        catch (Exception e) {
            LOGGER.error("An error was produced while parsing " + propertyName + " value from string: " + strValue + ", default value: " + defaultValue + " will be used instead.", (Throwable)e);
            return defaultValue;
        }
    }

    public static interface PropertyParser<T, E extends Exception> {
        public T parse(String var1) throws E;
    }
}

