/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.jpa;

import java.io.InputStream;
import javax.naming.InitialContext;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.kie.server.services.jbpm.jpa.PersistenceUnitInfoImpl;

public class PersistenceUnitInfoLoader {
    public static PersistenceUnitInfo load(InputStream inputStream, InitialContext initialContext, ClassLoader classLoader) throws XMLStreamException {
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl(initialContext, classLoader);
        StringBuffer tagContent = new StringBuffer();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
        PersistenceXml tag = PersistenceXml.TAG_UNKNOWN;
        while (reader.hasNext()) {
            int event = reader.next();
            block0 : switch (event) {
                case 1: {
                    tag = PersistenceXml.parse(reader.getLocalName());
                    switch (tag) {
                        case TAG_PERSISTENCE: {
                            String schemaVersion = reader.getAttributeValue("", PersistenceXml.ATTR_SCHEMA_VERSION.toString());
                            persistenceUnitInfo.setPersistenceXMLSchemaVersion(schemaVersion);
                            break block0;
                        }
                        case TAG_PERSISTENCE_UNIT: {
                            String unitName = reader.getAttributeValue("", PersistenceXml.ATTR_UNIT_NAME.toString());
                            String transactionType = reader.getAttributeValue("", PersistenceXml.ATTR_TRANSACTION_TYPE.toString());
                            persistenceUnitInfo.setPersistenceUnitName(unitName);
                            persistenceUnitInfo.setTransactionType(transactionType);
                            break block0;
                        }
                        case TAG_EXCLUDE_UNLISTED_CLASSES: {
                            persistenceUnitInfo.setExcludeUnlistedClasses(true);
                            break block0;
                        }
                        case TAG_PROPERTY: {
                            persistenceUnitInfo.addProperty(reader.getAttributeValue("", "name"), reader.getAttributeValue("", "value"));
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    if (tag.equals((Object)PersistenceXml.TAG_UNKNOWN)) break;
                    tagContent.append(reader.getText());
                    break;
                }
                case 2: {
                    String s = tagContent.toString().trim();
                    tagContent = new StringBuffer();
                    if (s.isEmpty()) break;
                    switch (tag) {
                        case TAG_PROVIDER: {
                            persistenceUnitInfo.setPersistenceProviderClassName(s);
                            break block0;
                        }
                        case TAG_JTA_DATA_SOURCE: {
                            persistenceUnitInfo.setJtaDataSource(s);
                            break block0;
                        }
                        case TAG_NON_JTA_DATA_SOURCE: {
                            persistenceUnitInfo.setNonJtaDataSource(s);
                            break block0;
                        }
                        case TAG_MAPPING_FILE: {
                            persistenceUnitInfo.addMappingFile(s);
                            break block0;
                        }
                        case TAG_JAR_FILE: {
                            persistenceUnitInfo.addJarFileUrl(s);
                            break block0;
                        }
                        case TAG_CLASS: {
                            persistenceUnitInfo.addManagedClassName(s);
                            break block0;
                        }
                        case TAG_EXCLUDE_UNLISTED_CLASSES: {
                            persistenceUnitInfo.setExcludeUnlistedClasses(Boolean.parseBoolean(s));
                            break block0;
                        }
                        case TAG_SHARED_CACHE_MODE: {
                            persistenceUnitInfo.setSharedCacheMode(s);
                            break block0;
                        }
                        case TAG_VALIDATION_MODE: {
                            persistenceUnitInfo.setValidationMode(s);
                            break block0;
                        }
                    }
                }
            }
        }
        return persistenceUnitInfo;
    }

    public static Boolean isValidPersistenceKey(String propertyName) {
        if (propertyName.startsWith("hibernate.") || propertyName.startsWith("javax.persistence")) {
            return true;
        }
        return false;
    }

    static enum PersistenceXml {
        TAG_PERSISTENCE("persistence"),
        TAG_PERSISTENCE_UNIT("persistence-unit"),
        TAG_PROPERTIES("properties"),
        TAG_PROPERTY("property"),
        TAG_NON_JTA_DATA_SOURCE("non-jta-data-source"),
        TAG_JTA_DATA_SOURCE("jta-data-source"),
        TAG_CLASS("class"),
        TAG_MAPPING_FILE("mapping-file"),
        TAG_JAR_FILE("jar-file"),
        TAG_EXCLUDE_UNLISTED_CLASSES("exclude-unlisted-classes"),
        TAG_VALIDATION_MODE("validation-mode"),
        TAG_SHARED_CACHE_MODE("shared-cache-mode"),
        TAG_PROVIDER("provider"),
        TAG_UNKNOWN("unknown"),
        ATTR_UNIT_NAME("name"),
        ATTR_TRANSACTION_TYPE("transaction-type"),
        ATTR_SCHEMA_VERSION("version");

        private final String name;

        private PersistenceXml(String name) {
            this.name = name;
        }

        public static PersistenceXml parse(String aName) {
            try {
                return PersistenceXml.valueOf("TAG_" + aName.replace('-', '_').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return TAG_UNKNOWN;
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

