/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.user.system.simple;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.services.taskassigning.user.system.api.Group;
import org.kie.server.services.taskassigning.user.system.api.User;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.kie.server.services.taskassigning.user.system.simple.SimpleUserSystemServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUserSystemService
implements UserSystemService {
    static final String USERS_FILE_NOT_CONFIGURED_ERROR = "No users file configuration was provided. Please configure the property: %s";
    static final String USERS_INFO_LOADING_ERROR = "An error was produced during users information loading from files, users: %s, skills: %s, affinities: %s";
    public static final String USERS_FILE = "org.kie.server.services.taskassigning.user.system.simple.users";
    public static final String SKILLS_FILE = "org.kie.server.services.taskassigning.user.system.simple.skills";
    public static final String AFFINITIES_FILE = "org.kie.server.services.taskassigning.user.system.simple.affinities";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleUserSystemService.class);
    private SimpleUserSystemServiceHelper.UserGroupInfo userGroupInfo = new SimpleUserSystemServiceHelper.UserGroupInfo(new ArrayList<User>(), new ArrayList<Group>());
    private Map<String, User> userById = new HashMap<String, User>();
    protected Exception error = null;
    public static final String NAME = "SimpleUserSystemService";

    public void start() {
        String affinitiesFile;
        String usersFile = System.getProperty(USERS_FILE);
        if (StringUtils.isEmpty((CharSequence)usersFile)) {
            String msg = String.format(USERS_FILE_NOT_CONFIGURED_ERROR, USERS_FILE);
            throw new SimpleUserSystemServiceException(msg);
        }
        String skillsFile = System.getProperty(SKILLS_FILE);
        if (StringUtils.isNotEmpty((CharSequence)skillsFile)) {
            LOGGER.info("Using skills configuration from: {}", (Object)skillsFile);
        }
        if (StringUtils.isNotEmpty((CharSequence)(affinitiesFile = System.getProperty(AFFINITIES_FILE)))) {
            LOGGER.info("Using affinities configuration from: {}", (Object)affinitiesFile);
        }
        try {
            this.userGroupInfo = SimpleUserSystemServiceHelper.buildInfo(Paths.get(usersFile, new String[0]), StringUtils.isNotEmpty((CharSequence)skillsFile) ? Paths.get(skillsFile, new String[0]) : null, StringUtils.isNotEmpty((CharSequence)affinitiesFile) ? Paths.get(affinitiesFile, new String[0]) : null);
            this.userById = this.userGroupInfo.getUsers().stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        catch (Exception e) {
            String msg = String.format(USERS_INFO_LOADING_ERROR, usersFile, skillsFile, affinitiesFile);
            throw new SimpleUserSystemServiceException(msg, e);
        }
    }

    public String getName() {
        return NAME;
    }

    public List<User> findAllUsers() {
        return this.userGroupInfo.getUsers();
    }

    public List<Group> findAllGroups() {
        return this.userGroupInfo.getGroups();
    }

    public void test() {
    }

    public User findUser(String id) {
        return this.userById.get(id);
    }

    public class SimpleUserSystemServiceException
    extends RuntimeException {
        public SimpleUserSystemServiceException(String message, Throwable cause) {
            super(message, cause);
        }

        public SimpleUserSystemServiceException(String message) {
            super(message);
        }
    }
}

