/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Api(value="KIE Server and KIE containers")
@Path(value="server")
public class KieServerRestImpl {
    private KieServerImpl server;
    private MarshallerHelper marshallerHelper;

    public KieServerRestImpl() {
        this.server = KieServerLocator.getInstance();
        this.marshallerHelper = new MarshallerHelper(this.server.getServerRegistry());
    }

    public KieServerRestImpl(KieServerImpl server) {
        this.server = server;
        this.marshallerHelper = new MarshallerHelper(server.getServerRegistry());
    }

    public KieServerImpl getServer() {
        return this.server;
    }

    public void setServer(KieServerImpl server) {
        this.server = server;
    }

    @ApiOperation(value="Returns information about the KIE Server. The endpoint for this request is the base URL for the REST API.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Kie Server info\",\n      \"result\": {\n        \"kie-server-info\": {\n          \"id\": \"default-kieserver\",\n          \"version\": \"7.11.0.Final-redhat-00001\",\n          \"name\": \"default-kieserver\",\n          \"location\": \"http://localhost:8080/kie-server/services/rest/server\",\n          \"capabilities\": [\n            \"KieServer\",\n            \"BRM\",\n            \"BPM\",\n            \"CaseMgmt\",\n            \"BPM-UI\",\n            \"BRP\",\n            \"DMN\",\n            \"Swagger\"\n          ],\n          \"messages\": [\n            {\n              \"severity\": \"INFO\",\n              \"timestamp\": {\n                \"java.util.Date\": 1538996199184\n              },\n              \"content\": [\n                \"Server KieServerInfo{serverId='default-kieserver', version='7.11.0.Final-redhat-00001', name='default-kieserver', location='http://localhost:8080/kie-server/services/rest/server', capabilities=[KieServer, BRM, BPM, CaseMgmt, BPM-UI, BRP, DMN, Swagger], messages=null}started successfully at Mon Oct 08 06:56:39 EDT 2018\"\n              ]\n            }\n          ]\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getInfo(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant((Object)this.server.getInfo(), headers, new Header[0]);
    }

    @ApiOperation(value="Returns a list of KIE containers on the KIE Server.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"List of created containers\",\n      \"result\": {\n        \"kie-containers\": {\n          \"kie-container\": [\n            {\n              \"container-id\": \"MyProjectContainer\",\n              \"release-id\": {\n                \"group-id\": \"com.redhat\",\n                \"artifact-id\": \"Project1\",\n                \"version\": \"1.0\"\n              },\n              \"resolved-release-id\": {\n                \"group-id\": \"com.redhat\",\n                \"artifact-id\": \"Project1\",\n                \"version\": \"1.0\"\n              },\n              \"status\": \"STARTED\",\n              \"scanner\": {\n                \"status\": \"DISPOSED\",\n                \"poll-interval\": null\n              },\n              \"config-items\": [\n                {\n                  \"itemName\": \"KBase\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"KSession\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"MergeMode\",\n                  \"itemValue\": \"MERGE_COLLECTIONS\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"RuntimeStrategy\",\n                  \"itemValue\": \"SINGLETON\",\n                  \"itemType\": \"BPM\"\n                }\n              ],\n              \"messages\": [\n                {\n                  \"severity\": \"INFO\",\n                  \"timestamp\": {\n                    \"java.util.Date\": 1538996205681\n                  },\n                  \"content\": [\n                    \"Container MyProjectContainer successfully created with module com.redhat:Project1:1.0.\"\n                  ]\n                }\n              ],\n              \"container-alias\": \"MyProjectContainer\"\n            },\n            {\n              \"container-id\": \"employe-rostering\",\n              \"release-id\": {\n                \"group-id\": \"employeerostering\",\n                \"artifact-id\": \"employeerostering\",\n                \"version\": \"1.0.0-SNAPSHOT\"\n              },\n              \"resolved-release-id\": {\n                \"group-id\": \"employeerostering\",\n                \"artifact-id\": \"employeerostering\",\n                \"version\": \"1.0.0-SNAPSHOT\"\n              },\n              \"status\": \"STARTED\",\n              \"scanner\": {\n                \"status\": \"DISPOSED\",\n                \"poll-interval\": null\n              },\n              \"config-items\": [\n                {\n                  \"itemName\": \"KBase\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"KSession\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"MergeMode\",\n                  \"itemValue\": \"MERGE_COLLECTIONS\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"RuntimeStrategy\",\n                  \"itemValue\": \"SINGLETON\",\n                  \"itemType\": \"BPM\"\n                }\n              ],\n              \"messages\": [\n                {\n                  \"severity\": \"INFO\",\n                  \"timestamp\": {\n                    \"java.util.Date\": 1539029260330\n                  },\n                  \"content\": [\n                    \"Container employee-rostering successfully created with module employeerostering:employeerostering:1.0.0-SNAPSHOT.\"\n                  ]\n                }\n              ],\n              \"container-alias\": \"employeerostering\"\n            }\n          ]\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers")
    @Produces(value={"application/json", "application/xml"})
    public Response listContainers(@Context HttpHeaders headers, @ApiParam(value="optional groupId to filter containers by", required=false) @QueryParam(value="groupId") String groupId, @ApiParam(value="optional artifactId to filter containers by", required=false) @QueryParam(value="artifactId") String artifactId, @ApiParam(value="optional version to filter containers by", required=false) @QueryParam(value="version") String version, @ApiParam(value="optional status to filter containers by", required=false) @QueryParam(value="status") String status) {
        ReleaseIdFilter releaseIdFilter = new ReleaseIdFilter.Builder().groupId(groupId).artifactId(artifactId).version(version).build();
        KieContainerStatusFilter statusFilter = KieContainerStatusFilter.parseFromNullableString((String)status);
        KieContainerResourceFilter containerFilter = new KieContainerResourceFilter(releaseIdFilter, statusFilter);
        return RestUtils.createCorrectVariant((Object)this.server.listContainers(containerFilter), headers, new Header[0]);
    }

    @ApiOperation(value="Creates a new KIE container in the KIE Server with a specified KIE container ID", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be created"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container MyProjectContainer successfully deployed with module com.redhat:Project1:1.0.\",\n      \"result\": {\n        \"kie-container\": {\n          \"container-id\": \"MyProjectContainer\",\n          \"release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"resolved-release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"status\": \"STARTED\",\n          \"scanner\": {\n            \"status\": \"DISPOSED\",\n            \"poll-interval\": null\n          },\n          \"config-items\": [\n\n          ],\n          \"messages\": [\n            {\n              \"severity\": \"INFO\",\n              \"timestamp\": {\n                \"java.util.Date\": 1538756503852\n              },\n              \"content\": [\n                \"Container MyProjectContainer successfully created with module com.redhat:Project1:1.0.\"\n              ]\n            }\n          ],\n          \"container-alias\": null\n        }\n      }\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="containers/{containerId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response createContainer(@Context HttpHeaders headers, @ApiParam(value="Container id to be assigned to deployed KIE Container", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id, @ApiParam(value="KIE Container resource to be deployed as KieContainerResource", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"container-id\" : \"baz\",\n    \"release-id\" : {\n        \"group-id\" : \"foo\",\n        \"artifact-id\" : \"bar\",\n        \"version\" : \"1.0\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kie-container container-id=\"baz\">\n    <release-id>\n        <group-id>foo</group-id>\n        <artifact-id>bar</artifact-id>\n        <version>1.0</version>\n    </release-id>\n</kie-container>\n")})) String containerPayload) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        KieContainerResource container = (KieContainerResource)this.marshallerHelper.unmarshal(containerPayload, contentType, KieContainerResource.class);
        ServiceResponse response = this.server.createContainer(id, container);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Activates (previously deactivated) KIE container on this server", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be activated"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container MyProjectContainer successfully deployed with module com.redhat:Project1:1.0.\",\n      \"result\": {\n        \"kie-container\": {\n          \"container-id\": \"MyProjectContainer\",\n          \"release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"resolved-release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"status\": \"STARTED\",\n          \"scanner\": {\n            \"status\": \"DISPOSED\",\n            \"poll-interval\": null\n          },\n          \"config-items\": [\n\n          ],\n          \"messages\": [\n            {\n              \"severity\": \"INFO\",\n              \"timestamp\": {\n                \"java.util.Date\": 1538756503852\n              },\n              \"content\": [\n                \"Container MyProjectContainer successfully created with module com.redhat:Project1:1.0.\"\n              ]\n            }\n          ],\n          \"container-alias\": null\n        }\n      }\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="containers/{containerId}/status/activated")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response activateContainer(@Context HttpHeaders headers, @ApiParam(value="Container id of deployed KIE Container", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        ServiceResponse response = this.server.activateContainer(id);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Deactivates (previously started) KIE container on this server", response=ServiceResponse.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="container could not be deactivated"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container MyProjectContainer successfully deployed with module com.redhat:Project1:1.0.\",\n      \"result\": {\n        \"kie-container\": {\n          \"container-id\": \"MyProjectContainer\",\n          \"release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"resolved-release-id\": {\n            \"artifact-id\": \"Project1\",\n            \"group-id\": \"com.redhat\",\n            \"version\": \"1.0\"\n          },\n          \"status\": \"DEACTIVATED\",\n          \"scanner\": {\n            \"status\": \"DISPOSED\",\n            \"poll-interval\": null\n          },\n          \"config-items\": [\n\n          ],\n          \"messages\": [\n            {\n              \"severity\": \"INFO\",\n              \"timestamp\": {\n                \"java.util.Date\": 1538756503852\n              },\n              \"content\": [\n                \"Container MyProjectContainer successfully created with module com.redhat:Project1:1.0.\"\n              ]\n            }\n          ],\n          \"container-alias\": null\n        }\n      }\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="containers/{containerId}/status/deactivated")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response deactivateContainer(@Context HttpHeaders headers, @ApiParam(value="Container id of deployed KIE Container", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        ServiceResponse response = this.server.deactivateContainer(id);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        if (response.getType() == KieServiceResponse.ResponseType.SUCCESS) {
            return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.CREATED, conversationIdHeader);
        }
        return RestUtils.createCorrectVariant((Object)response, headers, Response.Status.BAD_REQUEST, new Header[0]);
    }

    @ApiOperation(value="Returns information about a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="\u2060{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Info for container MyProjectContainer\",\n      \"result\": {\n        \"kie-containers\": {\n          \"kie-container\": [\n            {\n              \"container-id\": \"MyProjectContainer\",\n              \"release-id\": {\n                \"group-id\": \"com.redhat\",\n                \"artifact-id\": \"Project1\",\n                \"version\": \"1.0\"\n              },\n              \"resolved-release-id\": {\n                \"group-id\": \"com.redhat\",\n                \"artifact-id\": \"Project1\",\n                \"version\": \"1.0\"\n              },\n              \"status\": \"STARTED\",\n              \"scanner\": {\n                \"status\": \"DISPOSED\",\n                \"poll-interval\": null\n              },\n              \"config-items\": [\n                {\n                  \"itemName\": \"KBase\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"KSession\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"MergeMode\",\n                  \"itemValue\": \"MERGE_COLLECTIONS\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"RuntimeStrategy\",\n                  \"itemValue\": \"SINGLETON\",\n                  \"itemType\": \"BPM\"\n                }\n              ],\n              \"messages\": [\n                {\n                  \"severity\": \"INFO\",\n                  \"timestamp\": {\n                    \"java.util.Date\": 1538996205681\n                  },\n                  \"content\": [\n                    \"Container MyProjectContainer successfully created with module com.redhat:Project1:1.0.\"\n                  ]\n                }\n              ],\n              \"container-alias\": \"MyProjectContainer\"\n            }\n          ]\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerInfo(@Context HttpHeaders headers, @ApiParam(value="Container id to be retrieved", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getContainerInfo(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Disposes a specified KIE container.", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Container MyProjectContainer successfully disposed.\",\n      \"result\": null\n    }\n  ]\n}")}))})
    @DELETE
    @Path(value="containers/{containerId}")
    @Produces(value={"application/json", "application/xml"})
    public Response disposeContainer(@Context HttpHeaders headers, @ApiParam(value="Container id to be disposed (undeployed)", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.disposeContainer(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Returns information about the KIE scanner used for automatic updates in a specified KIE container, if applicable.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Scanner info successfully retrieved\",\n      \"result\": {\n        \"kie-scanner\": {\n          \"status\": \"DISPOSED\",\n          \"poll-interval\": null\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}/scanner")
    @Produces(value={"application/json", "application/xml"})
    public Response getScannerInfo(@Context HttpHeaders headers, @ApiParam(value="Container id for scanner to be loaded", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getScannerInfo(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Starts or stops a KIE scanner that controls polling for updated KIE container deployments, if applicable.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Kie scanner successfully created.\",\n      \"result\": {\n        \"kie-scanner\": {\n          \"status\": \"STARTED\",\n          \"poll-interval\": 20\n        }\n      }\n    }\n  ]\n}")}))})
    @POST
    @Path(value="containers/{containerId}/scanner")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateScanner(@Context HttpHeaders headers, @ApiParam(value="Container id for scanner to be updated", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id, @ApiParam(value="Scanner information given as KieScannerResource type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"status\" : \"STARTED\",\n    \"poll-interval\" : \"10000\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kie-scanner poll-interval=\"10000\" status=\"STARTED\"/>\n")})) String resourcePayload) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        KieScannerResource resource = (KieScannerResource)this.marshallerHelper.unmarshal(resourcePayload, contentType, KieScannerResource.class);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.updateScanner(id, resource), headers, conversationIdHeader);
    }

    @ApiOperation(value="Returns release ID information (group ID, artifact ID, version) for a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"ReleaseId for container MyProjectContainer\",\n      \"result\": {\n        \"release-id\": {\n          \"group-id\": \"com.redhat\",\n          \"artifact-id\": \"Project1\",\n          \"version\": \"1.0\"\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="containers/{containerId}/release-id")
    @Produces(value={"application/json", "application/xml"})
    public Response getReleaseId(@Context HttpHeaders headers, @ApiParam(value="Container id that release id should be loaded from", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.getContainerReleaseId(id), headers, conversationIdHeader);
    }

    @ApiOperation(value="Updates release ID information (group ID, artifact ID, version) for a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"-type\": \"SUCCESS\",\n      \"-msg\": \"Release id successfully updated.\",\n      \"release-id\": {\n        \"artifact-id\": \"Project1\",\n        \"group-id\": \"com.redhat\",\n        \"version\": \"1.1\"\n      }\n    }\n  ]\n}")}))})
    @POST
    @Path(value="containers/{containerId}/release-id")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateReleaseId(@Context HttpHeaders headers, @ApiParam(value="Container id that release id should be upgraded", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String id, @ApiParam(value="Release Id to be upgraded to as ReleaseId type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"group-id\" : \"foo\",\n    \"artifact-id\" : \"bar\",\n    \"version\" : \"1.0\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<release-id>\n    <group-id>foo</group-id>\n    <artifact-id>bar</artifact-id>\n    <version>1.0</version>\n</release-id>\n")})) String releaseIdPayload, @ApiParam(value="Determines whether active processes are aborted (reset) before updating when the server runs in development mode") @QueryParam(value="resetBeforeUpdate") @DefaultValue(value="false") boolean resetBeforeUpdate) {
        ServiceResponse forbidden = this.server.checkAccessability();
        if (forbidden != null) {
            return RestUtils.createCorrectVariant((Object)forbidden, headers, Response.Status.BAD_REQUEST, new Header[0]);
        }
        String contentType = RestUtils.getContentType(headers);
        ReleaseId releaseId = (ReleaseId)this.marshallerHelper.unmarshal(releaseIdPayload, contentType, ReleaseId.class);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader(id, this.server.getServerRegistry(), headers);
        return RestUtils.createCorrectVariant((Object)this.server.updateContainerReleaseId(id, releaseId, resetBeforeUpdate), headers, conversationIdHeader);
    }

    @ApiOperation(value="Returns information about the current state and configurations of the KIE Server.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ServiceResponse.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"response\": [\n    {\n      \"type\": \"SUCCESS\",\n      \"msg\": \"Successfully loaded server state for server id default-kieserver\",\n      \"result\": {\n        \"kie-server-state-info\": {\n          \"controller\": [\n            \"http://localhost:8080/business-central/rest/controller\"\n          ],\n          \"config\": {\n            \"config-items\": [\n              {\n                \"itemName\": \"org.kie.server.location\",\n                \"itemValue\": \"http://localhost:8080/kie-server/services/rest/server\",\n                \"itemType\": \"java.lang.String\"\n              },\n              {\n                \"itemName\": \"org.kie.server.controller.user\",\n                \"itemValue\": \"controllerUser\",\n                \"itemType\": \"java.lang.String\"\n              },\n              {\n                \"itemName\": \"org.kie.server.controller\",\n                \"itemValue\": \"http://localhost:8080/business-central/rest/controller\",\n                \"itemType\": \"java.lang.String\"\n              }\n            ]\n          },\n          \"containers\": [\n            {\n              \"container-id\": \"employee-rostering\",\n              \"release-id\": {\n                \"group-id\": \"employeerostering\",\n                \"artifact-id\": \"employeerostering\",\n                \"version\": \"1.0.0-SNAPSHOT\"\n              },\n              \"resolved-release-id\": null,\n              \"status\": \"STARTED\",\n              \"scanner\": {\n                \"status\": \"STOPPED\",\n                \"poll-interval\": null\n              },\n              \"config-items\": [\n                {\n                  \"itemName\": \"KBase\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"KSession\",\n                  \"itemValue\": \"\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"MergeMode\",\n                  \"itemValue\": \"MERGE_COLLECTIONS\",\n                  \"itemType\": \"BPM\"\n                },\n                {\n                  \"itemName\": \"RuntimeStrategy\",\n                  \"itemValue\": \"SINGLETON\",\n                  \"itemType\": \"BPM\"\n                }\n              ],\n              \"messages\": [],\n              \"container-alias\": \"employeerostering\"\n            }\n          ]\n        }\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="state")
    @Produces(value={"application/json", "application/xml"})
    public Response getServerState(@Context HttpHeaders headers) {
        return RestUtils.createCorrectVariant((Object)this.server.getServerState(), headers, new Header[0]);
    }

    @ApiOperation(value="Readiness check for KIE Server that indicates that server is fully booted and ready to accept requests", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=503, message="Service not yet available")})
    @GET
    @Path(value="readycheck")
    @Produces(value={"text/plain"})
    public Response readycheck(@Context HttpHeaders headers) {
        if (this.server.isKieServerReady()) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return RestUtils.serviceUnavailable(new Header[0]);
    }

    @ApiOperation(value="Liveness check for KIE Server that validates both kie server and all extensions, optionally produces report", response=Message.class, code=200, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=503, message="If any of the checks failed")})
    @GET
    @Path(value="healthcheck")
    @Produces(value={"application/json", "application/xml"})
    public Response healthcheck(@Context HttpHeaders headers, @ApiParam(value="optional report flag to return detailed report of the check, defaults to false", required=false) @QueryParam(value="report") @DefaultValue(value="false") boolean report) {
        List healthMessages = this.server.healthCheck(report);
        boolean anyfailures = healthMessages.stream().anyMatch(msg -> msg.getSeverity().equals((Object)Severity.ERROR));
        if (anyfailures) {
            if (report) {
                return RestUtils.createCorrectVariant((Object)healthMessages, headers, Response.Status.SERVICE_UNAVAILABLE, new Header[0]);
            }
            return RestUtils.serviceUnavailable(new Header[0]);
        }
        if (report) {
            return RestUtils.createCorrectVariant((Object)healthMessages, headers, Response.Status.OK, new Header[0]);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

