/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;
import org.drools.scenariosimulation.backend.util.JsonUtils;

public class ExpressionEvaluatorFactory {
    private final ClassLoader classLoader;
    private final ScenarioSimulationModel.Type type;
    private BaseExpressionEvaluator baseExpressionEvaluator;
    private DMNFeelExpressionEvaluator dmnFeelExpressionEvaluator;
    private MVELExpressionEvaluator mvelExpressionEvaluator;

    public static ExpressionEvaluatorFactory create(ClassLoader classLoader, ScenarioSimulationModel.Type type) {
        return new ExpressionEvaluatorFactory(classLoader, type);
    }

    private ExpressionEvaluatorFactory(ClassLoader classLoader, ScenarioSimulationModel.Type type) {
        this.classLoader = classLoader;
        this.type = type;
    }

    public ExpressionEvaluator getOrCreate(FactMappingValue factMappingValue) {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)this.type)) {
            return this.getOrCreateDMNExpressionEvaluator();
        }
        String rawValue = (String)factMappingValue.getRawValue();
        if (this.isAnMVELExpression(rawValue)) {
            return this.getOrCreateMVELExpressionEvaluator();
        }
        return this.getOrCreateBaseExpressionEvaluator();
    }

    protected boolean isAnMVELExpression(String rawValue) {
        if (rawValue.trim().startsWith("#")) {
            return true;
        }
        Optional<JsonNode> optionalNode = JsonUtils.convertFromStringToJSONNode(rawValue);
        return optionalNode.filter(jsonNode -> jsonNode.isTextual() && jsonNode.asText().trim().startsWith("#")).isPresent();
    }

    private ExpressionEvaluator getOrCreateBaseExpressionEvaluator() {
        if (this.baseExpressionEvaluator == null) {
            this.baseExpressionEvaluator = new BaseExpressionEvaluator(this.classLoader);
        }
        return this.baseExpressionEvaluator;
    }

    private ExpressionEvaluator getOrCreateMVELExpressionEvaluator() {
        if (this.mvelExpressionEvaluator == null) {
            this.mvelExpressionEvaluator = new MVELExpressionEvaluator(this.classLoader);
        }
        return this.mvelExpressionEvaluator;
    }

    private ExpressionEvaluator getOrCreateDMNExpressionEvaluator() {
        if (this.dmnFeelExpressionEvaluator == null) {
            this.dmnFeelExpressionEvaluator = new DMNFeelExpressionEvaluator(this.classLoader);
        }
        return this.dmnFeelExpressionEvaluator;
    }
}

