/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class BigIntegerSumAccumulateFunction
extends AbstractAccumulateFunction<SumData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public SumData createContext() {
        return new SumData();
    }

    public void init(SumData data) {
        data.total = BigInteger.ZERO;
    }

    public void accumulate(SumData data, Object value) {
        if (value != null) {
            data.total = data.total.add((BigInteger)value);
        }
    }

    public void reverse(SumData data, Object value) {
        if (value != null) {
            data.total = data.total.subtract((BigInteger)value);
        }
    }

    public Object getResult(SumData data) {
        return data.total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return BigInteger.class;
    }

    protected static class SumData
    implements Externalizable {
        public BigInteger total = BigInteger.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = (BigInteger)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.total);
        }
    }
}

