/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.lang.reflect.Method;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ValueType;

public abstract class BaseCharClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseCharClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseCharClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public BaseCharClassFieldWriter() {
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setCharValue(bean, value == null ? (char)'\u0000' : ((Character)value).charValue());
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeException("Conversion to char not supported from boolean");
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public abstract void setCharValue(Object var1, char var2);

    @Override
    public void setDoubleValue(Object bean, double value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public void setFloatValue(Object bean, float value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public void setIntValue(Object bean, int value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public void setLongValue(Object bean, long value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public void setShortValue(Object bean, short value) {
        this.setCharValue(bean, (char)value);
    }

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setCharValue", Object.class, Character.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

