/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.task.commands.CompositeCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Status;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.PlanningTask;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.util.StatusConverter;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.taskassigning.runtime.TaskAssigningRuntimeServiceQueryHelper;
import org.kie.server.services.taskassigning.runtime.command.DelegateAndSaveCommand;
import org.kie.server.services.taskassigning.runtime.command.DeletePlanningItemCommand;
import org.kie.server.services.taskassigning.runtime.command.PlanningCommand;
import org.kie.server.services.taskassigning.runtime.command.PlanningException;
import org.kie.server.services.taskassigning.runtime.command.SavePlanningItemCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssigningRuntimeServiceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningRuntimeServiceBase.class);
    private static final int INTERNAL_QUERY_PAGE_SIZE = 3000;
    static final String TASK_MODIFIED_ERROR_MSG = "Task: %s was modified by an external action since the last executed plan";
    static final String TASK_MODIFIED_ERROR_MSG_1 = "Task: %s was modified by an external action since the last executed plan actualOwner is %s but the last assignedUser is %s";
    static final String TASK_MODIFIED_ERROR_MSG_2 = "Task: %s was modified by an external action since the last executed plan actualOwner is %s but the expected is %s";
    static final String TASK_MODIFIED_ERROR_MSG_3 = "Task: %s was modified by an external action since the last executed plan and is no longer in one of the expected status %s";
    static final String UNEXPECTED_ERROR_DURING_PLAN_CALCULATION = "An unexpected error was produced during plan calculation: %s";
    static final String UNEXPECTED_ERROR_DURING_PLAN_EXECUTION = "An unexpected error was produced during plan execution on containerId: %s, message: %s";
    static final String SERVER_NOT_READY_ERROR = "Current server is not ready to serve requests";
    private KieServerImpl kieServer;
    private KieServerRegistry registry;
    private UserTaskService userTaskService;
    private TaskAssigningRuntimeServiceQueryHelper queryHelper;

    public TaskAssigningRuntimeServiceBase(KieServerImpl kieServer, KieServerRegistry registry, UserTaskService userTaskService, QueryService queryService) {
        this.kieServer = kieServer;
        this.registry = registry;
        this.userTaskService = userTaskService;
        this.queryHelper = this.createQueryHelper(registry, userTaskService, queryService);
    }

    public List<TaskData> executeFindTasksQuery(Map<String, Object> params) {
        this.checkServerStatus();
        return this.queryHelper.executeFindTasksQuery(params);
    }

    public PlanningExecutionResult executePlanning(PlanningItemList planningItemList, String userId) {
        Map<String, List<PlanningCommand>> commandsByContainer;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.checkServerStatus();
        try {
            commandsByContainer = this.calculatePlanningCommands(planningItemList, userId);
        }
        catch (PlanningException e) {
            LOGGER.debug("An error was produced during plan calculation, containerId: {}, error code: {}, message: {}", new Object[]{e.getContainerId(), e.getCode(), e.getMessage()});
            return PlanningExecutionResult.builder().error(e.getCode()).errorMessage(e.getMessage()).containerId(e.getContainerId()).build();
        }
        catch (Exception e) {
            String msg = String.format(UNEXPECTED_ERROR_DURING_PLAN_CALCULATION, e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            return PlanningExecutionResult.builder().error(PlanningExecutionResult.ErrorCode.UNEXPECTED_ERROR).errorMessage(msg).build();
        }
        stopWatch.stop();
        LOGGER.debug("Time to calculate the planning commands: {}", (Object)stopWatch);
        stopWatch.reset();
        stopWatch.start();
        for (Map.Entry<String, List<PlanningCommand>> entry : commandsByContainer.entrySet()) {
            try {
                this.executeContainerCommands(entry.getKey(), entry.getValue());
            }
            catch (PlanningException e) {
                LOGGER.debug("An error was produced during plan execution on containerId: {}, error code: {}, message: {}", new Object[]{entry.getKey(), e.getCode(), e.getMessage()});
                return PlanningExecutionResult.builder().error(e.getCode()).errorMessage(e.getMessage()).containerId(e.getContainerId()).build();
            }
            catch (Exception e) {
                String msg = String.format(UNEXPECTED_ERROR_DURING_PLAN_EXECUTION, entry.getKey(), e.getMessage());
                LOGGER.error(msg, (Throwable)e);
                return PlanningExecutionResult.builder().error(PlanningExecutionResult.ErrorCode.UNEXPECTED_ERROR).errorMessage(msg).containerId(entry.getKey()).build();
            }
        }
        stopWatch.stop();
        LOGGER.debug("Time for executing the planning with planning items: {}  ->  {}", (Object)planningItemList.getItems().size(), (Object)stopWatch);
        return PlanningExecutionResult.builder().build();
    }

    private Map<String, List<PlanningCommand>> calculatePlanningCommands(PlanningItemList planningItemList, String userId) {
        HashMap<String, List<PlanningCommand>> commandsByContainer = new HashMap<String, List<PlanningCommand>>();
        Map<Long, TaskData> taskDataById = this.prepareTaskDataForExecutePlanning();
        block5: for (PlanningItem planningItem : planningItemList.getItems()) {
            TaskData taskData = taskDataById.remove(planningItem.getTaskId());
            if (taskData == null) {
                throw new PlanningException(String.format(TASK_MODIFIED_ERROR_MSG_3, planningItem.getPlanningTask().getTaskId(), Arrays.toString(new Status[]{Status.Ready, Status.Reserved, Status.InProgress, Status.Suspended})), planningItem.getContainerId(), PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR);
            }
            String actualOwner = taskData.getActualOwner();
            PlanningTask actualPlanningTask = taskData.getPlanningTask();
            Status taskStatus = StatusConverter.convertFromString((String)taskData.getStatus());
            if (StringUtils.isNotEmpty((CharSequence)actualOwner) && actualPlanningTask != null && actualOwner.equals(actualPlanningTask.getAssignedUser()) && actualPlanningTask.equals((Object)planningItem.getPlanningTask())) continue;
            switch (taskStatus) {
                case Ready: {
                    this.addCommand(commandsByContainer, planningItem.getContainerId(), new DelegateAndSaveCommand(planningItem, userId));
                    continue block5;
                }
                case Reserved: {
                    if (actualPlanningTask != null && !actualOwner.equals(actualPlanningTask.getAssignedUser()) && !actualOwner.equals(planningItem.getPlanningTask().getAssignedUser())) {
                        throw new PlanningException(String.format(TASK_MODIFIED_ERROR_MSG_1, planningItem.getPlanningTask().getTaskId(), actualOwner, actualPlanningTask.getAssignedUser()), planningItem.getContainerId(), PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR);
                    }
                    this.addCommand(commandsByContainer, planningItem.getContainerId(), new DelegateAndSaveCommand(planningItem, userId));
                    continue block5;
                }
                case InProgress: 
                case Suspended: {
                    if (actualOwner == null || !actualOwner.equals(planningItem.getPlanningTask().getAssignedUser())) {
                        throw new PlanningException(String.format(TASK_MODIFIED_ERROR_MSG_2, planningItem.getPlanningTask().getTaskId(), actualOwner, planningItem.getPlanningTask().getAssignedUser()), planningItem.getContainerId(), PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR);
                    }
                    this.addCommand(commandsByContainer, planningItem.getContainerId(), new SavePlanningItemCommand(planningItem));
                    continue block5;
                }
            }
            throw new IndexOutOfBoundsException("Value: " + taskData.getStatus() + " is out of range in current switch");
        }
        for (TaskData taskData : taskDataById.values()) {
            Status status = StatusConverter.convertFromString((String)taskData.getStatus());
            if (status != Status.Ready && status != Status.Reserved && status != Status.Suspended || taskData.getPlanningTask() == null) continue;
            commandsByContainer.computeIfAbsent(taskData.getContainerId(), k -> new ArrayList()).add(new DeletePlanningItemCommand(taskData.getTaskId()));
        }
        return commandsByContainer;
    }

    TaskAssigningRuntimeServiceQueryHelper createQueryHelper(KieServerRegistry registry, UserTaskService userTaskService, QueryService queryService) {
        return new TaskAssigningRuntimeServiceQueryHelper(registry, userTaskService, queryService);
    }

    private Map<Long, TaskData> prepareTaskDataForExecutePlanning() {
        List<TaskData> result = this.queryHelper.readTasksDataSummary(0L, StatusConverter.convertToStringList((Status[])new Status[]{Status.Ready, Status.Reserved, Status.InProgress, Status.Suspended}), 3000);
        return result.stream().collect(Collectors.toMap(TaskData::getTaskId, Function.identity()));
    }

    private void executeContainerCommands(String containerId, List<PlanningCommand> commands) {
        LOGGER.debug("Executing planning commands for container: {}", (Object)containerId);
        ArrayList<DelegateAndSaveCommand> delegations = new ArrayList<DelegateAndSaveCommand>();
        ArrayList<SavePlanningItemCommand> saves = new ArrayList<SavePlanningItemCommand>();
        ArrayList<DeletePlanningItemCommand> deletes = new ArrayList<DeletePlanningItemCommand>();
        this.validateContainer(containerId);
        for (PlanningCommand command : commands) {
            if (command instanceof DelegateAndSaveCommand) {
                delegations.add((DelegateAndSaveCommand)command);
                continue;
            }
            if (command instanceof SavePlanningItemCommand) {
                saves.add((SavePlanningItemCommand)command);
                continue;
            }
            if (!(command instanceof DeletePlanningItemCommand)) continue;
            deletes.add((DeletePlanningItemCommand)command);
        }
        this.bulkDelegate(containerId, delegations);
        ArrayList<DeletePlanningItemCommand> onlyDBCommands = new ArrayList<DeletePlanningItemCommand>(saves);
        onlyDBCommands.addAll(deletes);
        if (!onlyDBCommands.isEmpty()) {
            CompositeCommand onlyDBCommand = new CompositeCommand((TaskCommand)new TaskCommand<TaskCommand>(){

                public TaskCommand execute(Context context) {
                    return null;
                }
            }, onlyDBCommands.toArray(new TaskCommand[0]));
            this.userTaskService.execute(containerId, (Command)onlyDBCommand);
        }
        LOGGER.debug("Planning commands execution for container: {} finished successfully", (Object)containerId);
    }

    private void validateContainer(String containerId) {
        KieContainerInstanceImpl container = this.registry.getContainer(containerId);
        if (container == null || container.getStatus() != KieContainerStatus.STARTED && container.getStatus() != KieContainerStatus.DEACTIVATED) {
            throw new KieServicesException("Container " + containerId + " is not available to serve requests");
        }
    }

    private void bulkDelegate(String containerId, List<DelegateAndSaveCommand> delegations) {
        LOGGER.debug("Executing bulk delegation for container: {}", (Object)containerId);
        for (DelegateAndSaveCommand command : delegations) {
            this.userTaskService.execute(containerId, (Command)command);
        }
        LOGGER.debug("Bulk delegation for container: {} finished successfully", (Object)containerId);
    }

    private void addCommand(Map<String, List<PlanningCommand>> commandsByContainer, String containerId, PlanningCommand command) {
        commandsByContainer.computeIfAbsent(containerId, k -> new ArrayList()).add(command);
    }

    private void checkServerStatus() {
        if (!this.kieServer.isKieServerReady()) {
            throw new KieServicesException(SERVER_NOT_READY_ERROR);
        }
    }
}

