/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.taskassigning.runtime;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.TaskDataList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.taskassigning.runtime.TaskAssigningRuntimeServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Task assigning integration")
@Path(value="server/taskassigning/runtime")
public class TaskAssigningRuntimeResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningRuntimeResource.class);
    private TaskAssigningRuntimeServiceBase runtimeServiceBase;
    private KieServerRegistry context;
    private MarshallerHelper marshallerHelper;

    public TaskAssigningRuntimeResource(TaskAssigningRuntimeServiceBase runtimeServiceBase, KieServerRegistry context) {
        this.runtimeServiceBase = runtimeServiceBase;
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    @ApiOperation(value="Executes a planning into the processes runtime.", notes="This operation is intended for the task assigning integration implementation, third parties should avoid using it.", response=PlanningExecutionResult.class)
    @POST
    @Path(value="executeplanning")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response executePlanning(@Context HttpHeaders headers, @ApiParam(value="identifier of the user to execute the planning on behalf of", required=true) @QueryParam(value="user") String userId, @ApiParam(value="planning definition represented as PlanningItemList", required=true) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            PlanningItemList planningItemList = (PlanningItemList)this.marshallerHelper.unmarshal(payload, contentType, PlanningItemList.class);
            PlanningExecutionResult result = this.runtimeServiceBase.executePlanning(planningItemList, userId);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error executing planning {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Executes the task assigning integration query for returning the tasks information as a TaskDataList.", notes="This operation is mainly intended for the tasks assigning integration implementation, third parties are recommended to use the queries described in the task assigning getting started guide.", response=TaskDataList.class)
    @POST
    @Path(value="queries/taskdata")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response executeTasksQuery(@Context HttpHeaders headers, @ApiParam(value="map with the query parameters", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"fromTaskId\" : 0,\n  \"page\" : 0,\n  \"pageSize\" : 30,\n  \"status\" : [ \"Reserved\", \"InProgress\", \"Suspended\" ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>fromTaskId</key>\n            <value xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n        <entry>\n            <key>page</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n        <entry>\n            <key>pageSize</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">30</value>\n        </entry>\n        <entry>\n            <key>status</key>\n            <value xsi:type=\"jaxbList\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <items>\n                    <items xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">Reserved</items>\n                    <items xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">InProgress</items>\n                    <items xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">Suspended</items>\n                </items>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            Map queryParameters = (Map)this.marshallerHelper.unmarshal(payload, contentType, Map.class);
            LocalDateTime queryTime = LocalDateTime.now();
            List taskDataList = this.runtimeServiceBase.executeFindTasksQuery(queryParameters);
            TaskDataList result = new TaskDataList(taskDataList);
            result.setQueryTime(queryTime);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error finding tasks {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

