/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.services.api.DeploymentEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetricsProvider;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;

class PrometheusCustomMetricsSupport {
    private final Map<Class, List<?>> customMetricsInstances;
    private final Map<MultiKey, List<AgendaEventListener>> agendaEventListeners;
    private final Map<String, List<DMNRuntimeEventListener>> dmnRuntimeEventListeners;
    private final Map<String, List<PhaseLifecycleListener>> phaseLifecycleListeners;
    private ServiceLoader<PrometheusMetricsProvider> loader = ServiceLoader.load(PrometheusMetricsProvider.class);

    PrometheusCustomMetricsSupport(PrometheusKieServerExtension extension) {
        this.customMetricsInstances = new HashMap();
        this.agendaEventListeners = new HashMap<MultiKey, List<AgendaEventListener>>();
        this.dmnRuntimeEventListeners = new HashMap<String, List<DMNRuntimeEventListener>>();
        this.phaseLifecycleListeners = new HashMap<String, List<PhaseLifecycleListener>>();
    }

    boolean hasCustomMetrics() {
        return this.loader.iterator().hasNext();
    }

    List<PrometheusMetricsProvider> customMetricsProviders() {
        ArrayList<PrometheusMetricsProvider> providers = new ArrayList<PrometheusMetricsProvider>();
        this.loader.forEach(p -> providers.add((PrometheusMetricsProvider)p));
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DMNRuntimeEventListener> getDMNRuntimeEventListener(KieContainerInstance kContainer) {
        Map<String, List<DMNRuntimeEventListener>> map = this.dmnRuntimeEventListeners;
        synchronized (map) {
            if (!this.dmnRuntimeEventListeners.containsKey(kContainer.getContainerId())) {
                ArrayList customListeners = new ArrayList();
                this.loader.forEach(p -> {
                    DMNRuntimeEventListener l = p.createDMNRuntimeEventListener(kContainer);
                    if (l != null) {
                        customListeners.add(l);
                    }
                });
                this.dmnRuntimeEventListeners.put(kContainer.getContainerId(), customListeners);
            }
            return this.dmnRuntimeEventListeners.get(kContainer.getContainerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AgendaEventListener> getAgendaEventListener(String kieSessionId, KieContainerInstance kContainer) {
        MultiKey key = new MultiKey((Object)kieSessionId, (Object)kContainer);
        Map<MultiKey, List<AgendaEventListener>> map = this.agendaEventListeners;
        synchronized (map) {
            if (!this.agendaEventListeners.containsKey(key)) {
                ArrayList customListeners = new ArrayList();
                this.loader.forEach(p -> {
                    AgendaEventListener l = p.createAgendaEventListener(kieSessionId, kContainer);
                    if (l != null) {
                        customListeners.add(l);
                    }
                });
                this.agendaEventListeners.put(key, customListeners);
            }
            return this.agendaEventListeners.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAgendaEventListener(KieContainerInstance kieContainerInstanceId) {
        Map<MultiKey, List<AgendaEventListener>> map = this.agendaEventListeners;
        synchronized (map) {
            this.agendaEventListeners.entrySet().removeIf(entry -> {
                KieContainerInstance kieContainerInstanceKey = (KieContainerInstance)((MultiKey)entry.getKey()).getKey(1);
                return kieContainerInstanceKey.equals(kieContainerInstanceId);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PhaseLifecycleListener> getPhaseLifecycleListener(String solverId) {
        Map<String, List<PhaseLifecycleListener>> map = this.phaseLifecycleListeners;
        synchronized (map) {
            if (!this.phaseLifecycleListeners.containsKey(solverId)) {
                ArrayList customListeners = new ArrayList();
                this.loader.forEach(p -> {
                    PhaseLifecycleListener l = p.createPhaseLifecycleListener(solverId);
                    if (l != null) {
                        customListeners.add(l);
                    }
                });
                this.phaseLifecycleListeners.put(solverId, customListeners);
            }
            return this.phaseLifecycleListeners.get(solverId);
        }
    }

    List<AsynchronousJobListener> getAsynchronousJobListener() {
        return this.getListener(AsynchronousJobListener.class);
    }

    List<DeploymentEventListener> getDeploymentEventListener() {
        return this.getListener(DeploymentEventListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getListener(Class<T> clazz) {
        Map<Class, List<?>> map = this.customMetricsInstances;
        synchronized (map) {
            if (!this.customMetricsInstances.containsKey(clazz)) {
                ArrayList customMetricsTargets = new ArrayList();
                this.loader.forEach(p -> {
                    Object l = this.createListener((PrometheusMetricsProvider)p, clazz);
                    if (l != null) {
                        customMetricsTargets.add(l);
                    }
                });
                this.customMetricsInstances.put(clazz, customMetricsTargets);
            }
            return this.customMetricsInstances.get(clazz);
        }
    }

    private <T> T createListener(PrometheusMetricsProvider p, Class<T> clazz) {
        DeploymentEventListener l = null;
        if (DeploymentEventListener.class.isAssignableFrom(clazz)) {
            l = p.createDeploymentEventListener();
        }
        if (AsynchronousJobListener.class.isAssignableFrom(clazz)) {
            l = p.createAsynchronousJobListener();
        }
        return (T)l;
    }
}

