/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.Summary;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class PrometheusMetrics {
    private static final long NANOSECONDS_PER_MICROSECOND = 1000000L;
    private static final long HALF_SECOND_NANO = 500000000L;
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private static double[] ONE_TO_FIVE = PrometheusMetrics.rangeNano(1, 5);
    private static final double[] DECISION_TIME_BUCKETS = ArrayUtils.addAll((double[])PrometheusMetrics.rangeMicro(1, 10), (double[])ONE_TO_FIVE);
    private static final Histogram dmnEvaluationTimeHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("dmn_evaluate_decision_nanosecond")).help("DMN Evaluation Time")).labelNames(new String[]{"container_id", "group_id", "artifact_id", "version", "decision_namespace", "decision_name"})).buckets(DECISION_TIME_BUCKETS).register();
    private static final Counter dmnNumberOfEvaluationFailed = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("dmn_evaluate_failed_count")).help("DMN Evaluation Failed")).labelNames(new String[]{"container_id", "group_id", "artifact_id", "version", "decision_namespace", "decision_name"})).register();
    private static final double[] RULE_TIME_BUCKETS = ArrayUtils.addAll((double[])PrometheusMetrics.rangeMicro(1, 10), (double[])ONE_TO_FIVE);
    private static final Histogram droolsEvaluationTimeHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("drl_match_fired_nanosecond")).help("Drools Firing Time")).labelNames(new String[]{"container_id", "ksessionId", "group_id", "artifact_id", "version", "rule_name"})).buckets(RULE_TIME_BUCKETS).register();
    private static final Summary optaPlannerSolverDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("solver_duration_seconds")).help("Time in seconds it took solver to solve the constraint problem")).labelNames(new String[]{"solver_id"})).register();
    private static final Summary optaPlannerSolverScoreCalculationSpeed = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("solver_score_calculation_speed")).help("Number of moves per second for a particular solver solving the constraint problem")).labelNames(new String[]{"solver_id"})).register();
    private static final Gauge optaPlannerSolverCount = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("solvers_running")).help("Number of solvers currently running")).register();

    private static long toNano(long second) {
        return second * 1000000000L;
    }

    private static long toMicro(long second) {
        return second * 1000000L;
    }

    private static double[] rangeNano(int start, int end) {
        return IntStream.range(start, end).mapToDouble(l -> PrometheusMetrics.toNano(l)).toArray();
    }

    private static double[] rangeMicro(int start, int end) {
        return IntStream.range(start, end).mapToDouble(l -> PrometheusMetrics.toMicro(l)).toArray();
    }

    protected static double millisToSeconds(long millis) {
        return (double)millis / 1000.0;
    }

    Histogram getEvaluationTimeHistogram() {
        return dmnEvaluationTimeHistogram;
    }

    Counter getDMNNumberOfEvaluationFailed() {
        return dmnNumberOfEvaluationFailed;
    }

    Histogram getDroolsEvaluationTimeHistogram() {
        return droolsEvaluationTimeHistogram;
    }

    Summary getOptaPlannerSolverDuration() {
        return optaPlannerSolverDuration;
    }

    Summary getOptaPlannerSolverScoreCalculationSpeed() {
        return optaPlannerSolverScoreCalculationSpeed;
    }

    Gauge getOptaPlannerSolverCount() {
        return optaPlannerSolverCount;
    }
}

