/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.instance;

import java.util.Arrays;
import java.util.List;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.definition.process.Node;

public class RuleFlowProcessInstance
extends WorkflowProcessInstanceImpl {
    private static final long serialVersionUID = 510L;

    public RuleFlowProcess getRuleFlowProcess() {
        return (RuleFlowProcess)this.getProcess();
    }

    @Override
    public void internalStart(String trigger) {
        StartNode startNode = this.getRuleFlowProcess().getStart(trigger);
        if (startNode != null) {
            this.getNodeInstance(startNode).trigger(null, null);
        } else if (!this.getRuleFlowProcess().isDynamic()) {
            throw new IllegalArgumentException("There is no start node that matches the trigger " + (trigger == null ? "none" : trigger));
        }
        List<Node> autoStartNodes = this.getRuleFlowProcess().getAutoStartNodes();
        autoStartNodes.forEach(austoStartNode -> this.signalEvent(austoStartNode.getName(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessFromNodeIds(String[] nodeIds) {
        RuleFlowProcessInstance ruleFlowProcessInstance = this;
        synchronized (ruleFlowProcessInstance) {
            this.registerExternalEventNodeListeners();
            if (this.getState() != 0) {
                throw new IllegalArgumentException("A process instance can only be started once");
            }
            this.setState(1);
            Arrays.stream(nodeIds).forEach(nodeId -> this.trigger((String)nodeId));
        }
    }

    private void trigger(String nodeId) {
        Node node = this.getRuleFlowProcess().getNodeByUniqueId(nodeId);
        if (node == null) {
            node = this.getRuleFlowProcess().getNodesRecursively().stream().filter(ni -> nodeId.equals(ni.getNodeUniqueId())).findFirst().orElse(null);
            if (node == null) {
                throw new RuntimeException("Node with id " + nodeId + " not found");
            }
            Node parentNode = this.getRuleFlowProcess().getParentNode(node.getId());
            NodeInstanceContainer parentContainer = (NodeInstanceContainer)((Object)this.getNodeInstance(parentNode, false));
            parentContainer.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
        } else {
            this.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
        }
    }
}

